/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.upb.tools.fca.FHashMap;
import java.awt.Font;

public final class FontContainer {
    public static final int DEFAULT_FONT = 0;
    public static final int JAVA_SOURCE_FONT = 1;
    public static final int DEFAULT_FONT_SIZE = 12;
    private static int scale = 0;
    protected static FHashMap fonts = new FHashMap();

    public static int getScale() {
        return scale;
    }

    public static void setScale(int newScale) {
        scale = newScale;
    }

    public static Font getFont(int type, int style, int size) {
        if (type < 0 || type > 99) {
            throw new IllegalArgumentException("illegal font type");
        }
        if (size < -99 || size > 99) {
            throw new IllegalArgumentException("illegal font size");
        }
        Integer key = new Integer(type + (size + scale + 100) * 100 + style * 100000);
        Font font = (Font)fonts.get(key);
        if (font == null) {
            if (type == 0) {
                font = new Font("SansSerif", style, 12 + size + scale);
            } else if (type == 1) {
                font = new Font("Monospaced", style, 12 + size + scale);
            } else {
                throw new IllegalArgumentException("illegal font type");
            }
            fonts.put(key, font);
        }
        return font;
    }

    public static Font getFont(int type, int size) {
        return FontContainer.getFont(type, 0, size);
    }

    public static Font getFont(int type) {
        return FontContainer.getFont(type, 0, 0);
    }

    public static Font getDefaultFont() {
        return FontContainer.getFont(0, 0, 0);
    }

    public static Font getJavaSourceFont() {
        return FontContainer.getFont(1, 0, 0);
    }
}

