/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.IteratorConcatenation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class FujabaPropertyChangeSupport
extends PropertyChangeSupport {
    private transient Vector listeners;
    private transient Hashtable children;
    private Object source;
    static final long serialVersionUID = 7162625831330845068L;

    public FujabaPropertyChangeSupport(Object sourceBean) {
        super(sourceBean);
        this.setSource(sourceBean);
    }

    public boolean setSource(Object source) {
        if (this.source != source) {
            this.source = source;
            return true;
        }
        return false;
    }

    public Object getSource() {
        return this.source;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addToListeners(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addToListeners(PropertyChangeListener listener) {
        if (this.listeners == null || !this.listeners.contains(listener)) {
            this.removeFromListeners(null, listener);
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.addElement(listener);
            }
            return true;
        }
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removeFromListeners(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeFromListeners(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return this.removeFromListeners(null, listener);
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            return this.listeners.removeElement(listener) || this.removeFromListeners(null, listener);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.addToListeners(propertyName, listener);
    }

    public synchronized boolean addToListeners(String propertyName, PropertyChangeListener listener) {
        if (propertyName == null) {
            return this.addToListeners(listener);
        }
        if (!this.hasInListeners(listener) && !this.hasInListeners(propertyName, listener)) {
            FujabaPropertyChangeSupport child;
            if (this.children == null) {
                this.children = new Hashtable();
            }
            if ((child = (FujabaPropertyChangeSupport)this.children.get(propertyName)) == null) {
                child = new FujabaPropertyChangeSupport(this.source);
                this.children.put(propertyName, child);
            }
            child.addPropertyChangeListener(listener);
            return true;
        }
        return false;
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.removeFromListeners(propertyName, listener);
    }

    public synchronized boolean removeFromListeners(String propertyName, PropertyChangeListener listener) {
        if (this.children == null) {
            return false;
        }
        if (propertyName != null) {
            FujabaPropertyChangeSupport child = (FujabaPropertyChangeSupport)this.children.get(propertyName);
            if (child == null) {
                return false;
            }
            return child.removeFromListeners(listener);
        }
        boolean changed = false;
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            changed |= ((FujabaPropertyChangeSupport)childIter.next()).removeFromListeners(listener);
        }
        return changed;
    }

    public synchronized boolean hasListeners(String propertyName) {
        FujabaPropertyChangeSupport child;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && (child = (FujabaPropertyChangeSupport)this.children.get(propertyName)) != null) {
            return !child.listeners.isEmpty();
        }
        return false;
    }

    public synchronized boolean hasInListeners(PropertyChangeListener listener) {
        return this.listeners != null && this.listeners.contains(listener);
    }

    public synchronized boolean hasInListeners(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.children == null) {
            return false;
        }
        if (propertyName != null) {
            FujabaPropertyChangeSupport child = (FujabaPropertyChangeSupport)this.children.get(propertyName);
            if (child != null) {
                return child.hasInListeners(listener);
            }
            return false;
        }
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            if (!((FujabaPropertyChangeSupport)childIter.next()).hasInListeners(listener)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInAllListeners(PropertyChangeListener listener) {
        return this.hasInListeners(listener) || this.hasInListeners(null, listener);
    }

    public synchronized Iterator iteratorOfListeners() {
        return this.listeners == null ? FEmptyIterator.get() : this.listeners.iterator();
    }

    public synchronized Iterator iteratorOfAllListeners() {
        if (this.listeners == null) {
            return this.iteratorOfListeners(null);
        }
        if (this.children == null) {
            return this.iteratorOfListeners();
        }
        return new IteratorConcatenation(this.iteratorOfListeners(), this.iteratorOfListeners(null));
    }

    public synchronized Iterator iteratorOfListeners(String propertyName) {
        if (propertyName != null) {
            FujabaPropertyChangeSupport child;
            if (this.children != null && (child = (FujabaPropertyChangeSupport)this.children.get(propertyName)) != null) {
                return child.iteratorOfListeners();
            }
            return FEmptyIterator.get();
        }
        Iterator result = null;
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            FujabaPropertyChangeSupport child = (FujabaPropertyChangeSupport)childIter.next();
            if (child == null || child.listeners.size() == 0) continue;
            Iterator iter = child.iteratorOfListeners();
            result = result == null ? iter : new IteratorConcatenation(result, iter);
        }
        if (result == null) {
            result = FEmptyIterator.get();
        }
        return result;
    }

    public int sizeOfListeners() {
        return this.listeners == null ? 0 : this.listeners.size();
    }

    public int sizeOfAllListeners() {
        return this.sizeOfListeners() + this.sizeOfListeners(null);
    }

    public int sizeOfListeners(String propertyName) {
        if (propertyName != null) {
            FujabaPropertyChangeSupport child;
            if (this.children != null && (child = (FujabaPropertyChangeSupport)this.children.get(propertyName)) != null) {
                return child.sizeOfListeners();
            }
            return 0;
        }
        int result = 0;
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            FujabaPropertyChangeSupport child = (FujabaPropertyChangeSupport)childIter.next();
            if (child == null) continue;
            result += child.listeners.size();
        }
        return result;
    }

    public Iterator iteratorOfChildren() {
        return this.children == null ? FEmptyIterator.get() : this.children.values().iterator();
    }

    public Iterator keysOfChildren() {
        return this.children == null ? FEmptyIterator.get() : this.children.keySet().iterator();
    }

    public Iterator entriesOfChildren() {
        return this.children == null ? FEmptyIterator.get() : this.children.entrySet().iterator();
    }

    public FujabaPropertyChangeSupport getFromChildren(String propertyName) {
        return this.children == null ? null : (FujabaPropertyChangeSupport)this.children.get(propertyName);
    }

    public int sizeOfChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue) || newValue != null && newValue.equals(oldValue)) {
            return;
        }
        FujabaPropertyChangeSupport child = null;
        FujabaPropertyChangeSupport fujabaPropertyChangeSupport = this;
        synchronized (fujabaPropertyChangeSupport) {
            if (this.children != null && propertyName != null) {
                child = (FujabaPropertyChangeSupport)this.children.get(propertyName);
            }
        }
        if (this.listeners != null || child != null) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
            if (this.listeners != null) {
                Vector vector = this.listeners;
                synchronized (vector) {
                    ArrayList tmpListeners = new ArrayList(this.listeners.size());
                    tmpListeners.addAll(this.listeners);
                    int i = 0;
                    while (i < tmpListeners.size()) {
                        PropertyChangeListener target = (PropertyChangeListener)tmpListeners.get(i);
                        if (this.listeners.contains(target)) {
                            target.propertyChange(evt);
                        }
                        ++i;
                    }
                }
            }
            if (child != null) {
                child.firePropertyChange(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        FujabaPropertyChangeSupport child = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.children != null && propertyName != null) {
                child = (FujabaPropertyChangeSupport)this.children.get(propertyName);
            }
        }
        if (this.listeners != null) {
            serializable = this.listeners;
            synchronized (serializable) {
                ArrayList tmpListeners = new ArrayList(this.listeners.size());
                tmpListeners.addAll(this.listeners);
                int i = 0;
                while (i < tmpListeners.size()) {
                    PropertyChangeListener target = (PropertyChangeListener)tmpListeners.get(i);
                    if (this.listeners.contains(target)) {
                        target.propertyChange(evt);
                    }
                    ++i;
                }
            }
        }
        if (child != null) {
            child.firePropertyChange(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeYou() {
        this.source = null;
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.clear();
            }
        }
        if (this.children != null) {
            Iterator iter = this.iteratorOfChildren();
            while (iter.hasNext()) {
                FujabaPropertyChangeSupport child = (FujabaPropertyChangeSupport)iter.next();
                child.removeYou();
            }
            this.children.clear();
        }
    }
}

