/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.basic;

import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.basic.TemplateCodeBlock;
import de.uni_paderborn.fujaba.basic.TemplateManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TemplateFile {
    private static final transient Logger log;
    private String filename = "";
    private long modifiedTag = 0L;
    private TemplateManager manager;
    private FHashMap codeBlocks;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.basic.TemplateFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public TemplateFile(String filename) {
        this.setFilename(filename);
    }

    public void setFilename(String filename) {
        if (this.filename == null || !this.filename.equals(filename)) {
            TemplateManager oldManager = this.getManager();
            this.setManager(null);
            this.filename = filename;
            this.setManager(oldManager);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setModifiedTag(long tag) {
        this.modifiedTag = tag;
    }

    public long getModifiedTag() {
        return this.modifiedTag;
    }

    public boolean setManager(TemplateManager obj) {
        boolean changed = false;
        if (this.manager != obj) {
            if (this.manager != null) {
                TemplateManager oldValue = this.manager;
                this.manager = null;
                oldValue.removeFromTemplates(this);
            }
            this.manager = obj;
            if (obj != null) {
                obj.addToTemplates(this);
            }
            changed = true;
        }
        return changed;
    }

    public TemplateManager getManager() {
        return this.manager;
    }

    public boolean hasInCodeBlocks(TemplateCodeBlock obj) {
        return this.codeBlocks != null && obj != null && obj.getName() != null && this.codeBlocks.get(obj.getName()) == obj;
    }

    public boolean hasKeyInCodeBlocks(String key) {
        return this.codeBlocks != null && key != null && this.codeBlocks.containsKey(key);
    }

    public Iterator iteratorOfCodeBlocks() {
        return this.codeBlocks == null ? FEmptyIterator.get() : this.codeBlocks.values().iterator();
    }

    public Iterator keysOfCodeBlocks() {
        return this.codeBlocks == null ? FEmptyIterator.get() : this.codeBlocks.keySet().iterator();
    }

    public Iterator entriesOfCodeBlocks() {
        return this.codeBlocks == null ? FEmptyIterator.get() : this.codeBlocks.entrySet().iterator();
    }

    public int sizeOfCodeBlocks() {
        return this.codeBlocks == null ? 0 : this.codeBlocks.size();
    }

    public TemplateCodeBlock getFromCodeBlocks(String key) {
        return this.codeBlocks == null || key == null ? null : (TemplateCodeBlock)this.codeBlocks.get(key);
    }

    public boolean addToCodeBlocks(TemplateCodeBlock obj) {
        boolean changed = false;
        if (obj != null && obj.getName() != null) {
            TemplateCodeBlock oldValue;
            if (this.codeBlocks == null) {
                this.codeBlocks = new FHashMap();
            }
            if ((oldValue = (TemplateCodeBlock)this.codeBlocks.put(obj.getName(), obj)) != obj) {
                if (oldValue != null) {
                    oldValue.setTemplate(null);
                }
                obj.setTemplate(this);
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromCodeBlocks(TemplateCodeBlock obj) {
        TemplateCodeBlock oldValue;
        boolean changed = false;
        if (this.codeBlocks != null && obj != null && obj.getName() != null && (oldValue = (TemplateCodeBlock)this.codeBlocks.get(obj.getName())) == obj) {
            this.codeBlocks.remove(obj.getName());
            obj.setTemplate(null);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromCodeBlocks(String key) {
        TemplateCodeBlock tmpObj;
        boolean changed = false;
        if (this.codeBlocks != null && key != null && (tmpObj = (TemplateCodeBlock)this.codeBlocks.get(key)) != null) {
            this.codeBlocks.remove(key);
            tmpObj.setTemplate(null);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromCodeBlocks() {
        Iterator iter = this.iteratorOfCodeBlocks();
        while (iter.hasNext()) {
            TemplateCodeBlock tmpObj = (TemplateCodeBlock)iter.next();
            this.removeFromCodeBlocks(tmpObj);
        }
    }

    public boolean isModified() {
        boolean modified = false;
        File file = new File(this.getFilename());
        if (file.exists() && file.lastModified() > this.getModifiedTag()) {
            modified = true;
        }
        return modified;
    }

    private BufferedReader open() throws IOException {
        BufferedReader in = null;
        try {
            File file = new File(FujabaApp.FUJABA_BASE.resolve(this.getFilename()));
            this.setModifiedTag(file.lastModified());
            in = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            in = this.openUsingClassLoader();
        }
        catch (IllegalArgumentException e) {
            in = this.openUsingClassLoader();
        }
        return in;
    }

    protected BufferedReader openUsingClassLoader() throws IOException {
        URL url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.basic.TemplateFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = clazz.getResource("/" + this.getFilename())) == null) {
            throw new FileNotFoundException(this.getFilename());
        }
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    protected void parse() {
        this.removeAllFromCodeBlocks();
        try {
            String str;
            BufferedReader in = this.open();
            while ((str = in.readLine()) != null) {
                this.processLine(str, in);
            }
            in.close();
        }
        catch (IOException e) {
            log.info((Object)"Failed loading assoc template file! Code generation for assocs disabled!");
            e.printStackTrace();
        }
    }

    protected void processLine(String line, BufferedReader in) {
        String str = line.trim();
        if (str != null && !str.equals("") && str.charAt(0) == '#' && str.startsWith("BeginCodeBlock", 1)) {
            String codeBlockName = this.retrieveCodeBlockName(str);
            if (codeBlockName != null && !codeBlockName.equals("")) {
                TemplateCodeBlock block = new TemplateCodeBlock(codeBlockName);
                block.parse(in);
                this.addToCodeBlocks(block);
            } else {
                log.info((Object)"Error in template: No name for code block.");
            }
        }
    }

    protected String retrieveCodeBlockName(String line) {
        String codeBlockName = null;
        int index = line.indexOf(61);
        if (index > -1 && index < line.length()) {
            codeBlockName = line.substring(index + 1, line.length());
            codeBlockName = codeBlockName.trim();
        }
        return codeBlockName;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("TemplateFile[filename=");
        result.append(this.filename);
        result.append("]");
        return result.toString();
    }
}

