/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.basic.TemplateCodeBlock;
import de.uni_paderborn.fujaba.basic.TemplateFile;
import de.uni_paderborn.fujaba.basic.TemplateManager;
import de.uni_paderborn.fujaba.codegen.AccessMethodRef;
import de.uni_paderborn.fujaba.codegen.OOGenStrategyClient;
import de.uni_paderborn.fujaba.codegen.OOGenStrategyHandler;
import de.uni_paderborn.fujaba.codegen.OOGenToken;
import de.uni_paderborn.fujaba.codegen.TemplateParameterListener;
import de.uni_paderborn.fujaba.fsa.swing.MethodComparator;
import de.uni_paderborn.fujaba.gui.TemplateBlockNameListener;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FCommentary;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.upb.tools.fca.FHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public abstract class AccessorOOHandler
extends OOGenStrategyHandler {
    private static final transient Logger log;
    private LinkedHashSet generatedIncrs;
    private static HashSet templateBlockNameListeners;
    private static LinkedHashSet globalTemplateParameterListeners;
    private LinkedHashSet templateParameterListeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.AccessorOOHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public OOGenToken generateSourceCode(FElement asgElement, OOGenToken prevToken, Object[] param) {
        this.generateAccessors(asgElement);
        return null;
    }

    public boolean needToken() {
        return false;
    }

    protected abstract String getTemplateFileName(FElement var1);

    protected abstract FAttr createAccessorDescriptions(FElement var1, Set var2);

    public abstract FClass getTarget(FElement var1, FAttr var2);

    protected void generateAccessors(FElement element) {
        TreeSet accessMethods = new TreeSet();
        FAttr attr = this.createAccessorDescriptions(element, accessMethods);
        Iterator methodDescriptions = accessMethods.iterator();
        while (methodDescriptions.hasNext()) {
            MethodDescription description = (MethodDescription)methodDescriptions.next();
            this.generateMethod(element, attr, description);
        }
        this.removeGeneratedIncrs();
    }

    protected void generateMethod(FElement element, FAttr attr, MethodDescription description) {
        FMethod umlMethod;
        FClass target = this.getTarget(element, attr);
        FMethod existingMethod = target.getFromFMethods((umlMethod = description.getMethodSignature()).getFullMethodName());
        if (existingMethod != null && (existingMethod.isGenerated() || existingMethod.getDisplayLevel() <= 0)) {
            existingMethod.removeYou();
            existingMethod = null;
        }
        if (existingMethod == null) {
            FHashMap templateParameters = description.getTemplateParameters();
            this.changeTemplateParameters(element, attr, description.getTemplateBlockName(), templateParameters);
            String code = this.createTemplateCode(element, attr, templateParameters, description.getTemplateBlockName());
            if (!this.isInterface(target)) {
                umlMethod.setMethodBody(code, true);
            }
            umlMethod.setParent(target);
            this.getClientOfChain().generateSourceCodeFor(umlMethod, null, null);
            umlMethod.setParent(null);
        } else {
            this.getClientOfChain().generateSourceCodeFor(existingMethod, null, null);
            AccessMethodRef.createAssociation(existingMethod, element);
        }
        umlMethod.removeYou();
    }

    private boolean isInterface(FClass target) {
        return target.hasInStereotypes(UMLStereotypeManager.get().getFromStereotypes("interface"));
    }

    protected void generateAttrCode(FAttr attr) {
        OOGenStrategyClient client = (OOGenStrategyClient)this.getClientOfChain();
        if (!this.isInterface(attr.getFParent())) {
            FCommentary fCommentary = attr.getFComment();
            if (fCommentary != null) {
                String commentaryText = attr.isParsed() ? fCommentary.getText() : client.createFAttrCommentary(fCommentary);
                client.appendFAttrCommentary(commentaryText);
            }
            String umlAttrDecl = client.createFAttrDeclaration(attr);
            client.appendFAttrDeclaration(umlAttrDecl);
        }
    }

    public String createTemplateCode(FElement element, FAttr attr, FHashMap templateParameters, String blockName) {
        String realBlockName;
        FClass target = this.getTarget(element, attr);
        String code = "";
        TemplateFile templateFile = TemplateManager.get().getTemplate(this.getTemplateFileName(element));
        TemplateCodeBlock templateCodeBlock = templateFile.getFromCodeBlocks(realBlockName = AccessorOOHandler.getTemplateBlockName(blockName, target, attr));
        if (templateCodeBlock != null) {
            code = templateCodeBlock.getSourceCode(templateParameters);
        }
        return code;
    }

    public void addToGeneratedIncrs(FElement incr) {
        if (this.generatedIncrs == null) {
            this.generatedIncrs = new LinkedHashSet();
        }
        if (!this.generatedIncrs.contains(incr)) {
            this.generatedIncrs.add(incr);
        }
    }

    public boolean hasInGeneratedIncrs(FElement elem) {
        return this.generatedIncrs != null && this.generatedIncrs.contains(elem);
    }

    protected void removeGeneratedIncrs() {
        if (this.generatedIncrs != null) {
            FElement incr;
            LinkedList<FElement> reverseOrder = new LinkedList<FElement>();
            Iterator iter = this.generatedIncrs.iterator();
            while (iter.hasNext()) {
                incr = (FElement)iter.next();
                reverseOrder.addFirst(incr);
            }
            this.generatedIncrs.clear();
            iter = reverseOrder.iterator();
            while (iter.hasNext()) {
                incr = (FElement)iter.next();
                incr.removeYou();
            }
        }
    }

    public void removeOldAccessors(FElement element) {
        TreeSet accessMethods = new TreeSet();
        FAttr attr = this.createAccessorDescriptions(element, accessMethods);
        Iterator methodDescriptions = accessMethods.iterator();
        while (methodDescriptions.hasNext()) {
            MethodDescription description = (MethodDescription)methodDescriptions.next();
            this.removeOldMethod(element, attr, description);
        }
        this.removeGeneratedIncrs();
    }

    protected void removeOldMethod(FElement element, FAttr attr, MethodDescription description) {
        FMethod umlMethod;
        FClass target = this.getTarget(element, attr);
        FMethod existingMethod = target.getFromFMethods((umlMethod = description.getMethodSignature()).getFullMethodName());
        if (existingMethod != null) {
            if (existingMethod.isGenerated() || existingMethod.getDisplayLevel() <= 0) {
                existingMethod.removeYou();
            } else {
                log.error((Object)("Won't delete " + existingMethod.getFParent().getFullClassName() + "." + existingMethod.getName() + " because it seems to have been created manually"));
            }
        }
    }

    public static String getTemplateBlockName(String blockName, FClass cls, FAttr attr) {
        if (("accessor-set".equals(blockName) || "accessor-get".equals(blockName)) && attr != null && attr.isStatic()) {
            blockName = String.valueOf(blockName) + "-static";
        }
        if ("postHook-propertyChange".equals(blockName)) {
            if (cls.getFromAllFMethods("getPropertyChangeSupport()") != null) {
                blockName = String.valueOf(blockName) + "-support";
            } else if (attr != null && !attr.getFAttrType().getProgLangType().equals(attr.getFAttrType().getName())) {
                blockName = String.valueOf(blockName) + "-primitive";
            }
        }
        if (templateBlockNameListeners != null) {
            Iterator it = templateBlockNameListeners.iterator();
            while (it.hasNext()) {
                TemplateBlockNameListener listener = (TemplateBlockNameListener)it.next();
                blockName = listener.getTemplateBlockName(blockName, cls, attr);
            }
        }
        return blockName;
    }

    public static String appendPreHook(FHashMap templateParameters, String preHook) {
        return AccessorOOHandler.appendParameter(templateParameters, "$CHANGE_PREHOOK$", preHook);
    }

    public static String appendPostHook(FHashMap templateParameters, String postHook) {
        return AccessorOOHandler.appendParameter(templateParameters, "$CHANGE_POSTHOOK$", postHook);
    }

    public static String prependPreHook(FHashMap templateParameters, String preHook) {
        return AccessorOOHandler.prependParameter(templateParameters, "$CHANGE_PREHOOK$", preHook);
    }

    public static String prependPostHook(FHashMap templateParameters, String postHook) {
        return AccessorOOHandler.prependParameter(templateParameters, "$CHANGE_POSTHOOK$", postHook);
    }

    protected static String appendParameter(FHashMap templateParameters, String parameter, String value) {
        StringBuffer parameterBuffer = new StringBuffer();
        String oldValue = (String)templateParameters.get(parameter);
        if (oldValue != null) {
            parameterBuffer.append(oldValue);
        }
        if (value != null) {
            parameterBuffer.append(value);
        }
        value = parameterBuffer.toString();
        templateParameters.put(parameter, value);
        return value;
    }

    protected static String prependParameter(FHashMap templateParameters, String parameter, String value) {
        StringBuffer parameterBuffer = new StringBuffer();
        String oldValue = (String)templateParameters.get(parameter);
        if (value != null) {
            parameterBuffer.append(value);
        }
        if (oldValue != null) {
            parameterBuffer.append(oldValue);
        }
        value = parameterBuffer.toString();
        templateParameters.put(parameter, value);
        return value;
    }

    public static void addToTemplateBlockNameListeners(TemplateBlockNameListener listener) {
        if (listener != null) {
            if (templateBlockNameListeners == null) {
                templateBlockNameListeners = new HashSet();
            }
            templateBlockNameListeners.add(listener);
        }
    }

    public static void removeFromTemplateBlockNameListeners(TemplateBlockNameListener listener) {
        if (listener != null && templateBlockNameListeners != null) {
            templateBlockNameListeners.remove(listener);
        }
    }

    public static void addToGlobalTemplateParameterListeners(TemplateParameterListener listener) {
        if (listener != null) {
            if (globalTemplateParameterListeners == null) {
                globalTemplateParameterListeners = new LinkedHashSet();
            }
            globalTemplateParameterListeners.add(listener);
        }
    }

    public static void removeFromGlobalTemplateParameterListeners(TemplateParameterListener listener) {
        if (listener != null && globalTemplateParameterListeners != null) {
            globalTemplateParameterListeners.remove(listener);
        }
    }

    public static Iterator iteratorOfGlobalTemplateParameterListeners() {
        return globalTemplateParameterListeners == null ? Collections.EMPTY_SET.iterator() : globalTemplateParameterListeners.iterator();
    }

    public void addToTemplateParameterListeners(TemplateParameterListener listener) {
        if (listener != null) {
            if (this.templateParameterListeners == null) {
                this.templateParameterListeners = new LinkedHashSet();
            }
            this.templateParameterListeners.add(listener);
        }
    }

    public void removeFromTemplateParameterListeners(TemplateParameterListener listener) {
        if (listener != null && this.templateParameterListeners != null) {
            this.templateParameterListeners.remove(listener);
        }
    }

    protected void changeTemplateParameters(FElement element, FAttr attr, String blockName, FHashMap templateParameters) {
        TemplateParameterListener listener;
        Iterator iter;
        if (globalTemplateParameterListeners != null) {
            iter = globalTemplateParameterListeners.iterator();
            while (iter.hasNext()) {
                listener = (TemplateParameterListener)iter.next();
                listener.setupTemplateParameters(this, element, attr, blockName, templateParameters);
            }
        }
        if (this.templateParameterListeners != null) {
            iter = this.templateParameterListeners.iterator();
            while (iter.hasNext()) {
                listener = (TemplateParameterListener)iter.next();
                listener.setupTemplateParameters(this, element, attr, blockName, templateParameters);
            }
        }
    }

    public static final class MethodDescription
    implements Comparable {
        protected final FMethod methodSignature;
        protected final String templateBlockName;
        protected final FHashMap templateParameters;

        public MethodDescription(FMethod methodSignature, String templateBlockName, FHashMap templateParameters) {
            this.methodSignature = methodSignature;
            this.templateBlockName = templateBlockName;
            this.templateParameters = templateParameters;
        }

        public FMethod getMethodSignature() {
            return this.methodSignature;
        }

        public String getTemplateBlockName() {
            return this.templateBlockName;
        }

        public FHashMap getTemplateParameters() {
            return this.templateParameters;
        }

        public int compareTo(Object o) {
            MethodDescription description = (MethodDescription)o;
            return MethodComparator.get().compare(this.getMethodSignature(), description.getMethodSignature());
        }
    }
}

