/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.codegen.CodeGenStrategy;
import de.uni_paderborn.fujaba.metamodel.FElement;
import java.util.Arrays;
import java.util.LinkedList;

public abstract class CodeGenFunction {
    public static final int NORM = 0;
    public static final int PRE_ORDER = 1;
    public static final int IN_ORDER = 2;
    public static final int POST_ORDER = 3;
    private int mode;
    private CodeGenStrategy client;
    private CodeGenFunction successor;
    private CodeGenFunction prevFunction;

    public CodeGenFunction() {
        this(0);
    }

    public CodeGenFunction(int mode) {
        this.setMode(mode);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.mode = mode;
        }
    }

    public boolean setClient(CodeGenStrategy value) {
        if (this.client != value) {
            if (this.client != null) {
                CodeGenStrategy oldValue = this.client;
                this.client = null;
                oldValue.setFunction(null);
            }
            this.client = value;
            if (value != null) {
                this.client.setFunction(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenStrategy getClient() {
        return this.client;
    }

    public abstract boolean isResponsible(String var1);

    public final Object generateCode(String methodName, Object[] param) {
        return null;
    }

    public Object generateCode(FElement incr, String methodName, Object[] param) {
        return this.generateCode((ASGElement)incr, methodName, param);
    }

    public Object generateCode(ASGElement incr, String methodName, Object[] param) {
        throw new AbstractMethodError(String.valueOf(this.getClass().getName()) + " must implement generateCode(de.uni_paderborn.fujaba.metamodel.FElement, String, Object[])");
    }

    public Object generateCode(FElement incr, String methodName, Object[] param, Object prevResult) {
        return null;
    }

    public static CodeGenFunction findNextResponsible(CodeGenFunction function, String methodName) {
        while (function != null) {
            if (function.isResponsible(methodName)) {
                return function;
            }
            function = function.getSuccessor();
        }
        return null;
    }

    public final Object generate(FElement incr, String methodName, Object[] param) {
        Object resultA = null;
        Object resultB = null;
        if (!this.isResponsible(methodName)) {
            CodeGenFunction next = CodeGenFunction.findNextResponsible(this.getSuccessor(), methodName);
            if (next != null) {
                return next.generate(incr, methodName, param);
            }
            throw new IllegalStateException("methodName=" + methodName + ",param=" + Arrays.asList(param));
        }
        if (this.mode == 0) {
            return this.generateCode(incr, methodName, param);
        }
        if (this.mode == 1) {
            resultA = this.generateCode(incr, methodName, param);
            CodeGenFunction next = CodeGenFunction.findNextResponsible(this.getSuccessor(), methodName);
            if (next != null) {
                resultB = next.generate(incr, methodName, param);
            }
            return this.concat(resultA, resultB);
        }
        if (this.mode == 3) {
            resultA = this.generateCode(incr, methodName, param);
            CodeGenFunction next = CodeGenFunction.findNextResponsible(this.getSuccessor(), methodName);
            if (next != null) {
                resultB = next.generate(incr, methodName, param);
            }
            return this.concat(resultB, resultA);
        }
        if (this.mode == 2) {
            CodeGenFunction next = CodeGenFunction.findNextResponsible(this.getSuccessor(), methodName);
            if (next != null) {
                resultA = next.generate(incr, methodName, param);
            }
            return this.generateCode(incr, methodName, param, resultA);
        }
        throw new IllegalStateException("methodName=" + methodName + ",param=" + Arrays.asList(param) + ",mode=" + this.mode);
    }

    public final CodeGenStrategy getClientOfChain() {
        if (this.getClient() != null) {
            return this.getClient();
        }
        if (this.getPrevFunction() != null) {
            return this.getPrevFunction().getClientOfChain();
        }
        throw new Error("chain is corrupt !");
    }

    public LinkedList concat(Object a, Object b) {
        LinkedList result = new LinkedList();
        this.add(result, a);
        this.add(result, b);
        return result;
    }

    public void add(LinkedList theLinkedList, Object theObject) {
        if (theObject instanceof LinkedList) {
            theLinkedList.addAll((LinkedList)theObject);
        } else {
            theLinkedList.add(theObject);
        }
    }

    public boolean setSuccessor(CodeGenFunction value) {
        if (this.successor != value) {
            if (this.successor != null) {
                CodeGenFunction oldValue = this.successor;
                this.successor = null;
                oldValue.setPrevFunction(null);
            }
            this.successor = value;
            if (value != null) {
                this.successor.setPrevFunction(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenFunction getSuccessor() {
        return this.successor;
    }

    public boolean setPrevFunction(CodeGenFunction value) {
        if (this.prevFunction != value) {
            if (this.prevFunction != null) {
                CodeGenFunction oldValue = this.prevFunction;
                this.prevFunction = null;
                oldValue.setSuccessor(null);
            }
            this.prevFunction = value;
            if (value != null) {
                this.prevFunction.setSuccessor(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenFunction getPrevFunction() {
        return this.prevFunction;
    }

    public String toString() {
        return "CodeGenFunction[]";
    }
}

