/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.CodeGenFragment;
import de.uni_paderborn.fujaba.codegen.CodeGenStrategy;
import de.uni_paderborn.fujaba.codegen.TextFragment;
import de.uni_paderborn.fujaba.metamodel.FFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CodeGenVisitor {
    private static final transient Logger log;
    public static final String JAVA_VISITOR = "Java";
    public static final String EIFFEL_VISITOR = "Eiffel";
    public static final String GNU_CPP_CLASS_VISITOR = "GnuCPPClass";
    public static final String GNU_CPP_HEADER_VISITOR = "GnuCPPHeader";
    public static final String TMP_FILE_EXTENDER = "tmp";
    public String START_BLOCK_COMMENTARY = "/**";
    public String END_BLOCK_COMMENTARY = " */";
    public String LINE_IN_BLOCK_COMMENTARY = " * ";
    public String LINE_COMMENTARY = "//";
    public String INDENT_STRING = "   ";
    private CodeGenFragment firstFragment = null;
    private CodeGenFragment currentFragment = null;
    private File currentFile;
    private int indentNr;
    private String extender;
    private String path;
    private CodeGenStrategy currentStrategy;
    private String name;
    private CodeGenStrategy codeGenStrategy;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.CodeGenVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public CodeGenVisitor() {
    }

    public CodeGenVisitor(String extender) {
        this.setExtender(extender);
    }

    public final void createFiles(String path, String name) {
        if (log.isDebugEnabled()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this + ".createFiles(" + path + "," + name + ")"));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(this + ".creating:" + path + File.separator + name + "." + this.getExtender()));
            }
        }
        this.createDirectory(path);
        this.setCurrentFile(this.createFile(path, String.valueOf(name) + "." + this.getExtender()));
    }

    public void initBuffer() {
        this.setFirstFragment(null);
        this.setIndentNr(0);
    }

    public void initVisitor(String path, String name, boolean createFiles) {
        if (createFiles) {
            this.createFiles(path, name);
        }
        this.setPath(path);
        this.setName(name);
        this.initBuffer();
    }

    public void writeFiles() {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ".writeFiles ()"));
        }
        this.writeFragmentsToFile(this.getCurrentFile());
    }

    public final void createDirectory(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public final File createFile(String path, String name) {
        File newFile = new File(path, name);
        if (newFile.exists()) {
            File tmpFile = new File(path, String.valueOf(name) + "." + TMP_FILE_EXTENDER);
            tmpFile.delete();
            newFile.renameTo(tmpFile);
            newFile = new File(path, name);
        }
        return newFile;
    }

    public final boolean writeBufferToFile(StringBuffer theBuffer, File theFile) {
        boolean success = true;
        FileWriter theWriter = null;
        try {
            theWriter = new FileWriter(theFile);
            success = this.writeToStream(theBuffer.toString(), theWriter);
            theWriter.flush();
            theWriter.close();
        }
        catch (IOException exception) {
            log.error((Object)(this + ".writeBufferToFile(" + theBuffer + "," + theFile + ") failed !"));
            log.error((Object)("exception=" + exception));
            success = false;
        }
        return success;
    }

    public final boolean writeToStream(String text, Writer theWriter) {
        boolean success = true;
        try {
            theWriter.write(text, 0, text.length());
        }
        catch (IOException exception) {
            log.error((Object)(this + ".writeToStream(" + text + ") failed !"));
            log.error((Object)("exception=" + exception));
            success = false;
        }
        return success;
    }

    public final boolean writeFragmentToStream(CodeGenFragment fragment, Writer theWriter) {
        return this.writeToStream(fragment.getSourceCode(), theWriter);
    }

    public boolean writeFragmentsToStream(Writer theWriter) {
        CodeGenFragment fragment = this.getFirstFragment();
        boolean success = true;
        while (success && fragment != null) {
            success = this.writeFragmentToStream(fragment, theWriter);
            fragment = fragment.getNextFragment();
        }
        return success;
    }

    public final boolean writeFragmentsToFile(File theFile) {
        boolean success = true;
        FileWriter theWriter = null;
        try {
            theWriter = new FileWriter(theFile);
            success = this.writeFragmentsToStream(theWriter);
            theWriter.flush();
            theWriter.close();
        }
        catch (IOException exception) {
            log.error((Object)(this + ".writeFragmentsToFile(" + theFile + ") failed !"));
            log.error((Object)("exception=" + exception));
            success = false;
        }
        return success;
    }

    public void append(StringBuffer code) {
        this.getCurrentBuffer().append(code);
    }

    public void append(String code) {
        this.getCurrentBuffer().append(code);
    }

    public CodeGenFragment getFirstFragment() {
        return this.firstFragment;
    }

    public void setFirstFragment(CodeGenFragment fragment) {
        this.firstFragment = fragment;
        if (fragment != null) {
            while (fragment.getNextFragment() != null) {
                fragment = fragment.getNextFragment();
            }
        }
        this.currentFragment = fragment;
    }

    public CodeGenFragment getCurrentFragment() {
        return this.currentFragment;
    }

    public void appendFragment(CodeGenFragment fragment) {
        if (this.currentFragment != null) {
            this.currentFragment.setNextFragment(fragment);
            this.currentFragment = fragment;
        } else {
            this.setFirstFragment(fragment);
        }
    }

    public TextFragment appendTextFragment(String name) {
        TextFragment textFragment = new TextFragment(name);
        this.appendFragment(textFragment);
        return textFragment;
    }

    public boolean isCommentary(String text) {
        String regExpCommentary = "((\\s*/\\*(.|\\s)*\\*/\\s*)|(\\s*//.*\\s*))*";
        return text.matches(regExpCommentary);
    }

    public String removeIndentFromCommentary(String text) {
        StringTokenizer toki = new StringTokenizer(text, "\n");
        StringBuffer result = new StringBuffer();
        String currentToken = toki.nextToken();
        int pos = currentToken.indexOf(this.START_BLOCK_COMMENTARY);
        result.append(currentToken.substring(pos));
        result.append("\n");
        while (toki.hasMoreTokens()) {
            currentToken = toki.nextToken();
            result.append(currentToken.substring(pos));
            result.append("\n");
        }
        return result.toString();
    }

    public String createCommentary(String text) {
        if (!this.isCommentary(text)) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            StringBuffer comment = new StringBuffer();
            comment.append(this.START_BLOCK_COMMENTARY);
            comment.append("\n");
            while (tokenizer.hasMoreTokens()) {
                String currentToken = tokenizer.nextToken();
                comment.append(this.LINE_IN_BLOCK_COMMENTARY);
                comment.append(currentToken);
                comment.append("\n");
            }
            comment.append(this.END_BLOCK_COMMENTARY);
            comment.append("\n");
            text = comment.toString();
        }
        if (!(text = this.indentText(text)).endsWith("\n")) {
            text = String.valueOf(text) + "\n";
        }
        return text;
    }

    public String createLineCommentary(String text) {
        return String.valueOf(this.LINE_COMMENTARY) + " " + text;
    }

    public String indentText(String text, String indentString) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        StringBuffer indentBuffer = new StringBuffer();
        String currentToken = null;
        while (tokenizer.hasMoreTokens()) {
            currentToken = tokenizer.nextToken();
            indentBuffer.append(indentString);
            indentBuffer.append(currentToken);
            if (!tokenizer.hasMoreTokens()) continue;
            indentBuffer.append("\n");
        }
        return indentBuffer.toString();
    }

    public String createIndentString(String indentText, int nr) {
        StringBuffer indent = new StringBuffer();
        int i = 0;
        while (i < nr) {
            indent.append(indentText);
            ++i;
        }
        return indent.toString();
    }

    public final File getCurrentFile() {
        return this.currentFile;
    }

    public final void setCurrentFile(File currentFile) {
        if (this.currentFile != currentFile) {
            this.currentFile = currentFile;
        }
    }

    public final String createIndentString() {
        return this.createIndentString(this.INDENT_STRING, this.getIndentNr());
    }

    public final String indentText(String text) {
        return this.indentText(text, this.createIndentString());
    }

    public final void newLine() {
        this.getCurrentBuffer().append("\n");
    }

    public String getFileName(FFile theFile) {
        String name = theFile.getName();
        int pos = name.lastIndexOf(".");
        if (pos > -1) {
            return name.substring(0, pos - 1);
        }
        return name;
    }

    public final int getIndentNr() {
        return this.indentNr;
    }

    public final void setIndentNr(int indentNr) {
        if (this.indentNr != indentNr) {
            this.indentNr = indentNr;
        }
    }

    public final void incIndentNr() {
        ++this.indentNr;
    }

    public final void decIndentNr() {
        --this.indentNr;
    }

    public final String getExtender() {
        return this.extender;
    }

    public final void setExtender(String extender) {
        if (this.extender == null && extender != null || this.extender != null && !this.extender.equals(extender)) {
            this.extender = extender;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null || !path.equals(this.path)) {
            this.path = path;
        }
    }

    public boolean setCurrentStrategy(CodeGenStrategy value) {
        if (this.currentStrategy != value) {
            if (this.currentStrategy != null) {
                CodeGenStrategy oldValue = this.currentStrategy;
                this.currentStrategy = null;
                oldValue.setCurrentVisitor(null);
            }
            this.currentStrategy = value;
            if (value != null) {
                this.currentStrategy.setCurrentVisitor(this);
            }
            return true;
        }
        return false;
    }

    public CodeGenStrategy getCurrentStrategy() {
        return this.currentStrategy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || !name.equals(this.name)) {
            this.name = name;
        }
    }

    public boolean setCodeGenStrategy(CodeGenStrategy value) {
        boolean changed = false;
        if (this.codeGenStrategy != value) {
            if (this.codeGenStrategy != null) {
                CodeGenStrategy oldValue = this.codeGenStrategy;
                this.codeGenStrategy = null;
                oldValue.removeFromCodeGenVisitor(this);
            }
            this.codeGenStrategy = value;
            if (value != null) {
                value.addToCodeGenVisitor(this);
            }
            changed = true;
        }
        return changed;
    }

    public CodeGenStrategy getCodeGenStrategy() {
        return this.codeGenStrategy;
    }

    public final StringBuffer getCurrentBuffer() {
        CodeGenFragment currentFragment = this.getCurrentFragment();
        if (currentFragment instanceof TextFragment) {
            return ((TextFragment)currentFragment).getCodeBuffer();
        }
        TextFragment textFragment = this.appendTextFragment(null);
        return textFragment.getCodeBuffer();
    }

    public String toString() {
        return "CodeGenVisitor[]";
    }

    public void removeYou() {
        CodeGenStrategy tmpCodeGenStrategy = this.getCodeGenStrategy();
        if (tmpCodeGenStrategy != null) {
            this.setCodeGenStrategy(null);
        }
    }
}

