/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import java.util.HashSet;

public class JavaChecker {
    private final String[] javaKeywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
    private HashSet javaKeywordsSet;
    private static JavaChecker instance;

    private JavaChecker() {
        this.createJavaKeywordsSet();
    }

    public static JavaChecker get() {
        if (instance == null) {
            instance = new JavaChecker();
        }
        return instance;
    }

    private void createJavaKeywordsSet() {
        this.javaKeywordsSet = new HashSet();
        int i = 0;
        while (i < this.javaKeywords.length) {
            this.javaKeywordsSet.add(this.javaKeywords[i]);
            ++i;
        }
    }

    public boolean isValidJavaIdentifier(String name) {
        boolean valid = true;
        if (name.length() > 0) {
            char[] chars = name.toCharArray();
            valid = Character.isJavaIdentifierStart(chars[0]);
            int i = 1;
            while (i < chars.length) {
                if (!Character.isJavaIdentifierPart(chars[i])) {
                    valid = false;
                }
                ++i;
            }
        } else {
            valid = false;
        }
        if (valid) {
            valid = !this.javaKeywordsSet.contains(name);
        }
        return valid;
    }
}

