/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.OOClassOfVariableExpr;
import de.uni_paderborn.fujaba.codegen.OOCollectionEnum;
import de.uni_paderborn.fujaba.codegen.OOExpression;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorGetExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorGotoNextExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorHasNextExpr;
import de.uni_paderborn.fujaba.codegen.OOFWIteratorOfExpr;
import de.uni_paderborn.fujaba.codegen.OOGenVisitor;
import de.uni_paderborn.fujaba.codegen.OONewArrayExpr;
import de.uni_paderborn.fujaba.codegen.OOObjectOfTypeExpr;
import de.uni_paderborn.fujaba.codegen.OOThrowStatement;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import java.util.Iterator;

public class JavaGenVisitor
extends OOGenVisitor {
    public JavaGenVisitor(String extender) {
        super(extender);
    }

    public JavaGenVisitor() {
        this("java");
    }

    public String getReferenceTemplateName() {
        return "Templates/ReferenceTemplate.tpl";
    }

    public String getAssocTemplateName() {
        return "Templates/AssocTemplateFCA.tpl";
    }

    public String getContainerName(OOCollectionEnum containerType, boolean bound) {
        if (OOCollectionEnum.ITERATOR.equals(containerType)) {
            return "java.util.Iterator";
        }
        if (OOCollectionEnum.LIST_ITERATOR.equals(containerType)) {
            return "java.util.ListIterator";
        }
        if (OOCollectionEnum.KEY_VALUE_PAIR.equals(containerType)) {
            return "java.util.Map$Entry";
        }
        StringBuffer containerName = new StringBuffer();
        containerName.append("de.upb.tools.fca.F");
        if (bound) {
            containerName.append("Prop");
        }
        if (OOCollectionEnum.LIST.equals(containerType)) {
            containerName.append("LinkedList");
        } else if (OOCollectionEnum.HASHTABLE.equals(containerType)) {
            containerName.append("HashSet");
        } else if (OOCollectionEnum.SET.equals(containerType)) {
            containerName.append("HashSet");
        } else if (OOCollectionEnum.MAP.equals(containerType)) {
            containerName.append("HashMap");
        } else if (OOCollectionEnum.MULTI_MAP.equals(containerType)) {
            containerName.append("DuplicatedHashMap");
        } else if (OOCollectionEnum.TREESET.equals(containerType)) {
            containerName.append("TreeSet");
        } else if (OOCollectionEnum.SORTED_MAP.equals(containerType)) {
            containerName.append("TreeMap");
        } else if (OOCollectionEnum.SORTED_MULTI_MAP.equals(containerType)) {
            containerName.append("DuplicatedTreeMap");
        }
        return containerName.toString();
    }

    public void initProgLangTypes() {
        this.addToProgLangTypes("Initializer", "");
        this.addToProgLangTypes("Boolean", "boolean");
        this.addToProgLangTypes("Character", "char");
        this.addToProgLangTypes("String", "String");
        this.addToProgLangTypes("Integer", "int");
        this.addToProgLangTypes("Byte", "byte");
        this.addToProgLangTypes("ShortInteger", "short");
        this.addToProgLangTypes("LongInteger", "long");
        this.addToProgLangTypes("Float", "float");
        this.addToProgLangTypes("Double", "double");
        this.addToProgLangTypes("Void", "void");
        this.addToProgLangTypes("constructor", "");
        this.addToProgLangTypes("Constructor", "");
        this.addToProgLangTypes("BooleanArray", "boolean[]");
        this.addToProgLangTypes("CharacterArray", "char[]");
        this.addToProgLangTypes("StringArray", "String[]");
        this.addToProgLangTypes("IntegerArray", "int[]");
        this.addToProgLangTypes("ByteArray", "byte[]");
        this.addToProgLangTypes("ShortIntegerArray", "short[]");
        this.addToProgLangTypes("LongIntegerArray", "long[]");
        this.addToProgLangTypes("FloatArray", "float[]");
        this.addToProgLangTypes("DoubleArray", "double[]");
        this.addToProgLangTypes("ObjectArray", "Object[]");
        this.addToProgLangTypes("FWIterator", "Iterator");
    }

    public void initVisibilityStrings() {
        this.visibilityStrings = new String[]{"private", "public", "protected", "/*package*/", "/*user*/"};
    }

    public final String getSourceCode(OOThrowStatement statement) {
        StringBuffer result = new StringBuffer();
        result.append(this.createIndentString());
        result.append("throw new ");
        result.append(statement.getMyException().getSourceCode(this));
        result.append(" () ;");
        return result.toString();
    }

    public final String getSourceCode(OOObjectOfTypeExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getObjectName()));
        result.append(" instanceof ");
        result.append(this.getOOTypeAsString(expression.getTypeName()));
        return result.toString();
    }

    public final String getSourceCode(OOClassOfVariableExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getObjectName()));
        result.append(".getClass()");
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorOfExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getObjectName()));
        result.append(".iterator ()");
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorGetExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getObjectName()));
        result.append(".next ()");
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorHasNextExpr expression) {
        StringBuffer result = new StringBuffer();
        result.append(this.getVarName(expression.getIterName()));
        result.append(".hasNext ()");
        return result.toString();
    }

    public final String getSourceCode(OOFWIteratorGotoNextExpr expression) {
        return null;
    }

    public String getSourceCode(OONewArrayExpr expression) {
        StringBuffer result = new StringBuffer();
        Iterator iter = expression.iteratorOfParameter();
        result.append("new ");
        result.append(this.getOOTypeAsString(expression.getElementType()));
        result.append("[");
        if (!iter.hasNext()) {
            result.append(expression.getSizeExpr().getSourceCode(this));
        }
        result.append("] ");
        if (iter.hasNext()) {
            result.append("{");
            while (iter.hasNext()) {
                OOExpression tmpParameter = (OOExpression)iter.next();
                result.append(tmpParameter.getSourceCode(this));
                if (!iter.hasNext()) continue;
                result.append(", ");
            }
            result.append("}");
        }
        return result.toString();
    }

    public void generateClassEndBlock() {
        this.getCurrentBuffer().append(this.END_BLOCK);
        this.getCurrentBuffer().append("\n");
        this.decIndentNr();
    }

    public void generateClassStartBlock() {
        this.getCurrentBuffer().append(this.START_BLOCK);
        this.getCurrentBuffer().append("\n");
        this.incIndentNr();
    }

    public String generateImportPackage(FPackage thePackage) {
        String packageName = thePackage.getFullPackageName();
        if (packageName.length() > 0) {
            StringBuffer result = new StringBuffer();
            result.append("import ").append(packageName).append(".*;\n");
            return result.toString();
        }
        return "";
    }

    public String generateImportClass(FClass theClass) {
        StringBuffer result = new StringBuffer();
        result.append("import ").append(theClass.getFullClassName()).append(";\n");
        return result.toString();
    }

    public void generatePackageBegin(FFile theFile) {
        String packageName;
        FPackage thePackage = theFile.getFPackage();
        String string = packageName = thePackage != null ? thePackage.getFullPackageName() : "";
        if (packageName.length() > 0) {
            this.getCurrentBuffer().append("package ");
            this.getCurrentBuffer().append(packageName);
            this.getCurrentBuffer().append(";\n\n");
        }
    }

    public void generatePackageEnd(FFile theFile) {
    }

    public String getAttrDeclName(FAttr theAttr) {
        return theAttr.getName();
    }

    public String getMethodDeclName(FMethod theMethod) {
        return theMethod.getName();
    }

    public String toString() {
        return "JavaGenVisitor[]";
    }
}

