/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.CodeGenStrategy;
import de.uni_paderborn.fujaba.codegen.OO;
import de.uni_paderborn.fujaba.codegen.OODoStatement;
import de.uni_paderborn.fujaba.codegen.OOElseStatement;
import de.uni_paderborn.fujaba.codegen.OOExpression;
import de.uni_paderborn.fujaba.codegen.OOGenVisitor;
import de.uni_paderborn.fujaba.codegen.OOIdentifierExpr;
import de.uni_paderborn.fujaba.codegen.OOMemoStatement;
import de.uni_paderborn.fujaba.codegen.OOSingleExpr;
import de.uni_paderborn.fujaba.codegen.OOStatement;
import de.uni_paderborn.fujaba.codegen.OOVariableType;
import de.uni_paderborn.fujaba.codegen.OOWhileStatement;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FBaseTypes;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FCommentary;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.metamodel.FFile;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FProject;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class OOGenStrategyClient
extends CodeGenStrategy {
    public static final int HL_SDM = 10;

    public final void generateFProject(FProject theProject) {
        this.handlerGenerate(theProject, null, null);
    }

    public final void generateFPackage(FPackage thePackage) {
        this.handlerGenerate(thePackage, null, null);
    }

    public OOStatement[] methodFlowForEachStart() {
        return new OOStatement[]{OO.startBlock(), OO.lineComment(" for each flow")};
    }

    public OOStatement[] methodFlowForEachEnd() {
        return new OOStatement[]{OO.endBlock(" end for each flow")};
    }

    public OOStatement[] methodFlowWhileHead(String comment, OOExpression condition) {
        LinkedList<OOWhileStatement> statements = new LinkedList<OOWhileStatement>();
        if (comment != null) {
            OOStatement.add(statements, OO.lineComment(comment));
        }
        statements.add(OO.whileStat(condition));
        OOStatement.add(statements, OO.startBlock());
        return OOStatement.toArray(statements);
    }

    public OOStatement[] methodFlowDo(String comment) {
        LinkedList statements = new LinkedList();
        if (comment != null) {
            OOStatement.add(statements, OO.lineComment(comment));
        }
        OOStatement.add(statements, new OODoStatement());
        OOStatement.add(statements, OO.startBlock());
        return OOStatement.toArray(statements);
    }

    public OOStatement[] methodFlowWhileFoot(OOExpression condition) {
        return new OOStatement[]{OO.endBlock(), OO.whileStat(condition, true)};
    }

    public OOStatement[] methodFlowIfThen(String comment, OOExpression expr) {
        LinkedList statements = new LinkedList();
        if (comment != null) {
            OOStatement.add(statements, OO.lineComment(comment));
        }
        OOStatement.add(statements, OO.ifStat(expr));
        OOStatement.add(statements, OO.startBlock());
        return OOStatement.toArray(statements);
    }

    public OOStatement[] methodFlowElse() {
        return new OOStatement[]{new OOElseStatement(), OO.startBlock()};
    }

    public OOExpression methodFlowCondition(boolean positive) {
        OOSingleExpr result = OO.identifier(OO.variable(OOVariableType.iFujabaSuccess));
        if (!positive) {
            result = OO.not(result);
        }
        return result;
    }

    public boolean hideEnabled() {
        return false;
    }

    public OOStatement[] openHideTag(int nr) {
        LinkedList statements = new LinkedList();
        OOStatement.add(statements, OO.lineComment(" openHideTag(" + nr + ") is missing !"));
        return OOStatement.toArray(statements);
    }

    public OOStatement[] closeHideTag() {
        LinkedList statements = new LinkedList();
        OOStatement.add(statements, OO.lineComment("closeHideTag() is missing !"));
        return OOStatement.toArray(statements);
    }

    public OOStatement[] setInternalVariables(boolean modifiedSetItems) {
        LinkedList statements = new LinkedList();
        OOStatement.add(statements, OO.fujabaSuccess(OOIdentifierExpr.TRUE_IDENTIFIER));
        return OOStatement.toArray(statements);
    }

    public OOStatement[] constraintText(OOExpression condition, boolean assertStmt) {
        return this.constraintTextWithComment(condition, "constraint", assertStmt);
    }

    public OOStatement[] constraintText(String condition, boolean assertStmt) {
        return this.constraintTextWithComment(condition, "constraint", assertStmt);
    }

    public OOStatement[] constraintTextWithComment(OOExpression condition, String comment, boolean assertStmt) {
        LinkedList statements = new LinkedList();
        OOStatement.add(statements, OO.lineComment(comment));
        if (assertStmt) {
            OOStatement.add(statements, OO.assertStmt(condition, comment));
        } else {
            OOStatement.add(statements, OO.ensure(condition));
        }
        OOStatement.add(statements, OO.emptyLine());
        return OOStatement.toArray(statements);
    }

    public OOStatement[] constraintTextWithComment(String condition, String comment, boolean assertStmt) {
        LinkedList statements = new LinkedList();
        OOStatement.add(statements, OO.lineComment(comment));
        if (assertStmt) {
            OOStatement.add(statements, OO.assertStmt(condition, comment));
        } else {
            OOStatement.add(statements, OO.ensure(condition));
        }
        OOStatement.add(statements, OO.emptyLine());
        return OOStatement.toArray(statements);
    }

    public OOStatement[] memoField(String code) {
        String strg;
        LinkedList statements = new LinkedList();
        int countDelimiters = 0;
        int minIndent = Integer.MAX_VALUE;
        int curIndent = 0;
        int i = 0;
        StringTokenizer st = new StringTokenizer(code, "\n", true);
        while (st.hasMoreTokens()) {
            strg = st.nextToken();
            countDelimiters = strg.equals("\n") ? ++countDelimiters : 0;
            if (strg.length() < 1 || strg.equals("\n") || strg.trim().length() <= 1) continue;
            curIndent = 0;
            boolean end = false;
            i = 0;
            while (!end && i < strg.length()) {
                char tmpChar = strg.charAt(i);
                if (tmpChar == ' ') {
                    ++curIndent;
                } else if (tmpChar == '\t') {
                    curIndent += 4;
                } else {
                    end = true;
                }
                ++i;
            }
            minIndent = Math.min(curIndent, minIndent);
        }
        if (minIndent == Integer.MAX_VALUE) {
            minIndent = 0;
        }
        st = new StringTokenizer(code, "\n", true);
        countDelimiters = 0;
        while (st.hasMoreTokens()) {
            strg = st.nextToken();
            countDelimiters = strg.equals("\n") ? ++countDelimiters : 0;
            if (strg.length() < 1 || strg.equals("\n")) continue;
            OOStatement.add(statements, new OOMemoStatement(strg));
        }
        return OOStatement.toArray(statements);
    }

    public String generateImportClass(FClass theClass) {
        return this.getCurrentOOGenVisitor().generateImportClass(theClass);
    }

    public String generateImportPackage(FPackage thePackage) {
        return this.getCurrentOOGenVisitor().generateImportPackage(thePackage);
    }

    public void generateFPackageBegin(FFile theFile) {
        this.getCurrentOOGenVisitor().generatePackageBegin(theFile);
    }

    public void generateFPackageEnd(FFile theFile) {
        this.getCurrentOOGenVisitor().generatePackageEnd(theFile);
    }

    public void generateClassStartBlock() {
        this.getCurrentOOGenVisitor().generateClassStartBlock();
    }

    public void generateClassEndBlock() {
        this.getCurrentOOGenVisitor().generateClassEndBlock();
    }

    public void newLine() {
        this.getCurrentOOGenVisitor().newLine();
    }

    public void generateOpenBlock(String blockType) {
        this.getCurrentOOGenVisitor().generateOpenBlock(blockType);
    }

    public void generateCloseBlock(String blockType) {
        this.getCurrentOOGenVisitor().generateCloseBlock(blockType);
    }

    public String createOpenBlock(String blockType) {
        return this.getCurrentOOGenVisitor().createOpenBlock(blockType);
    }

    public String createCloseBlock(String blockType) {
        return this.getCurrentOOGenVisitor().createCloseBlock(blockType);
    }

    public String createInterfaceDeclaration(FClass theClass) {
        return this.getCurrentOOGenVisitor().createInterfaceDeclaration(theClass);
    }

    public String createClassDeclaration(FClass theClass) {
        return this.getCurrentOOGenVisitor().createClassDeclaration(theClass);
    }

    public String createFClassCommentary(FCommentary theCommentary) {
        return this.getCurrentOOGenVisitor().createClassCommentary(theCommentary);
    }

    public String createFAttrCommentary(FCommentary theCommentary) {
        return this.getCurrentOOGenVisitor().createAttrCommentary(theCommentary);
    }

    public String createFMethodCommentary(FCommentary theCommentary) {
        return this.getCurrentOOGenVisitor().createMethodCommentary(theCommentary);
    }

    public String createFClassInterfaceModifier(FClass theClass) {
        return this.getCurrentOOGenVisitor().createClassInterfaceModifier(theClass);
    }

    public String createFAttrDeclaration(FAttr theAttr) {
        return this.getCurrentOOGenVisitor().createAttrDeclaration(theAttr);
    }

    public String createFMethodDeclaration(FMethod theMethod) {
        return this.getCurrentOOGenVisitor().createMethodDeclaration(theMethod);
    }

    public void appendFClassCommentary(String comment) {
        this.getCurrentOOGenVisitor().appendClassCommentary(comment);
    }

    public void appendFClassDeclaration(String declString) {
        this.getCurrentOOGenVisitor().appendClassDeclaration(declString);
    }

    public void appendFAttrDeclaration(String decl) {
        this.getCurrentOOGenVisitor().appendAttrDeclaration(decl);
    }

    public void appendFAttrCommentary(String comment) {
        this.getCurrentOOGenVisitor().appendAttrCommentary(comment);
    }

    public void appendFMethodCommentary(String theCommentary) {
        this.getCurrentOOGenVisitor().appendMethodCommentary(theCommentary);
    }

    public void appendFMethodDeclaration(String decl) {
        this.getCurrentOOGenVisitor().appendMethodDeclaration(decl);
    }

    public void appendFMethodBody(String body) {
        this.getCurrentOOGenVisitor().appendMethodBody(body);
        this.newLine();
        this.newLine();
    }

    public String getInterfaceName(FClass theClass) {
        return this.getCurrentOOGenVisitor().getInterfaceName(theClass);
    }

    public String getClassName(FClass theClass) {
        return this.getCurrentOOGenVisitor().getClassName(theClass);
    }

    public String getAttrDeclName(FAttr theAttr) {
        return this.getCurrentOOGenVisitor().getAttrDeclName(theAttr);
    }

    public String getMethodDeclName(FMethod theMethod) {
        return this.getCurrentOOGenVisitor().getMethodDeclName(theMethod);
    }

    public String getProgLangType(FBaseTypes theType) {
        return this.getCurrentOOGenVisitor().getProgLangType(theType);
    }

    public String getFAttrDeclVisibilityString(FAttr theAttr) {
        return this.getCurrentOOGenVisitor().getAttrDeclVisibilityString(theAttr.getVisibility());
    }

    public String getFMethodDeclVisibilityString(FMethod theMethod) {
        return this.getCurrentOOGenVisitor().getMethodDeclVisibilityString(theMethod.getVisibility());
    }

    public String getVisibilityString(FDeclaration theDeclaration) {
        return this.getCurrentOOGenVisitor().getVisibilityString(theDeclaration.getVisibility());
    }

    public String getVisibilityString(int visibility) {
        return this.getCurrentOOGenVisitor().getVisibilityString(visibility);
    }

    public OOGenVisitor getCurrentOOGenVisitor() {
        return (OOGenVisitor)this.getCurrentVisitor();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("OOGenStrategyClient[name=");
        result.append(this.getName());
        result.append(",visitor=");
        result.append(this.getCurrentOOGenVisitor());
        result.append("]");
        return result.toString();
    }
}

