/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.UMLClassBodyStrategy;
import de.uni_paderborn.fujaba.metamodel.FAssoc;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FRole;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class UMLClassBodyRolesStrategy
extends UMLClassBodyStrategy {
    public void createContents(FClass umlClass) {
        SortedSet roles = this.getRoles(umlClass);
        Iterator rolesIter = roles.iterator();
        while (rolesIter.hasNext()) {
            FRole currentRole = (FRole)rolesIter.next();
            this.generateFRole(currentRole);
        }
    }

    protected void generateFRole(FRole role) {
        if (role != null) {
            FRole partnerRole = role.getFPartnerRole();
            this.getClassHandler().generateFRole(partnerRole);
        }
    }

    protected SortedSet getRoles(FClass umlClass) {
        TreeSet<FRole> roles = new TreeSet<FRole>(new RoleComparator());
        Iterator rolesIter = umlClass.iteratorOfRoles();
        while (rolesIter.hasNext()) {
            FRole currentRole = (FRole)rolesIter.next();
            FAssoc assoc = currentRole.getFAssoc();
            if (assoc == null) {
                currentRole.removeYou();
                continue;
            }
            FRole partnerRole = currentRole.getFPartnerRole();
            if (partnerRole == null) {
                currentRole.removeYou();
                assoc.removeYou();
                continue;
            }
            roles.add(partnerRole);
        }
        return roles;
    }

    public static class RoleComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            FRole umlRole1 = (FRole)o1;
            FRole umlRole2 = (FRole)o2;
            if (umlRole1 == null || umlRole1.getName() == null) {
                if (umlRole2 == null || umlRole2.getName() == null) {
                    return 0;
                }
                return -1;
            }
            if (umlRole2 == null || umlRole2.getName() == null) {
                return 1;
            }
            return umlRole1.getName().compareTo(umlRole2.getName());
        }
    }
}

