/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.codegen.AccessorOOHandler;
import de.uni_paderborn.fujaba.codegen.CodeGenFactory;
import de.uni_paderborn.fujaba.codegen.OOGenToken;
import de.uni_paderborn.fujaba.codegen.OOGenVisitor;
import de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy;
import de.uni_paderborn.fujaba.metamodel.FAssoc;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.upb.tools.fca.FHashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class UMLRoleOOHandler
extends AccessorOOHandler {
    private static final transient Logger log;
    private UMLRoleOOHandlerStrategy strategyChain;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.UMLRoleOOHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public boolean isResponsible(FElement incr) {
        return incr instanceof FRole;
    }

    public OOGenToken generateSourceCode(FElement incr, OOGenToken prevToken, Object[] param) {
        FRole umlRole = (FRole)incr;
        FAssoc umlAssoc = umlRole.getFAssoc();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ".generateSourceCode(umlRole=" + umlRole + ")"));
        }
        this.checkSanity(umlRole);
        if (umlRole.getAdornment() != 3 && !umlAssoc.isVirtualPath() && !umlRole.isParsed()) {
            return super.generateSourceCode(incr, prevToken, param);
        }
        return null;
    }

    private void checkSanity(FRole umlRole) {
        FClass target = umlRole.getFTarget();
        FAssoc umlAssoc = umlRole.getFAssoc();
        if (umlAssoc == null) {
            umlRole.removeYou();
            return;
        }
        if (target == null) {
            umlRole.removeYou();
            umlAssoc.removeYou();
            return;
        }
        FRole partnerRole = umlRole.getFPartnerRole();
        if (partnerRole == null) {
            umlRole.removeYou();
            umlAssoc.removeYou();
            return;
        }
        FClass partnerTarget = partnerRole.getFTarget();
        if (partnerTarget == null) {
            umlRole.removeYou();
            partnerRole.removeYou();
            umlAssoc.removeYou();
            return;
        }
    }

    protected void generateAttr(FRole umlRole, FRole partnerRole, FAttr attr) {
        FClass target = umlRole.getFTarget();
        FAttr existingAttr = target.getFromFAttrs(attr.getName());
        if (existingAttr != null && (existingAttr.isGenerated() || existingAttr.getDisplayLevel() <= 0)) {
            existingAttr.removeYou();
            existingAttr = null;
        }
        if (existingAttr == null) {
            attr.setParent(umlRole.getFTarget());
            attr.setImplementingAssocRole(partnerRole);
            this.generateAttrCode(attr);
            attr.setParent(null);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Existing attr: " + existingAttr.getName()));
            }
            this.generateAttrCode(existingAttr);
        }
    }

    protected boolean setStrategyChain(UMLRoleOOHandlerStrategy value) {
        boolean changed = false;
        if (this.strategyChain == null && value != null || this.strategyChain != null && !this.strategyChain.equals(value)) {
            this.strategyChain = value;
            value.setHandler(this);
            value.initHandler(value);
            changed = true;
        }
        return changed;
    }

    public UMLRoleOOHandlerStrategy getStrategyChain() {
        return this.strategyChain;
    }

    public void appendStrategy(UMLRoleOOHandlerStrategy strategy) {
        if (strategy != null) {
            if (this.strategyChain == null) {
                this.setStrategyChain(strategy);
            } else {
                UMLRoleOOHandlerStrategy tmpStrategy = this.strategyChain;
                while (tmpStrategy.getNext() != null) {
                    tmpStrategy = tmpStrategy.getNext();
                }
                tmpStrategy.setNext(strategy);
            }
        }
    }

    public UMLRoleOOHandlerStrategy findResponsible(FRole umlRole) {
        FRole partnerRole = umlRole.getFPartnerRole();
        UMLRoleOOHandlerStrategy strategy = this.strategyChain;
        while (strategy != null) {
            if (strategy.isResponsible(umlRole, partnerRole)) {
                return strategy;
            }
            strategy = strategy.getNext();
        }
        throw new IllegalStateException("No HandlerStrategy for this role");
    }

    public static String getAssocTemplateName() {
        OOGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();
        if (visitor instanceof OOGenVisitor) {
            return visitor.getAssocTemplateName();
        }
        return "Templates/AssocTemplateFCA.tpl";
    }

    public static String getReferenceTemplateName() {
        OOGenVisitor visitor = CodeGenFactory.get().getCurrentOOVisitor();
        if (visitor instanceof OOGenVisitor) {
            return visitor.getReferenceTemplateName();
        }
        return "Templates/ReferenceTemplate.tpl";
    }

    public String toString() {
        return "UMLRoleOOHandler[]";
    }

    protected String getTemplateFileName(FElement element) {
        FRole umlRole = (FRole)element;
        FRole partnerRole = umlRole.getFPartnerRole();
        if (partnerRole.getAdornment() == 3) {
            return UMLRoleOOHandler.getReferenceTemplateName();
        }
        return UMLRoleOOHandler.getAssocTemplateName();
    }

    protected FAttr createAccessorDescriptions(FElement element, Set accessMethods) {
        FRole umlRole = (FRole)element;
        FRole partnerRole = umlRole.getFPartnerRole();
        UMLRoleOOHandlerStrategy strategy = this.findResponsible(umlRole);
        FAttr attr = strategy.generateRole(umlRole, accessMethods, accessMethods);
        this.generateAttr(umlRole, partnerRole, attr);
        return attr;
    }

    public FClass getTarget(FElement element, FAttr attr) {
        FRole umlRole = (FRole)element;
        return umlRole.getFTarget();
    }

    protected void changeTemplateParameters(FElement element, FAttr attr, String blockName, FHashMap templateParameters) {
        super.changeTemplateParameters(element, attr, blockName, templateParameters);
        FRole umlRole = (FRole)element;
        UMLRoleOOHandlerStrategy strategy = this.findResponsible(umlRole);
        strategy.changeTemplateParameters(element, attr, blockName, templateParameters);
    }

    public void removeOldAccessors(FElement element) {
        if (element != null) {
            FRole umlRole = (FRole)element;
            this.checkSanity(umlRole);
            super.removeOldAccessors(umlRole);
            FAttr attr = umlRole.getFPartnerRole().getFAssociatedAttribute();
            if (attr == null) {
                FClass target = umlRole.getFTarget();
                String attrName = umlRole.getFPartnerRole().getAttrName();
                attr = target.getFromFAttrs(attrName);
            }
            if (attr != null) {
                attr.removeYou();
            }
        }
    }
}

