/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen;

import de.uni_paderborn.fujaba.basic.SourceCodeFactory;
import de.uni_paderborn.fujaba.codegen.AccessorOOHandler;
import de.uni_paderborn.fujaba.codegen.ImportFragment;
import de.uni_paderborn.fujaba.codegen.TemplateParameterListener;
import de.uni_paderborn.fujaba.codegen.UMLFileOOHandler;
import de.uni_paderborn.fujaba.codegen.UMLRoleOOHandler;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FBaseTypes;
import de.uni_paderborn.fujaba.metamodel.FCardinality;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FCommentary;
import de.uni_paderborn.fujaba.metamodel.FConstraint;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.uni_paderborn.fujaba.metamodel.FParam;
import de.uni_paderborn.fujaba.metamodel.FQualifier;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLCommentary;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.IteratorConcatenation;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class UMLRoleOOHandlerStrategy {
    private static final transient Logger log;
    private UMLRoleOOHandler handler;
    private UMLRoleOOHandlerStrategy previous;
    private UMLRoleOOHandlerStrategy next;
    private LinkedHashSet templateParameterListeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.UMLRoleOOHandlerStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public UMLRoleOOHandlerStrategy() {
        this.setupTemplateParameterListeners();
    }

    public UMLRoleOOHandlerStrategy(UMLRoleOOHandler handler) {
        this();
        this.setHandler(handler);
    }

    protected void setHandler(UMLRoleOOHandler handler) {
        this.handler = handler;
    }

    public UMLRoleOOHandler getHandler() {
        return this.handler;
    }

    public abstract boolean isResponsible(FRole var1, FRole var2);

    protected abstract void generateReadAccessMethods(FRole var1, FRole var2, FAttr var3, FHashMap var4, Set var5);

    protected abstract void generateWriteAccessMethods(FRole var1, FRole var2, FAttr var3, FHashMap var4, Set var5);

    protected abstract String getAttrType(FRole var1, FRole var2);

    protected abstract String createKeyChangePreHook(FRole var1, FRole var2);

    protected abstract String createKeyChangePostHook(FRole var1, FRole var2);

    protected void setupTemplateParameterListeners() {
    }

    public FAttr generateRole(FRole umlRole, Set readAccessMethods, Set writeAccessMethods) {
        FRole partnerRole = umlRole.getFPartnerRole();
        if ((umlRole.getFTarget() == null || partnerRole.getFTarget() == null) && log.isEnabledFor(Priority.ERROR)) {
            log.error((Object)("role '" + umlRole + "' is not assigned to a class object"));
        }
        this.provideImport(umlRole.getFTarget(), partnerRole.getFTarget());
        FAttr attr = this.createAttr(umlRole, partnerRole, this.getAttrType(umlRole, partnerRole));
        FHashMap templateParameters = this.setupTemplateParameters(umlRole, partnerRole);
        if (readAccessMethods != null) {
            this.generateReadAccessMethods(umlRole, partnerRole, attr, templateParameters, readAccessMethods);
        }
        if (writeAccessMethods != null) {
            this.generateWriteAccessMethods(umlRole, partnerRole, attr, templateParameters, writeAccessMethods);
        }
        return attr;
    }

    protected FHashMap setupTemplateParameters(FRole umlRole, FRole partnerRole) {
        FHashMap templateParameters = new FHashMap();
        templateParameters.put("$FIELDNAME$", partnerRole.getAttrName());
        templateParameters.put("$VALUETYPE$", partnerRole.getFTarget().getFRealType().getName());
        templateParameters.put("$METHOD_SUFFIX$", SourceCodeFactory.upFirstChar(partnerRole.getAttrName()).toString());
        templateParameters.put("$ASSOC$", umlRole.getFAssoc().getName());
        templateParameters.put("$CHANGE_PREHOOK$", "");
        templateParameters.put("$CHANGE_POSTHOOK$", "");
        FType qualifierType = UMLRoleOOHandlerStrategy.getExternalQualifierType(partnerRole);
        if (qualifierType != null) {
            templateParameters.put("$PARTNER_KEY$", "partnerKey, ");
            if (qualifierType instanceof FClass) {
                this.provideImport(umlRole.getFTarget(), (FClass)qualifierType);
            }
        }
        return templateParameters;
    }

    protected FHashMap setupKeyChangeParameters(FRole umlRole, FRole partnerRole) {
        UMLRoleOOHandlerStrategy partnerStrategy = this.findResponsible(partnerRole);
        FHashMap templateParameters = this.setupTemplateParameters(umlRole, partnerRole);
        FHashMap partnerParameters = partnerStrategy.setupTemplateParameters(partnerRole, umlRole);
        String keyString = (String)partnerParameters.get("$KEYTYPE$");
        templateParameters.put("$PARTNERMETHOD_SUFFIX$", partnerParameters.get("$METHOD_SUFFIX$"));
        templateParameters.put("$KEYTYPE$", keyString);
        return templateParameters;
    }

    protected FAttr createAttr(FRole umlRole, FRole partnerRole, String attrType) {
        UMLAttr attr = new UMLAttr(false);
        attr.setName(partnerRole.getAttrName());
        attr.setStatic(false);
        attr.setFinal(false);
        attr.setVisibility(0);
        attr.setInitialValue(null);
        FClass tmpType = this.provideReference(attrType);
        attr.setAttrType(tmpType);
        attr.setVisibility(partnerRole.getUmlVisibility());
        attr.setDisplayLevel(0);
        attr.setGenerated(true);
        attr.setTransient(umlRole.getFAssoc().isRolesTransient());
        attr.setComment(this.createAssocComment(umlRole, partnerRole, attr));
        this.getHandler().addToGeneratedIncrs(attr);
        return attr;
    }

    protected FCommentary createAssocComment(FRole umlRole, FRole partnerRole, FAttr attr) {
        SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
        FClass umlTarget = umlRole.getFTarget();
        FClass partnerTarget = partnerRole.getFTarget();
        String umlTargetName = umlTarget.getName() != null ? umlTarget.getName().trim() : "";
        String partnerTargetName = partnerTarget.getName() != null ? partnerTarget.getName().trim() : "";
        String umlRoleName = umlRole.getAttrName() != null ? umlRole.getAttrName().trim() : "";
        String partnerRoleName = partnerRole.getAttrName() != null ? partnerRole.getAttrName().trim() : "";
        String umlRoleCard = umlRole.getFCard().getCardString();
        String partnerRoleCard = partnerRole.getFCard().getCardString();
        String umlQualifier = umlRole.getFQualifier() != null ? umlRole.getFQualifier().getName() : "";
        String partnerQualifier = partnerRole.getFQualifier() != null ? partnerRole.getFQualifier().getName() : "";
        String assocName = umlRole.getFAssoc() != null ? umlRole.getFAssoc().getName() : "";
        String constraintText = "";
        Iterator iter = umlRole.getFAssoc().iteratorOfConstraints();
        while (iter.hasNext()) {
            FConstraint tmpConst = (FConstraint)iter.next();
            String constraint = tmpConst.getText();
            if (constraint == null) continue;
            constraintText = constraintText.concat(constraint).concat(", ");
        }
        if (constraintText.length() > 0) {
            constraintText = constraintText.substring(0, constraintText.length() - 1);
        }
        String commentText = factory.assocCommentary(umlTargetName, umlRoleName, umlRoleCard, assocName, constraintText, partnerTargetName, partnerRoleName, partnerRoleCard, umlQualifier, partnerQualifier, umlRole.getAdornment() == 3, partnerRole.getAdornment() == 3, umlRole.getAdornment() == 1 || umlRole.getAdornment() == 2, partnerRole.getAdornment() == 1 || partnerRole.getAdornment() == 2);
        UMLCommentary comment = new UMLCommentary(false);
        comment.setText(commentText);
        this.getHandler().addToGeneratedIncrs(comment);
        return comment;
    }

    protected AccessorOOHandler.MethodDescription createAccessMethod(FRole umlRole, FRole partnerRole, FAttr attr, int methodType, String blockName, FHashMap templateParameters, FType returnType, FParam[] methodParameters) {
        SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
        String methodName = factory.getAccessMethodName(attr.getName(), methodType);
        UMLMethod umlMethod = new UMLMethod(false);
        umlMethod.setName(methodName);
        umlMethod.setStatic(attr.isStatic());
        umlMethod.setResultType(returnType);
        umlMethod.setVisibility(attr.getVisibility());
        umlMethod.setAccessedAttribute(attr);
        umlMethod.setGenerated(true);
        if (!(returnType instanceof UMLBaseTypes)) {
            umlMethod.setResultTypeIsPointer(true);
        }
        int i = 0;
        while (methodParameters != null && i < methodParameters.length) {
            umlMethod.addToParam(methodParameters[i]);
            ++i;
        }
        return new AccessorOOHandler.MethodDescription(umlMethod, blockName, templateParameters);
    }

    protected FParam createParam(String name, FType type) {
        UMLParam param = new UMLParam(false);
        param.setName(name);
        param.setParamType(type);
        param.setGenerated(true);
        param.setPointer(!(type instanceof FBaseTypes));
        return param;
    }

    protected AccessorOOHandler.MethodDescription createInsertMethod(FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters, String blockName, int methodType) {
        return this.createInsertMethod(umlRole, partnerRole, attr, templateParameters, blockName, methodType, "value", partnerRole.getFTarget().getFRealType());
    }

    protected AccessorOOHandler.MethodDescription createInsertMethod(FRole umlRole, FRole partnerRole, FAttr attr, FHashMap templateParameters, String blockName, int methodType, String paramName, FType paramType) {
        FParam[] methodParams;
        String insert = this.getPartnerAccessMethod(umlRole, partnerRole, 0);
        templateParameters.put("$INSERT$", insert);
        String remove = this.getPartnerAccessMethod(umlRole, partnerRole, 1);
        templateParameters.put("$REMOVE$", remove);
        UMLBaseTypes returnType = UMLProject.get().getFromBaseTypes("Boolean");
        FParam valueParam = this.createParam(paramName, paramType);
        FType qualifierType = UMLRoleOOHandlerStrategy.getExternalQualifierType(partnerRole);
        if (qualifierType != null) {
            FParam qualifierParam = this.createParam("partnerKey", qualifierType);
            methodParams = new FParam[]{qualifierParam, valueParam};
        } else {
            methodParams = new FParam[]{valueParam};
        }
        return this.createAccessMethod(umlRole, partnerRole, attr, methodType, blockName, templateParameters, returnType, methodParams);
    }

    public static int getCardinality(FRole umlRole) {
        int cardinality = 1;
        FCardinality umlCardinality = umlRole.getFCard();
        if (umlCardinality != null) {
            cardinality = umlCardinality.getUpperBound();
        }
        return cardinality;
    }

    public static int getQualifiedCardinality(FRole umlRole) {
        if (umlRole.getFQualifier() != null) {
            return Integer.MAX_VALUE;
        }
        return UMLRoleOOHandlerStrategy.getCardinality(umlRole);
    }

    protected static boolean isOrdered(FRole umlRole) {
        Iterator iter = umlRole.iteratorOfConstraints();
        iter = new IteratorConcatenation(umlRole.getFAssoc().iteratorOfConstraints(), iter);
        while (iter.hasNext()) {
            UMLConstraint tmpConst = (UMLConstraint)iter.next();
            String constraint = tmpConst.getText();
            if (constraint == null || !(constraint = constraint.toLowerCase()).equals("ordered")) continue;
            return true;
        }
        return false;
    }

    protected static boolean isSorted(FRole umlRole) {
        Iterator iter = umlRole.iteratorOfConstraints();
        iter = new IteratorConcatenation(umlRole.getFAssoc().iteratorOfConstraints(), iter);
        while (iter.hasNext()) {
            UMLConstraint tmpConst = (UMLConstraint)iter.next();
            String constraint = tmpConst.getText();
            if (constraint == null || !(constraint = constraint.toLowerCase()).equals("sorted")) continue;
            return true;
        }
        return false;
    }

    protected static boolean isBound(FRole umlRole) {
        UMLStereotype stereotype = UMLStereotypeManager.get().getFromStereotypes("JavaBean");
        boolean bound = umlRole.getFTarget().hasInStereotypes(stereotype);
        return bound;
    }

    protected static boolean isToMany(FRole umlRole, FRole partnerRole) {
        FQualifier qualifier = umlRole.getFQualifier();
        if (qualifier == null) {
            return UMLRoleOOHandlerStrategy.getCardinality(partnerRole) > 1;
        }
        return true;
    }

    protected static FType getExternalQualifierType(FRole umlRole) {
        FQualifier qualifier = umlRole.getFQualifier();
        if (qualifier != null && qualifier.isExternalQualifier()) {
            return qualifier.getFType();
        }
        return null;
    }

    protected String getPartnerAccessMethod(FRole umlRole, FRole partnerRole, int methodType) {
        boolean remove = methodType == 1;
        boolean partnerQualified = !remove && UMLRoleOOHandlerStrategy.getExternalQualifierType(partnerRole) != null;
        return this.getPartnerAccessMethod(umlRole, partnerRole, methodType, false, partnerQualified);
    }

    protected String getPartnerAccessMethod(FRole umlRole, FRole partnerRole, int methodType, boolean qualified, boolean partnerQualified) {
        int upperBound = UMLRoleOOHandlerStrategy.isToMany(partnerRole, umlRole) ? Integer.MAX_VALUE : 1;
        SourceCodeFactory factory = UMLProject.getSourceCodeFactory();
        return factory.getAssocAccessMethodLine(methodType, umlRole.getAttrName(), upperBound, qualified, partnerQualified);
    }

    protected void provideImport(FClass target, FPackage pack) {
        ImportFragment importFrag;
        FPackage targetPack = target.findFPackage();
        if (targetPack != pack && (importFrag = UMLFileOOHandler.findImportFragment(this.getHandler().getClientOfChain().getCurrentVisitor())) != null) {
            importFrag.addPackage(pack);
        }
    }

    protected void provideImport(FClass target, FClass clazz) {
        ImportFragment importFrag;
        FPackage importPack;
        FPackage targetPack = target.findFPackage();
        if (targetPack != (importPack = clazz.getFDeclaredInPackage()) && (importFrag = UMLFileOOHandler.findImportFragment(this.getHandler().getClientOfChain().getCurrentVisitor())) != null) {
            importFrag.addClass(clazz);
        }
    }

    protected FClass provideReference(String className) {
        UMLClass result = UMLProject.get().findReference(className, false, false);
        if (result == null) {
            result = UMLProject.get().findReference(className, true, false);
            this.processGeneratedClass(result);
        }
        return result;
    }

    protected FType provideType(String typeName) {
        FType result = UMLProject.get().findType(null, typeName, false, false);
        if (result == null) {
            result = this.provideReference(typeName);
        }
        return result;
    }

    protected FPackage providePackage(String packName) {
        UMLPackage pack = UMLProject.get().findPackage(packName, false, false);
        if (pack == null) {
            pack = UMLProject.get().findPackage(packName, true, false);
            this.processGeneratedPackage(pack);
        }
        return pack;
    }

    private void processGeneratedClass(FClass clazz) {
        if (clazz.getFDeclaredInClass() != null) {
            FClass tmpClass = clazz.getFDeclaredInClass();
            if (!tmpClass.isCoobraPersistent()) {
                this.processGeneratedClass(tmpClass);
            }
        } else if (clazz.getFDeclaredInPackage() != null) {
            FPackage pack = clazz.getFDeclaredInPackage();
            this.processGeneratedPackage(pack);
        }
        this.getHandler().addToGeneratedIncrs(clazz);
    }

    private void processGeneratedPackage(FPackage pack) {
        boolean generated;
        UMLRoleOOHandler handler = this.getHandler();
        boolean bl = generated = !pack.isCoobraPersistent() || pack.isGenerated();
        if (!generated) {
            int size = 0;
            Iterator iter = pack.iteratorOfDeclares();
            while (iter.hasNext()) {
                FClass clazz = (FClass)iter.next();
                if (handler.hasInGeneratedIncrs(clazz)) continue;
                ++size;
            }
            if (size == 0) {
                iter = pack.iteratorOfPackages();
                while (iter.hasNext()) {
                    FPackage tmpPack = (FPackage)iter.next();
                    if (handler.hasInGeneratedIncrs(tmpPack)) continue;
                    ++size;
                }
            }
            boolean bl2 = generated = size == 0;
        }
        if (generated) {
            handler.addToGeneratedIncrs(pack);
            if (pack.getFParent() != null) {
                this.processGeneratedPackage(pack.getFParent());
            }
        }
    }

    protected boolean setPrevious(UMLRoleOOHandlerStrategy value) {
        boolean changed = false;
        if (this.previous != value) {
            if (this.previous != null) {
                UMLRoleOOHandlerStrategy oldValue = this.previous;
                this.previous = null;
                oldValue.setNext(null);
            }
            this.previous = value;
            if (value != null) {
                value.setNext(this);
            }
            changed = true;
        }
        return changed;
    }

    public UMLRoleOOHandlerStrategy getPrevious() {
        return this.previous;
    }

    public boolean setNext(UMLRoleOOHandlerStrategy value) {
        boolean changed = false;
        if (this.next != value) {
            if (this.next != null) {
                UMLRoleOOHandlerStrategy oldValue = this.next;
                this.next = null;
                oldValue.setPrevious(null);
            }
            this.next = value;
            if (value != null) {
                value.setPrevious(this);
                this.initHandler(value);
            }
            changed = true;
        }
        return changed;
    }

    protected void initHandler(UMLRoleOOHandlerStrategy strategy) {
        UMLRoleOOHandler handler = this.getHandler();
        while (strategy != null) {
            strategy.setHandler(handler);
            strategy = strategy.getNext();
        }
    }

    public UMLRoleOOHandlerStrategy getNext() {
        return this.next;
    }

    protected UMLRoleOOHandlerStrategy findResponsible(FRole umlRole) {
        return this.getHandler().findResponsible(umlRole);
    }

    public void addToTemplateParameterListeners(TemplateParameterListener listener) {
        if (listener != null) {
            if (this.templateParameterListeners == null) {
                this.templateParameterListeners = new LinkedHashSet();
            }
            this.templateParameterListeners.add(listener);
        }
    }

    public void removeFromTemplateParameterListeners(TemplateParameterListener listener) {
        if (listener != null && this.templateParameterListeners != null) {
            this.templateParameterListeners.remove(listener);
        }
    }

    protected void changeTemplateParameters(FElement element, FAttr attr, String blockName, FHashMap templateParameters) {
        if (this.templateParameterListeners != null) {
            Iterator iter = this.templateParameterListeners.iterator();
            while (iter.hasNext()) {
                TemplateParameterListener listener = (TemplateParameterListener)iter.next();
                listener.setupTemplateParameters(this.getHandler(), element, attr, blockName, templateParameters);
            }
        }
    }
}

