/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen.digester;

import de.uni_paderborn.fujaba.codegen.digester.PeekStack;
import de.uni_paderborn.fujaba.codegen.digester.XRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XCallMethodRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XCallParamRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XObjectCreateRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XSetNextRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XSetPropertiesRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XSetPropertyRule;
import de.uni_paderborn.fujaba.codegen.digester.rules.XSetTopRule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XDigester
extends DefaultHandler {
    private static final transient Logger log;
    protected StringBuffer bodyText = new StringBuffer();
    protected PeekStack bodyTexts = new PeekStack();
    protected int debug = 10;
    protected HashMap dtds = new HashMap();
    protected ErrorHandler errorHandler = null;
    protected Locator locator = null;
    protected String match = "";
    protected SAXParser parser = null;
    protected Object root = null;
    protected HashMap rules = new HashMap();
    protected PeekStack stack = new PeekStack();
    protected boolean validating = false;
    protected ClassLoader classLoader = null;
    private static final Logger L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.digester.XDigester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.uni_paderborn.fujaba.codegen.digester.XDigester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        L = Logger.getLogger((Class)clazz2);
    }

    public int getCount() {
        return this.stack.getSize();
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        if (this.debug != debug) {
            this.debug = debug;
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.errorHandler != errorHandler) {
            this.errorHandler = errorHandler;
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classloader) {
        if (this.classLoader != classloader) {
            this.classLoader = classloader;
        }
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(this.validating);
            this.parser = factory.newSAXParser();
            return this.parser;
        }
        catch (Exception e) {
            this.log("Digester.getParser: ", e);
            return null;
        }
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        if (this.validating != validating) {
            this.validating = validating;
        }
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.debug >= 3) {
            this.log("characters(" + new String(buffer, start, length) + ")");
        }
        this.bodyText.append(buffer, start, length);
    }

    public void endDocument() throws SAXException {
        if (this.debug >= 3) {
            this.log("endDocument(" + this.getCount() + ")");
        }
        if (this.getCount() > 1) {
            this.log("endDocument():  " + this.getCount() + " elements left");
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        Iterator keys = this.rules.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List rules = (List)this.rules.get(key);
            int i = 0;
            while (i < rules.size()) {
                try {
                    ((XRule)rules.get(i)).finish();
                }
                catch (Exception e) {
                    this.log("Finish event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        int slash;
        List rules;
        if (this.debug >= 3) {
            this.log("endElement(" + uri + "," + name + "," + qName + "," + this.match + ")");
        }
        if ((rules = this.getRules(this.match)) != null) {
            if (this.debug >= 3) {
                this.log("  Firing 'body' events for " + rules.size() + " rules");
            }
            String bodyText = this.bodyText.toString().trim();
            int i = 0;
            while (i < rules.size()) {
                try {
                    ((XRule)rules.get(i)).body(bodyText);
                }
                catch (Exception e) {
                    this.log("Body event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
        this.bodyText = (StringBuffer)this.bodyTexts.pop();
        if (rules != null) {
            if (this.debug >= 3) {
                this.log("  Firing 'end' events for " + rules.size() + " rules");
            }
            int i = 0;
            while (i < rules.size()) {
                int j = rules.size() - i - 1;
                try {
                    ((XRule)rules.get(j)).end();
                }
                catch (Exception e) {
                    this.log("End event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
        if (this.debug >= 3) {
            this.log("ignorableWhitespace(" + new String(buffer, start, len) + ")");
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.debug >= 3) {
            this.log("processingInstruction('" + target + "', '" + data + "')");
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.debug >= 3) {
            this.log("setDocumentLocator(" + locator + ")");
        }
        if (this.locator != locator) {
            this.locator = locator;
        }
    }

    public void startDocument() throws SAXException {
        if (this.debug >= 3) {
            this.log("startDocument()");
        }
    }

    public void startElement(String uri, String name, String qname, Attributes list) throws SAXException {
        if (this.debug >= 3) {
            this.log("startElement(" + uri + "," + name + "," + "," + qname + "," + list + ")");
        }
        this.bodyTexts.push(this.bodyText);
        this.bodyText.setLength(0);
        if (this.match.length() > 0) {
            this.match = String.valueOf(this.match) + "/" + qname;
        } else {
            this.match = qname;
            if (this.debug >= 3) {
                this.log("startElement(" + this.match + ")");
            }
        }
        List rules = this.getRules(this.match);
        if (rules != null) {
            if (this.debug >= 3) {
                this.log("  Firing 'begin' events for " + rules.size() + " rules");
            }
            int i = 0;
            while (i < rules.size()) {
                try {
                    ((XRule)rules.get(i)).begin(list);
                }
                catch (Exception e) {
                    this.log("Begin event threw exception", e);
                    throw new SAXException(e);
                }
                ++i;
            }
        }
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (this.debug >= 1) {
            this.log("notationDecl('" + name + "', '" + publicId + "', '" + systemId + "')");
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        if (this.debug >= 1) {
            this.log("unparsedEntityDecl('" + name + "', '" + publicId + "', '" + systemId + "', '" + notation + "')");
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.debug >= 1) {
            this.log("resolveEntity('" + publicId + "', '" + systemId + "')");
        }
        String dtdURL = null;
        if (publicId != null) {
            dtdURL = (String)this.dtds.get(publicId);
        }
        if (dtdURL == null) {
            if (this.debug >= 1) {
                this.log(" Not registered, use system identifier");
            }
            return null;
        }
        if (this.debug >= 1) {
            this.log(" Resolving to alternate DTD '" + dtdURL + "'");
        }
        try {
            URL url = new URL(dtdURL);
            InputStream stream = url.openStream();
            return new InputSource(stream);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        this.log("Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.log("Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.log("Parse Warning at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    public void log(String message) {
        L.info((Object)message);
    }

    public void log(String message, Throwable exception) {
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
        exception.printStackTrace(System.out);
    }

    public Object parse(File file) throws IOException, SAXException {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        this.getParser().parse(file, (DefaultHandler)this);
        return this.root;
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        if (input == null) {
            throw new IllegalArgumentException("input==null");
        }
        this.getParser().parse(input, (DefaultHandler)this);
        return this.root;
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        if (input == null) {
            throw new IllegalArgumentException("input==null");
        }
        this.getParser().parse(input, (DefaultHandler)this);
        return this.root;
    }

    public Object parse(String uri) throws IOException, SAXException {
        if (uri == null) {
            throw new IllegalArgumentException("uri==null");
        }
        this.getParser().parse(uri, (DefaultHandler)this);
        return this.root;
    }

    public void register(String publicId, String dtdURL) {
        if (this.debug >= 1) {
            this.log("register('" + publicId + "', '" + dtdURL + "'");
        }
        this.dtds.put(publicId, dtdURL);
    }

    public void addRule(String pattern, XRule rule) {
        ArrayList<XRule> list = (ArrayList<XRule>)this.rules.get(pattern);
        if (list == null) {
            list = new ArrayList<XRule>();
            this.rules.put(pattern, list);
        }
        list.add(rule);
    }

    public void addCallMethod(String pattern, String methodName, int paramCount) {
        this.addRule(pattern, new XCallMethodRule(this, methodName, paramCount));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, String[] paramTypes) {
        this.addRule(pattern, new XCallMethodRule(this, methodName, paramCount, paramTypes));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, Class[] paramTypes) {
        this.addRule(pattern, new XCallMethodRule(this, methodName, paramCount, paramTypes));
    }

    public void addCallParam(String pattern, int paramIndex) {
        this.addRule(pattern, new XCallParamRule(this, paramIndex));
    }

    public void addCallParam(String pattern, int paramIndex, String attributeName) {
        this.addRule(pattern, new XCallParamRule(this, paramIndex, attributeName));
    }

    public void addObjectCreate(String pattern, String className) {
        this.addRule(pattern, new XObjectCreateRule(this, className));
    }

    public void addObjectCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new XObjectCreateRule(this, className, attributeName));
    }

    public void addSetNext(String pattern, String methodName) {
        this.addRule(pattern, new XSetNextRule(this, methodName));
    }

    public void addSetNext(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new XSetNextRule(this, methodName, paramType));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new XSetPropertiesRule(this));
    }

    public void addSetProperty(String pattern, String name, String value) {
        this.addRule(pattern, new XSetPropertyRule(this, name, value));
    }

    public void addSetTop(String pattern, String methodName) {
        this.addRule(pattern, new XSetTopRule(this, methodName));
    }

    public void addSetTop(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new XSetTopRule(this, methodName, paramType));
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.stack.clear();
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public Object pop() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void push(Object object) {
        if (this.stack.getSize() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    protected List getRules(String match) {
        List rulesList = (List)this.rules.get(match);
        if (rulesList == null) {
            String longKey = "";
            Iterator keys = this.rules.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.startsWith("*/") || !match.endsWith(key.substring(1)) || key.length() <= longKey.length()) continue;
                rulesList = (List)this.rules.get(key);
                longKey = key;
            }
        }
        return rulesList;
    }
}

