/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen.digester.rules;

import de.uni_paderborn.fujaba.codegen.digester.XDigester;
import de.uni_paderborn.fujaba.codegen.digester.XRule;
import de.uni_paderborn.tools.fsa.FSAUtility;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;

public class XCallMethodRule
extends XRule {
    protected String bodyText = null;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class[] paramTypes = null;

    public XCallMethodRule(XDigester digester, String methodName, int paramCount) {
        this(digester, methodName, paramCount, (Class[])null);
    }

    public XCallMethodRule(XDigester digester, String methodName, int paramCount, String[] paramTypes) {
        super(digester);
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(paramTypes[i]);
                }
                catch (ClassNotFoundException e) {
                    this.paramTypes[i] = null;
                }
                ++i;
            }
        }
    }

    public XCallMethodRule(XDigester digester, String methodName, int paramCount, Class[] paramTypes) {
        super(digester);
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            String[] parameters = new String[this.paramCount];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = null;
                ++i;
            }
            this.digester.push(parameters);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText;
        }
    }

    public void end() throws Exception {
        String[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (String[])this.digester.pop();
        } else {
            parameters = new String[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            if (this.digester.getDebug() >= 1) {
                this.digester.log(this + ".parameters[" + i + "]=" + parameters[i] + ".");
                this.digester.log(this + ".paramTypes[" + i + "]=" + this.paramTypes[i] + ".");
            }
            paramValues[i] = FSAUtility.convert(parameters[i], this.paramTypes[i]);
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.getDebug() >= 1) {
            StringBuffer sb = new StringBuffer("Call ");
            sb.append(top.getClass().getName());
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            int i2 = 0;
            while (i2 < paramValues.length) {
                if (i2 > 0) {
                    sb.append(",");
                }
                if (paramValues[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i2].toString());
                }
                sb.append("/");
                if (this.paramTypes[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.paramTypes[i2].getName());
                }
                ++i2;
            }
            sb.append(")");
            this.digester.log(sb.toString());
        }
        Method method = top.getClass().getMethod(this.methodName, this.paramTypes);
        method.invoke(top, paramValues);
    }

    public void finish() throws Exception {
        this.bodyText = null;
        this.methodName = null;
        this.paramCount = 0;
        this.paramTypes = null;
    }
}

