/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.codegen.digester.rules;

import de.uni_paderborn.fujaba.codegen.digester.XDigester;
import de.uni_paderborn.fujaba.codegen.digester.XRule;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;

public class XSetPropertiesRule
extends XRule {
    public XSetPropertiesRule(XDigester digester) {
        super(digester);
    }

    public void begin(Attributes attributes) throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            values.put(name, value);
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.getDebug() >= 1) {
            this.digester.log("Set " + top.getClass().getName() + " properties");
        }
        XSetPropertiesRule.populate(top, values);
    }

    protected static void populate(Object target, Map values) {
        Map propertyDescriptors = XSetPropertiesRule.getProperties(target);
        Iterator valueIter = values.entrySet().iterator();
        while (valueIter.hasNext()) {
            Map.Entry entry = valueIter.next();
            String property = (String)entry.getKey();
            String valueStr = (String)entry.getValue();
            PropertyDescriptor descriptor = (PropertyDescriptor)propertyDescriptors.get(property);
            XSetPropertiesRule.setValue(target, valueStr, descriptor);
        }
    }

    protected static void setValue(Object target, String valueStr, PropertyDescriptor descriptor) {
        PropertyEditor editor = XSetPropertiesRule.getEditor(descriptor);
        if (editor != null) {
            editor.setAsText(valueStr);
            Object value = editor.getValue();
            Method writeMethod = descriptor.getWriteMethod();
            try {
                writeMethod.invoke(target, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    protected static PropertyEditor getEditor(PropertyDescriptor descriptor) {
        PropertyEditor editor = null;
        Class<?> customEditorClass = descriptor.getPropertyEditorClass();
        if (customEditorClass != null) {
            try {
                editor = (PropertyEditor)customEditorClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (editor == null) {
            editor = PropertyEditorManager.findEditor(descriptor.getPropertyType());
        }
        return editor;
    }

    protected static Map getProperties(Object target) {
        Class<?> targetClass = target.getClass();
        HashMap<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(targetClass);
            PropertyDescriptor[] tmpDescriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < tmpDescriptors.length) {
                propertyDescriptors.put(tmpDescriptors[i].getName(), tmpDescriptors[i]);
                ++i;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return propertyDescriptors;
    }
}

