/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.tu_bs.coobra.remote.ClientRepositoryOperations;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.CheckinAction;
import de.uni_paderborn.fujaba.coobra.actions.UpdateAction;
import de.upb.lib.userinterface.ActionExecutionListener;
import de.upb.lib.userinterface.UserInterfaceManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class AutoUpdateAction
extends AbstractAction {
    private static ActionExecutionListener actionExecutionListener;
    private static ClientRepositoryOperations checkinListener;

    public void actionPerformed(ActionEvent e) {
        if (FujabaChangeManager.getVMRepository() != null && FujabaChangeManager.getVMRepository().isConnected()) {
            int result = JOptionPane.showConfirmDialog(FrameMain.get(), "Do want to update your local project automatically when the server has a new version and checkin your changes automatically after each action?\n", "Automatic update + checkin", 1);
            if (result == 0) {
                if (actionExecutionListener == null) {
                    actionExecutionListener = new ActionExecutionListener(){

                        public void preActionNotify(ActionEvent e) {
                        }

                        public void postActionNotify(ActionEvent e) {
                            new CheckinAction().actionPerformed(e);
                        }
                    };
                }
                if (checkinListener == null) {
                    checkinListener = new ClientRepositoryOperations(){

                        public void notifyCheckin() {
                            new UpdateAction().actionPerformed(null);
                        }

                        public void notifyDisconnect() {
                        }
                    };
                }
                UserInterfaceManager.get().addExecutionListener(actionExecutionListener);
                FujabaChangeManager.getVMRepository().getRemoteRepository().removeFromCheckinListeners(checkinListener);
                FujabaChangeManager.getVMRepository().getRemoteRepository().addToCheckinListeners(checkinListener);
            } else if (result == 1) {
                UserInterfaceManager.get().removeExecutionListener(actionExecutionListener);
                FujabaChangeManager.getVMRepository().getRemoteRepository().removeFromCheckinListeners(checkinListener);
            }
        } else {
            FrameMain.get().setStatusLabel("Not connected to a server!");
        }
    }
}

