/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.tu_bs.coobra.CopyManager;
import de.tu_bs.coobra.MutableObjectChange;
import de.tu_bs.coobra.ObjectChange;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.UpdateProjectTreeAction;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.CopyAction;
import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.tools.fca.FHashMap;
import de.upb.tools.fca.FLinkedList;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PasteAction
extends AbstractAction
implements CopyManager.CopyChangeCallbackInterface {
    private static final transient Logger log;
    private Map newNames;
    private CopyAction.CopyData copyData;
    private CopyManager copyManager;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.coobra.actions.PasteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PasteAction() {
        this(CopyAction.getClipboard());
    }

    public PasteAction(CopyAction.CopyData copyData) {
        this.copyData = copyData;
    }

    public CopyAction.CopyData getCopyData() {
        return this.copyData;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getCopyData().getSelectedObjects() != null) {
            UMLProject proj = UMLProject.get();
            Object pasteTarget = e.getSource();
            if (pasteTarget instanceof Iterator) {
                Iterator iter = (Iterator)pasteTarget;
                pasteTarget = iter.hasNext() ? iter.next() : proj.getCurrentDiagram();
            }
            if (pasteTarget instanceof FElement) {
                this.paste((FElement)pasteTarget);
            } else {
                Toolkit.getDefaultToolkit().beep();
                FrameMain.get().setStatusLabel("Select a target for pasting first!");
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            FrameMain.get().setStatusLabel("Nothing copied/cut!");
        }
    }

    public List paste(FElement pasteTarget) {
        return this.paste(pasteTarget, true);
    }

    public List paste(FElement pasteTarget, boolean doUpdateDisplay) {
        this.newNames = new FHashMap();
        FLinkedList copies = new FLinkedList();
        if (this.askForClassNames() && this.askForMethodNames(pasteTarget) && this.askForAttrNames(pasteTarget)) {
            this.copyManager = new CopyManager(FujabaChangeManager.getVMRepository(), this.getCopyData().getCopyObjects());
            this.copyManager.setCopyChangeCallback((CopyManager.CopyChangeCallbackInterface)this);
            this.copyManager.copy(this.getCopyData().getChangesToBeCopied());
            Iterator it = this.getCopyData().getSelectedObjects().iterator();
            while (it.hasNext()) {
                FElement element = (FElement)this.copyManager.getCopiedObject(it.next());
                element.setCutCopyPasteParent(pasteTarget);
                copies.add(element);
            }
        }
        if (doUpdateDisplay) {
            UMLProject.get().refreshDisplay();
            new UpdateProjectTreeAction().actionPerformed(null);
        }
        return copies;
    }

    private boolean askForAttrNames(FElement pasteTarget) {
        Iterator it = this.getCopyData().getChangesToBeCopied().iterator();
        while (it.hasNext()) {
            ObjectChange change = (ObjectChange)it.next();
            if (this.newNames.containsKey(change.getAffectedObject()) || !(change.getAffectedObject() instanceof FAttr)) continue;
            FAttr attr = (FAttr)change.getAffectedObject();
            String newName = attr.getName();
            while (!this.isNameOk(newName, attr, pasteTarget)) {
                newName = (String)JOptionPane.showInputDialog(FrameMain.get(), "Please enter new name for Attribute " + attr.getName() + " (must be unique in class).", "Copy Attribute", 3, null, null, newName);
                if (newName != null) continue;
                return false;
            }
            this.newNames.put(attr, newName);
        }
        return true;
    }

    private boolean isNameOk(String newName, FAttr attr, FElement pasteTarget) {
        boolean nameIsOk;
        boolean bl = nameIsOk = newName != null && newName.length() >= 1;
        if (nameIsOk) {
            if (this.getCopyData().getCopyObjects().contains(attr.getFParent())) {
                return true;
            }
            FClass newParent = attr.getFParent();
            if (pasteTarget instanceof FClass && this.getCopyData().getSelectedObjects().contains(attr)) {
                newParent = (FClass)pasteTarget;
            }
            if (newParent != null && newParent.getFromFAttrs(newName) != null) {
                nameIsOk = false;
            }
        }
        return nameIsOk;
    }

    private boolean askForMethodNames(FElement pasteTarget) {
        Iterator it = this.getCopyData().getChangesToBeCopied().iterator();
        while (it.hasNext()) {
            ObjectChange change = (ObjectChange)it.next();
            if (this.newNames.containsKey(change.getAffectedObject()) || !(change.getAffectedObject() instanceof FMethod)) continue;
            FMethod method = (FMethod)change.getAffectedObject();
            String newName = method.getName();
            while (!this.isNameOk(newName, method, pasteTarget)) {
                newName = (String)JOptionPane.showInputDialog(FrameMain.get(), "Please enter new name for Method " + method.getName() + " (must be unique in class).", "Copy Method", 3, null, null, newName);
                if (newName != null) continue;
                return false;
            }
            this.newNames.put(method, newName);
        }
        return true;
    }

    private boolean isNameOk(String newName, FMethod method, FElement pasteTarget) {
        boolean nameIsOk;
        boolean bl = nameIsOk = newName != null && newName.length() >= 1;
        if (nameIsOk) {
            if (this.getCopyData().getCopyObjects().contains(method.getFParent())) {
                return true;
            }
            String fullName = UMLMethod.constructFullMethodName(newName, method.iteratorOfParam());
            FClass newParent = method.getFParent();
            if (pasteTarget instanceof FClass && this.getCopyData().getSelectedObjects().contains(method)) {
                newParent = (FClass)pasteTarget;
            }
            if (newParent != null && newParent.getFromFMethods(fullName) != null) {
                nameIsOk = false;
            }
        }
        return nameIsOk;
    }

    private boolean askForClassNames() {
        Iterator it = this.getCopyData().getChangesToBeCopied().iterator();
        while (it.hasNext()) {
            String newName;
            boolean nameIsOk;
            ObjectChange change = (ObjectChange)it.next();
            if (this.newNames.containsKey(change.getAffectedObject()) || !(change.getAffectedObject() instanceof FClass)) continue;
            FClass cls = (FClass)change.getAffectedObject();
            do {
                if ((newName = (String)JOptionPane.showInputDialog(FrameMain.get(), "Please enter new classname for Class " + cls.getName() + " (must be unique).", "Copy class", 3, null, null, cls.getName())) == null) {
                    return false;
                }
                boolean bl = nameIsOk = newName.length() >= 1;
                if (!nameIsOk || UMLProject.get().getFromClasses(newName) == null) continue;
                nameIsOk = false;
            } while (!nameIsOk);
            if (log.isInfoEnabled()) {
                log.info((Object)("putting " + cls + ": " + newName));
            }
            this.newNames.put(cls, newName);
        }
        return true;
    }

    public void reviewCopiedChange(MutableObjectChange change) {
        if (this.newNames.containsKey(change.getAffectedObject())) {
            if ("parent".equals(change.getFieldName()) && (change.getAffectedObject() instanceof FMethod || change.getAffectedObject() instanceof FAttr) && this.copyData.getSelectedObjects().contains(change.getAffectedObject())) {
                change.setNewValue(null);
            } else if ("name".equals(change.getFieldName())) {
                change.setNewValue(this.newNames.get(change.getAffectedObject()));
            }
        }
    }
}

