/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeCause;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.actions.ProgressDialog;
import de.uni_paderborn.fujaba.coobra.util.ExtensionFileFilter;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class RestoreAction
extends AbstractAction
implements LocalRepository.ProgressCallback {
    ProgressDialog progress = new ProgressDialog(FrameMain.get());
    JFileChooser chooser;

    public void progress(int percent) {
        if (this.progress != null) {
            this.progress.setPercentage(percent);
        }
    }

    public void actionPerformed(ActionEvent event) {
        int result;
        if (this.chooser == null) {
            this.chooser = new JFileChooser(".");
            ExtensionFileFilter filter = new ExtensionFileFilter();
            filter.addExtension("cxr");
            filter.addExtension("cxr.gz");
            filter.setDescription("CoObRA XML Repository");
            this.chooser.setFileFilter(filter);
        }
        if ((result = this.chooser.showOpenDialog(FrameMain.get())) == 0) {
            this.restoreWithProgressDialog(this.chooser.getSelectedFile().getPath());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreWithProgressDialog(String filename) {
        this.progress.setTitle("Load Project");
        WorkThread thread = new WorkThread(filename);
        thread.start();
        this.progress.setVisible(true);
        if (thread.exception != null) {
            throw thread.exception;
        }
        UMLProject newProject = FujabaChangeManager.getUMLProject();
        UMLProject.setNewProject(newProject);
        ObjectChange.pushCause((ObjectChangeCause)LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
        try {
            FrameMain.get().setUMLProject(newProject);
            if (newProject != null) {
                newProject.refreshDisplay();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ObjectChange.popCause((ObjectChangeCause)LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ObjectChange.popCause((ObjectChangeCause)LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
        if (newProject == null) {
            throw new RuntimeException("No UMLProject found in restored objects!");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restore(String filename) {
        LocalRepository oldRepo = FujabaChangeManager.getVMRepository();
        if (filename == null) return;
        if (filename.length() <= 0) return;
        try {
            ObjectChange.pushCause((ObjectChangeCause)LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
            try {
                BufferedInputStream fio;
                UMLProject.setNewProject(null);
                if (oldRepo != null) {
                    oldRepo.removeYou();
                }
                FujabaChangeManager.setVMRepository(new LocalRepository());
                try {
                    fio = new BufferedInputStream(new GZIPInputStream(new FileInputStream(filename)));
                }
                catch (Exception e) {
                    fio = new BufferedInputStream(new FileInputStream(filename));
                }
                FujabaChangeManager.getVMRepository().restore((InputStream)fio, filename.indexOf(".cxri") >= 0, (LocalRepository.ProgressCallback)this);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ObjectChange.popCause((ObjectChangeCause)LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
                throw throwable;
            }
            {
                Object var5_8 = null;
                ObjectChange.popCause((ObjectChangeCause)LocalRepository.CAUSE_WRITEPROTECTIONOVERRIDE);
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class WorkThread
    extends Thread {
        String filename;
        RuntimeException exception;

        public WorkThread(String filename) {
            this.filename = filename;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (!RestoreAction.this.progress.isVisible()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                try {
                    RestoreAction.this.restore(this.filename);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    this.exception = e;
                }
                Object var2_5 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                RestoreAction.this.progress.hide();
                throw throwable;
            }
            RestoreAction.this.progress.hide();
        }
    }
}

