/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.tu_bs.coobra.LocalRepository;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.basic.FileHistory;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.coobra.util.ExtensionFileFilter;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.userinterface.UserInterfaceManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class StoreAction
extends AbstractAction {
    JFileChooser clientChooser;
    JFileChooser serverChooser;

    public void actionPerformed(ActionEvent event) {
        LocalRepository repo = FujabaChangeManager.getVMRepository();
        if (repo != null) {
            String filename;
            JFileChooser chooser;
            ExtensionFileFilter filter;
            String extension;
            if (repo.isServerRepository()) {
                extension = "cxsr";
                if (this.serverChooser == null) {
                    this.serverChooser = new JFileChooser(".");
                    filter = new ExtensionFileFilter();
                    filter.addExtension(extension);
                    filter.addExtension(String.valueOf(extension) + ".gz");
                    filter.setDescription("CoObRA XML Server Repository");
                    this.serverChooser.setFileFilter(filter);
                }
                chooser = this.serverChooser;
            } else {
                extension = "cxr";
                if (this.clientChooser == null) {
                    this.clientChooser = new JFileChooser(".");
                    filter = new ExtensionFileFilter();
                    filter.addExtension(extension);
                    filter.addExtension(String.valueOf(extension) + ".gz");
                    filter.setDescription("CoObRA XML Repository");
                    this.clientChooser.setFileFilter(filter);
                }
                chooser = this.clientChooser;
            }
            int result = chooser.showSaveDialog(FrameMain.get());
            if (result == 0 && (filename = chooser.getSelectedFile().getPath()) != null && filename.length() > 0) {
                boolean zip = true;
                if (filename.lastIndexOf(46) <= filename.lastIndexOf(File.separatorChar)) {
                    filename = String.valueOf(filename) + "." + extension + ".gz";
                } else if (filename.toLowerCase().endsWith("." + extension)) {
                    zip = false;
                }
                try {
                    repo.store(filename, zip);
                    FileHistory.get().addToHistory(new File(filename));
                    UMLProject.get().setSaved(true);
                    UMLProject.get().setFile(new File(filename));
                    FrameMain.get().setSaveAction(UserInterfaceManager.get().getFromActions("coobra.store"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(FrameMain.get(), "Failed to store changes: " + e.getMessage(), "Store changes", 0);
                }
            }
        }
    }
}

