/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.coobra.actions;

import de.tu_bs.coobra.LocalRepository;
import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeStringCause;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.action.UpdateProjectTreeAction;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class UndoAction
extends AbstractAction {
    public void actionPerformed(ActionEvent event) {
        LocalRepository repo = FujabaChangeManager.getVMRepository();
        if (repo != null && repo.isUndoPossible()) {
            ObjectChange cause = null;
            do {
                ObjectChange change;
                cause = change = repo.getFirstFromChanges();
                while (cause instanceof ObjectChange) {
                    cause = change.getCause();
                }
                if (cause instanceof ObjectChangeStringCause) {
                    FrameMain.get().setStatusLabel("undone: " + cause.toString());
                }
                repo.undo(1);
                FujabaChangeManager.updateUndoRedoActions();
                UMLProject.get().setSaved(!repo.isUndoPossible());
            } while (cause == null && repo.isUndoPossible());
            UMLProject.get().refreshDisplay();
            new UpdateProjectTreeAction().actionPerformed(null);
        } else {
            Toolkit.getDefaultToolkit().beep();
            if (repo == null) {
                FrameMain.get().setStatusLabel("Undo/Redo is deactivated!");
            } else {
                FrameMain.get().setStatusLabel("Nothing to undo!!");
            }
        }
    }
}

