/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class FSAContainer
extends FSAObject {
    public FSAContainer(LogicUnparseInterface incr, String propName) {
        super(incr, propName);
    }

    public FSAContainer(LogicUnparseInterface incr, String propName, JComponent parent) {
        super(incr, propName, parent);
    }

    public FSAContainer(LogicUnparseInterface incr, String propName, JComponent parent, boolean transientProperties) {
        super(incr, propName, parent, transientProperties);
    }

    public FSAContainer(LogicUnparseInterface incr, String propName, JComponent parent, JComponent myJComponent) {
        super(incr, propName, parent, myJComponent);
    }

    public Class getDefaultUpdaterClass() {
        return null;
    }

    public String getDefaultAttrName() {
        return null;
    }

    public JComponent getChildConnector() {
        return this.getJComponent();
    }

    public void addToChildren(FSAObject object) {
        object.setParentOfJComponent(this.getChildConnector());
    }

    public void removeFromChildren(FSAObject object) {
        object.setParentOfJComponent(null);
    }

    public FSAObject[] getChildren() {
        Vector children = new Vector();
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            children.addElement(childIter.next());
        }
        if (children.size() > 0) {
            FSAObject[] fsaChildren = new FSAObject[children.size()];
            return children.toArray(fsaChildren);
        }
        return null;
    }

    public int sizeOfChildren() {
        FSAObject[] children = this.getChildren();
        if (children != null) {
            return children.length;
        }
        return 0;
    }

    public FSAObject getFromChildren(int pos) {
        Iterator childIter = this.iteratorOfChildren();
        int i = 0;
        while (i < pos && childIter.hasNext()) {
            childIter.next();
            ++i;
        }
        if (childIter.hasNext()) {
            return (FSAObject)childIter.next();
        }
        throw new IndexOutOfBoundsException("FSAContainer::getChild (int): " + pos);
    }

    public Iterator iteratorOfChildren() {
        return new Iterator(){
            private JComponent connector;
            private Stack stack = new Stack();
            private FSAObject next;
            {
                this.connector = FSAContainer.this.getChildConnector();
                if (this.connector != null) {
                    this.stack.push(this.connector);
                }
                this.next = this.getNext();
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() throws NoSuchElementException {
                FSAObject value = this.next;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.getNext();
                return value;
            }

            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            private FSAObject getNext() {
                while (!this.stack.empty()) {
                    Object child;
                    Component comp = (Component)this.stack.pop();
                    if (comp != null && comp != this.connector && comp instanceof JComponent && (child = ((JComponent)comp).getClientProperty("FSAObject:revJComponent")) != null && child instanceof FSAObject && child != FSAContainer.this) {
                        return (FSAObject)child;
                    }
                    if (!(comp instanceof Container)) continue;
                    Container container = (Container)comp;
                    int i = container.getComponentCount() - 1;
                    while (i > -1) {
                        Component child2 = container.getComponent(i);
                        this.stack.push(child2);
                        --i;
                    }
                }
                return null;
            }
        };
    }

    public FSAObject[] getFromChildren(Point p) {
        Vector<FSAObject> childrenAt = new Vector<FSAObject>();
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            FSAObject child = (FSAObject)childIter.next();
            JComponent comp = child.getJComponent();
            if (comp == null || !comp.contains(p)) continue;
            childrenAt.addElement(child);
        }
        if (childrenAt.size() > 0) {
            return (FSAObject[])childrenAt.toArray();
        }
        return null;
    }

    public FSAObject[] getFromChildren(Rectangle rect, boolean complete) {
        Vector<FSAObject> childrenIn = new Vector<FSAObject>();
        Iterator childIter = this.iteratorOfChildren();
        while (childIter.hasNext()) {
            FSAObject child = (FSAObject)childIter.next();
            JComponent comp = child.getJComponent();
            if (comp == null) continue;
            Rectangle bounds = comp.getBounds();
            if ((!complete || !rect.contains(bounds)) && (complete || !rect.intersects(bounds))) continue;
            childrenIn.addElement(child);
        }
        if (childrenIn.size() > 0) {
            return (FSAObject[])childrenIn.toArray();
        }
        return null;
    }

    public boolean hasInChildren(FSAObject object) {
        if (object == null) {
            return false;
        }
        JComponent connector = this.getChildConnector();
        Container comp = object.getJComponent();
        while (comp != null) {
            if ((comp = comp.getParent()) != connector) continue;
            return true;
        }
        return false;
    }

    public void addToComponents(Component comp) {
        if (comp != null) {
            Container parent = comp.getParent();
            if (parent != null) {
                parent.remove(comp);
            }
            this.getChildConnector().add(comp);
        }
    }

    public void removeFromComponents(Component comp) {
        JComponent connector = this.getChildConnector();
        if (connector != null) {
            this.getChildConnector().remove(comp);
        }
    }

    public Component[] getComponents() {
        JComponent connector = this.getChildConnector();
        if (connector == null) {
            return null;
        }
        return connector.getComponents();
    }

    public int sizeOfComponents() {
        JComponent connector = this.getChildConnector();
        if (connector == null) {
            return 0;
        }
        return connector.getComponentCount();
    }

    public Component getFromComponents(int pos) {
        JComponent connector = this.getChildConnector();
        if (connector != null) {
            return connector.getComponent(pos);
        }
        throw new IndexOutOfBoundsException("FSAContainer::getFromComponents (int): " + pos);
    }

    public Iterator iteratorOfComponents() {
        return new Iterator(){
            private JComponent connector;
            private int pos;
            private int size;
            {
                this.connector = FSAContainer.this.getChildConnector();
                this.pos = -1;
                this.size = this.connector == null ? 0 : this.connector.getComponentCount();
            }

            public boolean hasNext() {
                return this.pos < this.size - 1;
            }

            public Object next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.pos;
                return this.connector.getComponent(this.pos);
            }

            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean hasInComponents(Component comp) {
        if (comp == null) {
            return false;
        }
        JComponent connector = this.getChildConnector();
        return comp.getParent() == connector;
    }

    public void setBold(boolean bold) {
        super.setBold(bold);
        Iterator iter = this.iteratorOfChildren();
        while (iter.hasNext()) {
            FSAObject child = (FSAObject)iter.next();
            child.setBold(bold);
        }
    }

    public void setItalic(boolean italic) {
        super.setItalic(italic);
        Iterator iter = this.iteratorOfChildren();
        while (iter.hasNext()) {
            FSAObject child = (FSAObject)iter.next();
            child.setItalic(italic);
        }
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        Iterator iter = this.iteratorOfChildren();
        while (iter.hasNext()) {
            FSAObject child = (FSAObject)iter.next();
            child.setOpaque(opaque);
        }
    }

    public void removeYou() {
        FSAObject[] children = this.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].removeYou();
                ++i;
            }
        }
        super.removeYou();
    }
}

