/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.DefaultGrabUI;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabUI;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import java.awt.Point;
import javax.swing.JComponent;

public class FSAGrab
extends FSABend {
    public static final String ALIGNMENT = "alignment";
    public static final String ORIENTATION = "orientation";

    public FSAGrab(LogicUnparseInterface incr, String propName) {
        super(incr, propName);
    }

    public FSAGrab(LogicUnparseInterface incr, String propName, JComponent parent) {
        super(incr, propName, parent);
    }

    public FSAGrab(LogicUnparseInterface incr, String propName, JComponent parent, JComponent myJComponent) {
        super(incr, propName, parent, myJComponent);
    }

    protected JComponent createJComponent() {
        JGrab grab = new JGrab();
        grab.setUI((GrabUI)DefaultGrabUI.createUI(grab));
        return grab;
    }

    public boolean setTarget(FSAObject obj) {
        JGrab grab = (JGrab)this.getJComponent();
        if (grab == null) {
            return false;
        }
        if (obj == null && grab.getTarget() != null) {
            grab.setTarget(null);
            return true;
        }
        if (obj != null && grab.getTarget() != obj.getJComponent()) {
            grab.setTarget(obj.getJComponent());
            return true;
        }
        return false;
    }

    public FSAObject getTarget() {
        JGrab grab = (JGrab)this.getJComponent();
        if (grab == null) {
            return null;
        }
        JComponent target = grab.getTarget();
        if (target != null) {
            return FSAGrab.getFSAObjectFromJComponent(target);
        }
        return null;
    }

    protected void oldInitLocation(Point point) {
        if (point != null) {
            JGrab jgrab = (JGrab)this.getJComponent();
            if (point.getY() < 4.0) {
                jgrab.setAutoAlignment(false);
                jgrab.setAutoOrientation(false);
                jgrab.setAlignment(point.getX() / 2.147483647E9);
                switch ((int)point.getY()) {
                    case 0: {
                        jgrab.setOrientation(Direction.TOP);
                        break;
                    }
                    case 1: {
                        jgrab.setOrientation(Direction.RIGHT);
                        break;
                    }
                    case 2: {
                        jgrab.setOrientation(Direction.BOTTOM);
                        break;
                    }
                    case 3: {
                        jgrab.setOrientation(Direction.LEFT);
                    }
                }
            }
        }
    }

    protected void applyProperties() {
        Point point = this.getPointFromUnparseInformation("location");
        if (point == null && this.getLogic() instanceof ASGElement) {
            ASGElement asgElement = (ASGElement)this.getLogic();
            point = asgElement.getPointFromUnparseInformation(asgElement, this.getPropertyName());
        }
        if (point != null) {
            this.oldInitLocation(point);
        } else {
            JGrab jgrab = (JGrab)this.getJComponent();
            String alignment = this.getUnparseInformation(ALIGNMENT);
            String orientation = this.getUnparseInformation(ORIENTATION);
            if (alignment == null) {
                jgrab.setAutoAlignment(true);
            } else {
                try {
                    jgrab.setAlignment(Double.parseDouble(alignment));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (orientation == null) {
                jgrab.setAutoOrientation(true);
            } else {
                try {
                    switch (Integer.parseInt(orientation)) {
                        case 0: {
                            jgrab.setOrientation(Direction.TOP);
                            break;
                        }
                        case 1: {
                            jgrab.setOrientation(Direction.RIGHT);
                            break;
                        }
                        case 2: {
                            jgrab.setOrientation(Direction.BOTTOM);
                            break;
                        }
                        case 3: {
                            jgrab.setOrientation(Direction.LEFT);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void saveLocation() {
    }

    protected void saveAdditionalFSAProperties() {
        this.saveAlignment();
        this.saveOrientation();
    }

    public void saveAlignment() {
        JGrab jGrab = (JGrab)this.getJComponent();
        if (jGrab == null) {
            return;
        }
        if (jGrab.isAutoAlignment()) {
            this.removeFromUnparseInformation(ALIGNMENT);
        } else {
            this.addUnparseInformation(ALIGNMENT, Double.toString(jGrab.getAlignment()));
        }
    }

    public void saveOrientation() {
        JGrab jGrab = (JGrab)this.getJComponent();
        if (jGrab == null) {
            return;
        }
        if (jGrab.isAutoOrientation()) {
            this.removeFromUnparseInformation(ORIENTATION);
        } else {
            this.addUnparseInformation(ORIENTATION, Integer.toString(jGrab.getOrientation().asInt()));
        }
    }
}

