/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.JComponentAsFSAIterator;
import de.uni_paderborn.fujaba.fsa.PopupSourceListener;
import de.uni_paderborn.fujaba.fsa.listener.SelectionEvent;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListener;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.upb.lib.userinterface.EventSource;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FLinkedList;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JComponent;

public class SelectionManager
implements EventSource,
SelectionListener {
    private static SelectionManager manager;
    private WeakReference popupSource;
    private WeakReference logicPopupSource;
    private JComponent focusedComponent;
    private FLinkedList selectedComponents = new FLinkedList();
    private Set popupSourceListeners;

    private SelectionManager() {
    }

    public static SelectionManager get() {
        if (manager == null) {
            manager = new SelectionManager();
        }
        return manager;
    }

    public void setPopupSource(Component source, LogicUnparseInterface logicSource) {
        this.setPopupSource(source);
        this.setLogicPopupSource(logicSource);
        this.notifyPopupSourceListeners();
    }

    public void setPopupSource(Component source) {
        this.popupSource = source == null ? null : new WeakReference<Component>(source);
    }

    public void setLogicPopupSource(LogicUnparseInterface logicSource) {
        this.logicPopupSource = logicSource == null ? null : new WeakReference<LogicUnparseInterface>(logicSource);
    }

    public LogicUnparseInterface getLogicPopupSource() {
        return this.logicPopupSource == null ? null : this.logicPopupSource.get();
    }

    public Component getPopupSource() {
        return this.popupSource == null ? null : this.popupSource.get();
    }

    public Object getSource() {
        LinkedList<LogicUnparseInterface> list = new LinkedList<LogicUnparseInterface>();
        LogicUnparseInterface iface = this.getLogicPopupSource();
        if (iface != null) {
            list.add(iface);
        }
        Iterator iter = this.iteratorOfSelection();
        while (iter.hasNext()) {
            LogicUnparseInterface incr;
            FSAObject object = (FSAObject)iter.next();
            if (object == null || (incr = object.getLogic()) == null || list.contains(incr)) continue;
            list.add(incr);
        }
        return list.iterator();
    }

    public String getActionCommand() {
        return null;
    }

    public void setSelected(JComponent component, boolean selected) {
        this.setSelected(component, selected, false);
    }

    public void setSelected(JComponent component, boolean selected, boolean multi) {
        boolean oldSelected = this.hasInSelectedComponents(component);
        if (!multi) {
            this.clear();
        }
        if (selected != oldSelected) {
            if (selected) {
                this.addToSelectedComponents(component);
            } else if (multi) {
                this.removeFromSelectedComponents(component);
            }
        } else {
            this.setFocused(component, selected);
        }
    }

    public boolean isSelected(JComponent component) {
        return this.hasInSelectedComponents(component);
    }

    public void setFocused(JComponent component, boolean focus) {
        boolean oldFocused;
        boolean bl = oldFocused = this.getFocusedComponent() == component;
        if (oldFocused != focus) {
            if (focus) {
                this.setFocusedComponent(component);
            } else {
                this.setFocusedComponent(null);
            }
        }
    }

    public boolean isFocused(JComponent component) {
        return this.getFocusedComponent() == component;
    }

    public void setFocusedComponent(JComponent component) {
        if (component != this.focusedComponent) {
            FSAObject fsa;
            JComponent oldFocused = this.focusedComponent;
            this.focusedComponent = component;
            if (oldFocused != null) {
                fsa = FSAObject.getFSAObjectFromJComponent(oldFocused);
                if (fsa != null) {
                    fsa.setFocused(false);
                }
                SelectionListenerHelper.setFocused(oldFocused, false);
                this.setPopupSource(null, null);
            }
            if (component != null) {
                if (!this.hasInSelectedComponents(component)) {
                    this.addToSelectedComponents(component);
                }
                if (component != this.selectedComponents.getLast()) {
                    this.selectedComponents.remove(component);
                    this.selectedComponents.add(component);
                }
                if ((fsa = FSAObject.getFSAObjectFromJComponent(component)) != null) {
                    fsa.setFocused(true);
                }
                SelectionListenerHelper.setFocused(component, true);
                this.setPopupSource(component, FSAObject.getLogicFromJComponent(component));
            }
        }
    }

    public JComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    public void addToSelectedComponents(JComponent component) {
        if (component != null) {
            if (!this.hasInSelectedComponents(component)) {
                this.selectedComponents.add(component);
                FSAObject fsa = FSAObject.getFSAObjectFromJComponent(component);
                if (fsa != null) {
                    fsa.setSelected(true);
                }
                SelectionListenerHelper.setSelected(component, true);
                SelectionListenerHelper.addSelectionListener(component, this);
            } else if (this.selectedComponents.getLast() != component) {
                this.selectedComponents.remove(component);
                this.selectedComponents.add(component);
            }
            this.setFocusedComponent(component);
        }
    }

    public void addToSelectedComponents(JComponent[] components) {
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                this.addToSelectedComponents(components[i]);
                ++i;
            }
        }
    }

    public Iterator iteratorOfSelectedComponents() {
        return this.selectedComponents.iterator();
    }

    public Iterator iteratorOfSelectedComponentsAsIncrements() {
        return this.iteratorOfSelectionAsIncrements();
    }

    public boolean hasInSelectedComponents(JComponent object) {
        return this.selectedComponents.contains(object);
    }

    public int sizeOfSelectedComponents() {
        return this.selectedComponents.size();
    }

    public void replaceSelectedComponents(JComponent object) {
        this.clear();
        this.addToSelectedComponents(object);
    }

    public void replaceSelectedComponents(JComponent[] objects) {
        this.clear();
        this.addToSelectedComponents(objects);
    }

    public void removeFromSelectedComponents(JComponent object) {
        if (object != null && this.hasInSelectedComponents(object)) {
            SelectionListenerHelper.removeSelectionListener(object, this);
            if (object == this.getFocusedComponent()) {
                this.setFocusedObject(null);
            }
            this.selectedComponents.remove(object);
            FSAObject fsa = FSAObject.getFSAObjectFromJComponent(object);
            if (fsa != null) {
                fsa.setSelected(false);
            }
            SelectionListenerHelper.setSelected(object, false);
        }
    }

    public void removeAllFromSelectedComponents() {
        Iterator it = this.iteratorOfSelectedComponents();
        while (it.hasNext()) {
            JComponent component = (JComponent)it.next();
            this.removeFromSelectedComponents(component);
        }
    }

    public void removeFromSelectedComponents(JComponent[] objects) {
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                this.removeFromSelectedComponents(objects[i]);
                ++i;
            }
        }
    }

    public JComponent prevComponent(JComponent object) {
        JComponent prev;
        int index;
        if (object == null || (index = this.selectedComponents.indexOf(object)) <= 0) {
            index = this.selectedComponents.size();
        }
        if (index > 0 && (prev = (JComponent)this.selectedComponents.get(index - 1)) != object) {
            return prev;
        }
        return null;
    }

    public JComponent nextComponent(JComponent object) {
        JComponent next;
        int index;
        int size = this.selectedComponents.size();
        if (object == null || (index = this.selectedComponents.indexOf(object)) >= size - 1) {
            index = -1;
        }
        if (index < size - 1 && (next = (JComponent)this.selectedComponents.get(index + 1)) != object) {
            return next;
        }
        return null;
    }

    public JComponent[] getLastSelectedComponents(JComponent obj, int length) {
        int size = this.selectedComponents.size();
        if (length > size || length == -1) {
            length = size;
        }
        List<JComponent> objects = this.selectedComponents.subList(size - length, size);
        if (obj != null) {
            if (objects.contains(obj)) {
                objects.remove(obj);
            } else {
                objects.remove(0);
            }
            objects.add(obj);
        }
        return objects.toArray(new JComponent[size]);
    }

    public JComponent[] getLastSelectedComponentsOfType(JComponent type, int length) {
        Class<?> typeClass = type.getClass();
        return this.getLastSelectedComponentsOfType(typeClass, length);
    }

    public JComponent[] getLastSelectedComponentsOfType(Class typeClass, int length) {
        LinkedList<JComponent> objects = new LinkedList<JComponent>();
        ListIterator iter = this.selectedComponents.listIterator(this.selectedComponents.size());
        int size = 0;
        while (iter.hasPrevious() && size < length) {
            JComponent temp = (JComponent)iter.previous();
            if (!typeClass.isInstance(temp)) continue;
            objects.add(0, temp);
            ++size;
        }
        return objects.toArray(new JComponent[size]);
    }

    public JComponent[] getSelectedComponents() {
        int size = this.selectedComponents.size();
        if (size > 0) {
            Object[] objects = new JComponent[this.selectedComponents.size()];
            return (JComponent[])this.selectedComponents.toArray(objects);
        }
        return null;
    }

    public void clear() {
        while (this.selectedComponents.size() > 0) {
            this.removeFromSelectedComponents((JComponent)this.selectedComponents.getFirst());
        }
    }

    public void setSelected(FSAObject object, boolean selected) {
        this.setSelected(object, selected, false);
    }

    public void setSelected(FSAObject object, boolean selected, boolean multi) {
        this.setSelected(object == null ? null : object.getJComponent(), selected, multi);
    }

    public void setFocused(FSAObject object, boolean focus) {
        this.setFocused(object == null ? null : object.getJComponent(), focus);
    }

    public void setFocusedObject(FSAObject object) {
        this.setFocusedComponent(object == null ? null : object.getJComponent());
    }

    public FSAObject getFocusedObject() {
        return this.focusedComponent == null ? null : FSAObject.getFSAObjectFromJComponent(this.focusedComponent);
    }

    public void addToSelection(FSAObject object) {
        if (object != null) {
            this.addToSelectedComponents(object.getJComponent());
        }
    }

    public void addToSelection(FSAObject[] objects) {
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                this.addToSelection(objects[i]);
                ++i;
            }
        }
    }

    public Iterator iteratorOfSelection() {
        return new JComponentAsFSAIterator(this.selectedComponents.iterator());
    }

    public Iterator iteratorOfSelectionAsIncrements() {
        LinkedList<LogicUnparseInterface> list = new LinkedList<LogicUnparseInterface>();
        Iterator iter = this.iteratorOfSelection();
        while (iter.hasNext()) {
            LogicUnparseInterface incr = ((FSAObject)iter.next()).getLogic();
            if (incr == null) continue;
            list.add(incr);
        }
        return list.iterator();
    }

    public boolean hasInSelection(FSAObject object) {
        return object != null && this.hasInSelectedComponents(object.getJComponent());
    }

    public int sizeOfSelection() {
        return this.sizeOfSelectedComponents();
    }

    public void replaceSelection(FSAObject object) {
        this.replaceSelectedComponents(object == null ? null : object.getJComponent());
    }

    public void replaceSelection(FSAObject[] objects) {
        this.clear();
        this.addToSelection(objects);
    }

    public void removeFromSelection(FSAObject object) {
        if (object != null) {
            this.removeFromSelectedComponents(object.getJComponent());
        }
    }

    public void removeFromSelection(FSAObject[] objects) {
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] != null) {
                    this.removeFromSelectedComponents(objects[i].getJComponent());
                }
                ++i;
            }
        }
    }

    public FSAObject prevObject(FSAObject object) {
        JComponent tmpResult = object == null ? null : object.getJComponent();
        FSAObject result = null;
        do {
            tmpResult = this.prevComponent(tmpResult);
            result = FSAObject.getFSAObjectFromJComponent(tmpResult);
        } while (tmpResult != null && result == null);
        return result;
    }

    public FSAObject nextObject(FSAObject object) {
        JComponent tmpResult = object == null ? null : object.getJComponent();
        FSAObject result = null;
        do {
            tmpResult = this.nextComponent(tmpResult);
            result = FSAObject.getFSAObjectFromJComponent(tmpResult);
        } while (tmpResult != null && result == null);
        return result;
    }

    public FSAObject[] getLastSelections(FSAObject obj, int length) {
        LinkedList<FSAObject> objects = new LinkedList<FSAObject>();
        FSAObject prev = this.prevObject(null);
        int i = 0;
        while (i < length && prev != null) {
            objects.add(prev);
            ++i;
            prev = this.prevObject(prev);
        }
        if (obj != null) {
            if (objects.contains(obj)) {
                objects.remove(obj);
            } else {
                objects.remove(0);
            }
            objects.add(obj);
        }
        return objects.toArray(new FSAObject[objects.size()]);
    }

    public FSAObject[] getLastSelectionsOfType(FSAObject type, int length) {
        Class<?> typeClass = type.getClass();
        return this.getLastSelectionsOfType(typeClass, length);
    }

    public FSAObject[] getLastSelectionsOfType(Class typeClass) {
        return this.getLastSelectionsOfType(typeClass, Integer.MAX_VALUE);
    }

    public FSAObject[] getLastSelectionsOfType(Class typeClass, int length) {
        LinkedList<FSAObject> objects = new LinkedList<FSAObject>();
        ListIterator iter = this.selectedComponents.listIterator(this.selectedComponents.size());
        int size = 0;
        while (iter.hasPrevious() && size < length) {
            JComponent temp = (JComponent)iter.previous();
            FSAObject object = FSAObject.getFSAObjectFromJComponent(temp);
            if (object == null || !typeClass.isInstance(object)) continue;
            objects.add(0, object);
            ++size;
        }
        return objects.toArray(new FSAObject[size]);
    }

    public FSAObject[] getSelectedObjects() {
        int size = this.selectedComponents.size();
        if (size > 0) {
            LinkedList<FSAObject> objects = new LinkedList<FSAObject>();
            Iterator iter = this.iteratorOfSelectedComponents();
            while (iter.hasNext()) {
                JComponent temp = (JComponent)iter.next();
                FSAObject object = FSAObject.getFSAObjectFromJComponent(temp);
                if (object == null) continue;
                objects.add(object);
            }
            if (objects.size() > 0) {
                return objects.toArray(new FSAObject[objects.size()]);
            }
        }
        return null;
    }

    public void selectionChanged(SelectionEvent event) {
        JComponent source = (JComponent)event.getSource();
        if (event.isFocusChanged()) {
            if (this.getFocusedComponent() == source && !event.isFocused()) {
                this.setFocusedComponent(null);
            } else if (this.getFocusedComponent() != source && event.isFocused()) {
                this.setFocusedComponent(source);
            }
        }
        if (event.isSelectionChanged()) {
            if (this.hasInSelectedComponents(source) && !event.isSelected()) {
                this.removeFromSelectedComponents(source);
            } else if (!this.hasInSelectedComponents(source) && event.isSelected()) {
                this.addToSelectedComponents(source);
            }
        }
    }

    private void notifyPopupSourceListeners() {
        if (this.popupSourceListeners != null) {
            LogicUnparseInterface source = this.getLogicPopupSource();
            Iterator it = this.popupSourceListeners.iterator();
            while (it.hasNext()) {
                PopupSourceListener listener = (PopupSourceListener)it.next();
                try {
                    listener.popupSourceChanged(source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addToPopupSourceListeners(PopupSourceListener listener) {
        if (listener != null) {
            if (this.popupSourceListeners == null) {
                this.popupSourceListeners = new FHashSet();
            }
            this.popupSourceListeners.add(listener);
        }
    }

    public void removeFromPopupSourceListeners(PopupSourceListener listener) {
        if (this.popupSourceListeners != null) {
            this.popupSourceListeners.remove(listener);
        }
    }

    public void addToSelection(ASGElement element) {
        Iterator it = element.iteratorOfFsaObjects();
        while (it.hasNext()) {
            FSAObject fsaObject = (FSAObject)it.next();
            this.addToSelection(fsaObject);
        }
    }
}

