/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.listener.SelectionEvent;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListener;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import javax.swing.JComponent;

public class ArrowMoveListener
implements KeyListener,
SelectionListener {
    private static ArrowMoveListener singleton;

    private ArrowMoveListener() {
    }

    public static ArrowMoveListener get() {
        if (singleton == null) {
            singleton = new ArrowMoveListener();
        }
        return singleton;
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        boolean arrowKey = false;
        int modifier = 1;
        if (event.isControlDown()) {
            modifier = 2;
        } else if (event.isShiftDown()) {
            modifier = 10;
        }
        SelectionManager mgr = SelectionManager.get();
        Iterator iter = mgr.iteratorOfSelectedComponents();
        while (iter.hasNext()) {
            JComponent comp = (JComponent)iter.next();
            Point loc = comp.getLocation();
            switch (event.getKeyCode()) {
                case 38: {
                    loc.translate(0, -modifier);
                    arrowKey = true;
                    break;
                }
                case 40: {
                    loc.translate(0, modifier);
                    arrowKey = true;
                    break;
                }
                case 37: {
                    loc.translate(-modifier, 0);
                    arrowKey = true;
                    break;
                }
                case 39: {
                    loc.translate(modifier, 0);
                    arrowKey = true;
                }
            }
            comp.setLocation(loc);
        }
        if (arrowKey && mgr.sizeOfSelectedComponents() > 0) {
            event.consume();
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void selectionChanged(SelectionEvent event) {
        if (event.getSource() instanceof JComponent) {
            ((JComponent)event.getSource()).requestFocusInWindow();
        }
    }
}

