/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.MouseInputListener;

public class AscendDescendMouseHandler
implements MouseInputListener {
    private final WeakReference target;
    private boolean active = false;
    private EventListener listener;
    private EventListener ascendListener;
    private EventListener descendListener;
    private static transient ADHandler adHandler = new ADHandler();
    private static Consumer consumer = null;
    private static AscendConsumer ascendConsumer = null;
    private static DescendConsumer descendConsumer = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    AscendDescendMouseHandler(Component target) {
        this.target = new WeakReference<Component>(target);
    }

    public synchronized void addMouseListener(MouseListener l) {
        Component comp;
        if (l == null) {
            return;
        }
        if (!this.active && (comp = (Component)this.target.get()) != null) {
            comp.addMouseListener(this);
            this.active = true;
        }
        boolean isAD = false;
        if (l instanceof Ascend) {
            this.ascendListener = AWTEventMulticaster.add((MouseListener)this.ascendListener, l);
            isAD = true;
        }
        if (l instanceof Descend) {
            this.descendListener = AWTEventMulticaster.add((MouseListener)this.descendListener, l);
            isAD = true;
        }
        if (!isAD) {
            this.listener = AWTEventMulticaster.add((MouseListener)this.listener, l);
        }
    }

    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        Component comp;
        if (l == null) {
            return;
        }
        if (!this.active && (comp = (Component)this.target.get()) != null) {
            comp.addMouseMotionListener(this);
            this.active = true;
        }
        boolean isAD = false;
        if (l instanceof Ascend) {
            this.ascendListener = AWTEventMulticaster.add((MouseMotionListener)this.ascendListener, l);
            isAD = true;
        }
        if (l instanceof Descend) {
            this.descendListener = AWTEventMulticaster.add((MouseMotionListener)this.descendListener, l);
            isAD = true;
        }
        if (!isAD) {
            this.listener = AWTEventMulticaster.add((MouseMotionListener)this.listener, l);
        }
    }

    public synchronized void removeMouseListener(MouseListener l) {
        Component comp;
        if (l == null) {
            return;
        }
        boolean isAD = false;
        if (l instanceof Ascend) {
            this.ascendListener = AWTEventMulticaster.remove((MouseListener)this.ascendListener, l);
            isAD = true;
        }
        if (l instanceof Descend) {
            this.descendListener = AWTEventMulticaster.remove((MouseListener)this.descendListener, l);
            isAD = true;
        }
        if (!isAD) {
            this.listener = AWTEventMulticaster.remove((MouseListener)this.listener, l);
        }
        if (this.active && this.ascendListener == null && this.descendListener == null && this.listener == null && (comp = (Component)this.target.get()) != null) {
            comp.removeMouseListener(this);
            comp.removeMouseMotionListener(this);
            this.active = false;
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        Component comp;
        if (l == null) {
            return;
        }
        boolean isAD = false;
        if (l instanceof Ascend) {
            this.ascendListener = AWTEventMulticaster.remove((MouseMotionListener)this.ascendListener, l);
            isAD = true;
        }
        if (l instanceof Descend) {
            this.descendListener = AWTEventMulticaster.remove((MouseMotionListener)this.descendListener, l);
            isAD = true;
        }
        if (!isAD) {
            this.listener = AWTEventMulticaster.remove((MouseMotionListener)this.listener, l);
        }
        if (this.active && this.ascendListener == null && this.descendListener == null && this.listener == null && (comp = (Component)this.target.get()) != null) {
            comp.removeMouseListener(this);
            comp.removeMouseMotionListener(this);
            this.active = false;
        }
    }

    public EventListener getAscendListener() {
        return this.ascendListener;
    }

    public EventListener getDescendListener() {
        return this.descendListener;
    }

    public void mousePressed(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseListener)this.listener);
    }

    public void mouseReleased(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseListener)this.listener);
    }

    public void mouseClicked(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseListener)this.listener);
    }

    public void mouseEntered(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseListener)this.listener);
    }

    public void mouseExited(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseListener)this.listener);
    }

    public void mouseMoved(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseMotionListener)this.listener);
    }

    public void mouseDragged(MouseEvent e) {
        AscendDescendMouseHandler.dispatchEvent(e, (MouseMotionListener)this.listener);
    }

    public static void registerADMouseHandler(Component component) {
        if (component != null) {
            EventListener[] listeners;
            AscendDescendMouseHandler handler;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.event.MouseListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((handler = AscendDescendMouseHandler.getHandler(listeners = (MouseListener[])component.getListeners(clazz))) == null) {
                handler = AscendDescendMouseHandler.getADHandler();
                component.addMouseListener(handler);
            }
        }
    }

    public static void registerADMouseMotionHandler(Component component) {
        if (component != null) {
            EventListener[] listeners;
            AscendDescendMouseHandler handler;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.awt.event.MouseMotionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((handler = AscendDescendMouseHandler.getHandler(listeners = (MouseMotionListener[])component.getListeners(clazz))) == null) {
                handler = AscendDescendMouseHandler.getADHandler();
                component.addMouseMotionListener(handler);
            }
        }
    }

    public static void unregisterADMouseHandler(Component component) {
        if (component != null) {
            component.removeMouseListener(AscendDescendMouseHandler.getADHandler());
        }
    }

    public static void unregisterADMouseMotionHandler(Component component) {
        if (component != null) {
            component.removeMouseMotionListener(AscendDescendMouseHandler.getADHandler());
        }
    }

    public static void registerADMouseInputHandler(Component component) {
        AscendDescendMouseHandler.registerADMouseHandler(component);
        AscendDescendMouseHandler.registerADMouseMotionHandler(component);
    }

    public static void unregisterADMouseInputHandler(Component component) {
        AscendDescendMouseHandler.unregisterADMouseHandler(component);
        AscendDescendMouseHandler.unregisterADMouseMotionHandler(component);
    }

    public static void addMouseListener(Component component, MouseListener listener) {
        if (component != null && listener != null) {
            EventListener[] listeners;
            AscendDescendMouseHandler handler;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.event.MouseListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((handler = AscendDescendMouseHandler.getHandler(listeners = (MouseListener[])component.getListeners(clazz))) == AscendDescendMouseHandler.getADHandler()) {
                component.removeMouseListener(handler);
                handler = null;
            }
            if (handler == null) {
                handler = new AscendDescendMouseHandler(component);
                AscendDescendMouseHandler.registerADMouseMotionHandler(component);
            }
            handler.addMouseListener(listener);
        }
    }

    public static void addMouseMotionListener(Component component, MouseMotionListener listener) {
        if (component != null && listener != null) {
            EventListener[] listeners;
            AscendDescendMouseHandler handler;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.awt.event.MouseMotionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((handler = AscendDescendMouseHandler.getHandler(listeners = (MouseMotionListener[])component.getListeners(clazz))) == AscendDescendMouseHandler.getADHandler()) {
                component.removeMouseMotionListener(handler);
                handler = null;
            }
            if (handler == null) {
                handler = new AscendDescendMouseHandler(component);
                AscendDescendMouseHandler.registerADMouseHandler(component);
            }
            handler.addMouseMotionListener(listener);
        }
    }

    public static void addMouseInputListener(Component component, MouseInputListener listener) {
        AscendDescendMouseHandler.addMouseListener(component, listener);
        AscendDescendMouseHandler.addMouseMotionListener(component, listener);
    }

    public static void removeMouseListener(Component component, MouseListener listener) {
        if (component != null && listener != null) {
            component.removeMouseListener(listener);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.awt.event.MouseListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MouseListener[] listeners = (MouseListener[])component.getListeners(clazz);
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof AscendDescendMouseHandler) {
                    ((AscendDescendMouseHandler)listeners[i]).removeMouseListener(listener);
                }
                ++i;
            }
        }
    }

    public static void removeMouseMotionListener(Component component, MouseMotionListener listener) {
        if (component != null && listener != null) {
            component.removeMouseMotionListener(listener);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.awt.event.MouseMotionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MouseMotionListener[] listeners = (MouseMotionListener[])component.getListeners(clazz);
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof AscendDescendMouseHandler) {
                    ((AscendDescendMouseHandler)listeners[i]).removeMouseMotionListener(listener);
                }
                ++i;
            }
        }
    }

    public static void removeMouseInputListener(Component component, MouseInputListener listener) {
        AscendDescendMouseHandler.removeMouseListener(component, listener);
        AscendDescendMouseHandler.removeMouseMotionListener(component, listener);
    }

    private static AscendDescendMouseHandler getHandler(EventListener[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof AscendDescendMouseHandler) {
                return (AscendDescendMouseHandler)listeners[i];
            }
            ++i;
        }
        return null;
    }

    public static void claimMouseListeners(Component component) {
        EventListener[] listeners;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.event.MouseListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((listeners = (MouseListener[])component.getListeners(clazz)).length > 0) {
            AscendDescendMouseHandler handler = AscendDescendMouseHandler.getHandler(listeners);
            if (handler == AscendDescendMouseHandler.getADHandler()) {
                component.removeMouseListener(handler);
                handler = null;
            }
            if (handler == null) {
                handler = new AscendDescendMouseHandler(component);
                component.addMouseListener(handler);
                AscendDescendMouseHandler.registerADMouseMotionHandler(component);
            }
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] != handler && listeners[i] != AscendDescendMouseHandler.getADHandler()) {
                    component.removeMouseListener((MouseListener)listeners[i]);
                    handler.addMouseListener((MouseListener)listeners[i]);
                }
                ++i;
            }
        }
    }

    public static void claimMouseMotionListeners(Component component) {
        EventListener[] listeners;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.event.MouseMotionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((listeners = (MouseMotionListener[])component.getListeners(clazz)).length > 0) {
            AscendDescendMouseHandler handler = AscendDescendMouseHandler.getHandler(listeners);
            if (handler == AscendDescendMouseHandler.getADHandler()) {
                component.removeMouseMotionListener(handler);
                handler = null;
            }
            if (handler == null) {
                handler = new AscendDescendMouseHandler(component);
                component.addMouseMotionListener(handler);
                AscendDescendMouseHandler.registerADMouseHandler(component);
            }
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] != handler && listeners[i] != AscendDescendMouseHandler.getADHandler()) {
                    component.removeMouseMotionListener((MouseMotionListener)listeners[i]);
                    handler.addMouseMotionListener((MouseMotionListener)listeners[i]);
                }
                ++i;
            }
        }
    }

    private static void getADInfo(MouseEvent e, LinkedList ascend, LinkedList descend) {
        int id = e.getID();
        boolean motionEvent = id == 503 || id == 506;
        Component current = e.getComponent();
        int xOff = 0;
        int yOff = 0;
        EventListener[] listeners = null;
        while (current != null) {
            if (motionEvent) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.awt.event.MouseMotionListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                listeners = current.getListeners(clazz);
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("java.awt.event.MouseListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                listeners = current.getListeners(clazz);
            }
            if (listeners.length > 0) {
                LinkedList<Object> ascendEntry = null;
                LinkedList<Object> descendEntry = null;
                int i = 0;
                while (i < listeners.length) {
                    EventListener tmpListener = listeners[i];
                    if (tmpListener instanceof AscendDescendMouseHandler) {
                        AscendDescendMouseHandler handler = (AscendDescendMouseHandler)tmpListener;
                        if ((tmpListener = handler.getAscendListener()) != null) {
                            if (ascendEntry == null) {
                                ascendEntry = new LinkedList();
                                ascendEntry.add(current);
                                ascendEntry.add(new int[]{xOff, yOff});
                            }
                            ascendEntry.add(tmpListener);
                        }
                        if ((tmpListener = handler.getDescendListener()) != null) {
                            if (descendEntry == null) {
                                descendEntry = new LinkedList();
                                descendEntry.add(current);
                                descendEntry.add(new int[]{xOff, yOff});
                            }
                            descendEntry.add(tmpListener);
                        }
                    } else {
                        if (tmpListener instanceof Ascend) {
                            if (ascendEntry == null) {
                                ascendEntry = new LinkedList<Object>();
                                ascendEntry.add(current);
                                ascendEntry.add(new int[]{xOff, yOff});
                            }
                            ascendEntry.add(tmpListener);
                        }
                        if (tmpListener instanceof Descend) {
                            if (descendEntry == null) {
                                descendEntry = new LinkedList<Object>();
                                descendEntry.add(current);
                                descendEntry.add(new int[]{xOff, yOff});
                            }
                            descendEntry.add(tmpListener);
                        }
                    }
                    ++i;
                }
                if (ascendEntry != null) {
                    ascend.addFirst(ascendEntry);
                }
                if (descendEntry != null) {
                    descend.add(descendEntry);
                }
            }
            xOff += current.getX();
            yOff += current.getY();
            current = current.getParent();
        }
    }

    private static boolean dispatchEvent(MouseEvent e, Component comp, Component realSource, int xOff, int yOff, Iterator listeners, boolean ascend) {
        ADMouseEvent convertedEvent = AscendDescendMouseHandler.cloneEvent(e, comp, realSource, xOff, yOff);
        convertedEvent.ascend = ascend;
        while (listeners.hasNext()) {
            EventListener tmpListener = (EventListener)listeners.next();
            AscendDescendMouseHandler.fireEvent(convertedEvent, tmpListener);
        }
        if (convertedEvent.isConsumed()) {
            e.consume();
            return true;
        }
        return false;
    }

    private static void fireEvent(MouseEvent e, EventListener listener) {
        int id = e.getID();
        switch (id) {
            case 501: {
                ((MouseListener)listener).mousePressed(e);
                break;
            }
            case 502: {
                ((MouseListener)listener).mouseReleased(e);
                break;
            }
            case 500: {
                ((MouseListener)listener).mouseClicked(e);
                break;
            }
            case 504: {
                ((MouseListener)listener).mouseEntered(e);
                break;
            }
            case 505: {
                ((MouseListener)listener).mouseExited(e);
                break;
            }
            case 503: {
                ((MouseMotionListener)listener).mouseMoved(e);
                break;
            }
            case 506: {
                ((MouseMotionListener)listener).mouseDragged(e);
            }
        }
    }

    public static void dispatchEvent(MouseEvent e, MouseListener sourceListener) {
        AscendDescendMouseHandler.dispatchEventImpl(e, sourceListener);
    }

    public static void dispatchEvent(MouseEvent e, MouseMotionListener sourceListener) {
        AscendDescendMouseHandler.dispatchEventImpl(e, sourceListener);
    }

    private static void dispatchEventImpl(MouseEvent e, EventListener sourceListener) {
        int[] offset;
        Component source;
        Iterator stepIter;
        LinkedList ascendList = new LinkedList();
        LinkedList descendList = new LinkedList();
        AscendDescendMouseHandler.getADInfo(e, ascendList, descendList);
        int id = e.getID();
        boolean enterExit = id == 504 || id == 505;
        Component realSource = e.getComponent();
        boolean consumed = false;
        if (ascendList.size() > 0) {
            Iterator ascendIter = ascendList.iterator();
            while (ascendIter.hasNext()) {
                List ascendStepList = (List)ascendIter.next();
                stepIter = ascendStepList.iterator();
                source = (Component)stepIter.next();
                offset = (int[])stepIter.next();
                if (!enterExit || offset[0] == 0 && offset[1] == 0) {
                    consumed = AscendDescendMouseHandler.dispatchEvent(e, source, realSource, offset[0], offset[1], stepIter, true);
                }
                if (!consumed) continue;
                return;
            }
        }
        if (sourceListener != null) {
            AscendDescendMouseHandler.fireEvent(e, sourceListener);
            if (consumed) {
                return;
            }
        }
        if (descendList.size() > 0) {
            Iterator descendIter = descendList.iterator();
            while (descendIter.hasNext()) {
                List descendStepList = (List)descendIter.next();
                stepIter = descendStepList.iterator();
                source = (Component)stepIter.next();
                offset = (int[])stepIter.next();
                if (!enterExit || offset[0] == 0 && offset[1] == 0) {
                    consumed = AscendDescendMouseHandler.dispatchEvent(e, source, realSource, offset[0], offset[1], stepIter, false);
                }
                if (!consumed) continue;
                return;
            }
        }
    }

    private static ADMouseEvent cloneEvent(MouseEvent e, Component source, Component realSource, int xOff, int yOff) {
        return new ADMouseEvent(source, realSource, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + xOff, e.getY() + yOff, e.getClickCount(), e.isPopupTrigger());
    }

    public static boolean isADMouseEvent(MouseEvent evt) {
        return evt instanceof ADMouseEvent;
    }

    public static boolean isAscendMouseEvent(MouseEvent evt) {
        if (AscendDescendMouseHandler.isADMouseEvent(evt)) {
            return ((ADMouseEvent)evt).ascend;
        }
        return false;
    }

    public static boolean isDescendMouseEvent(MouseEvent evt) {
        if (AscendDescendMouseHandler.isADMouseEvent(evt)) {
            return !((ADMouseEvent)evt).ascend;
        }
        return false;
    }

    protected static ADHandler getADHandler() {
        return adHandler;
    }

    public static Consumer getConsumer() {
        if (consumer == null) {
            consumer = new Consumer();
        }
        return consumer;
    }

    public static AscendConsumer getAscendConsumer() {
        if (ascendConsumer == null) {
            ascendConsumer = new AscendConsumer();
        }
        return ascendConsumer;
    }

    public static DescendConsumer getDescendConsumer() {
        if (descendConsumer == null) {
            descendConsumer = new DescendConsumer();
        }
        return descendConsumer;
    }

    public static class ADMouseEvent
    extends MouseEvent {
        private final Component realSource;
        boolean ascend = true;

        public ADMouseEvent(Component source, Component realSource, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
            super(source, id, when, modifiers, x, y, clickCount, popupTrigger);
            this.realSource = realSource;
        }

        public Component getRealSource() {
            return this.realSource;
        }

        public boolean isAscend() {
            return this.ascend;
        }
    }

    public static interface Ascend {
    }

    public static interface Descend {
    }

    private static final class ADHandler
    extends AscendDescendMouseHandler {
        ADHandler() {
            super(null);
        }

        public void addMouseListener(MouseListener l) {
            throw new UnsupportedOperationException();
        }

        public void addMouseMotionListener(MouseMotionListener l) {
            throw new UnsupportedOperationException();
        }

        public synchronized void removeMouseListener(MouseListener l) {
        }

        public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        }
    }

    public static class Consumer
    implements MouseInputListener {
        Consumer() {
        }

        public void mousePressed(MouseEvent e) {
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
            e.consume();
        }

        public void mouseClicked(MouseEvent e) {
            e.consume();
        }

        public void mouseEntered(MouseEvent e) {
            e.consume();
        }

        public void mouseExited(MouseEvent e) {
            e.consume();
        }

        public void mouseMoved(MouseEvent e) {
            e.consume();
        }

        public void mouseDragged(MouseEvent e) {
            e.consume();
        }
    }

    public static class AscendConsumer
    extends Consumer
    implements Ascend {
        AscendConsumer() {
        }
    }

    public static class DescendConsumer
    extends Consumer
    implements Descend {
        DescendConsumer() {
        }
    }
}

