/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.swing.JCollapsable;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class CollapsableMouseListener
implements MouseListener,
AscendDescendMouseHandler.Descend {
    private static CollapsableMouseListener listener = null;
    private Rectangle collapsableRect = null;

    private CollapsableMouseListener() {
    }

    public static CollapsableMouseListener get() {
        if (listener == null) {
            listener = new CollapsableMouseListener();
        }
        return listener;
    }

    private void refresh(JCollapsable collapsable) {
        collapsable.setPreferredSize(null);
        JComponent parent = (JComponent)collapsable.getParent();
        if (parent != null) {
            while (parent != null && parent.getParent() instanceof JComponent) {
                parent.setPreferredSize(null);
                parent = (JComponent)parent.getParent();
            }
            if (parent != null) {
                parent.setPreferredSize(null);
                parent.validate();
            }
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getSource() instanceof JCollapsable) {
            JCollapsable collapsable = (JCollapsable)event.getSource();
            this.proofCollapsable(collapsable, event);
            if (this.collapsableRect.contains(event.getPoint())) {
                collapsable.toggleCollapsed();
                this.refresh(collapsable);
                event.consume();
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    private void proofCollapsable(JCollapsable tmpCollapsable, MouseEvent event) {
        if (this.collapsableRect == null) {
            this.collapsableRect = new Rectangle();
            this.collapsableRect.width = 9;
            this.collapsableRect.height = 9;
        }
        Rectangle tmpRect = tmpCollapsable.getBounds();
        this.collapsableRect.x = tmpRect.width - 9 - tmpCollapsable.getInsetWidth();
        this.collapsableRect.y = tmpRect.height - 9;
    }
}

