/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.listener.ComponentMouseListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class ComponentBorderListener
extends ComponentMouseListener
implements AscendDescendMouseHandler.Ascend {
    private Component theComponent = null;
    private static ComponentBorderListener listener = null;

    private ComponentBorderListener() {
    }

    public static ComponentBorderListener get() {
        if (listener == null) {
            listener = new ComponentBorderListener();
        }
        return listener;
    }

    public void mousePressed(MouseEvent event) {
        JComponent comp = (JComponent)event.getSource();
        this.setOrientation(comp, event);
        if (this.getOrientation() != -1 && this.getOrientation() != 16) {
            this.theComponent = comp;
            event.consume();
        }
    }

    public void mouseReleased(MouseEvent event) {
        JComponent comp = (JComponent)event.getSource();
        this.setOrientation(comp, event);
        if (this.getOrientation() != -1 && this.getOrientation() != 16) {
            this.theComponent = null;
            event.consume();
        }
    }

    private void refresh(JComponent comp) {
        comp.validate();
    }

    public void mouseDragged(MouseEvent event) {
        JComponent comp = (JComponent)event.getSource();
        if (comp != null && comp == this.theComponent) {
            Point eventPoint = event.getPoint();
            Point point = comp.getLocation();
            Dimension rect = comp.getSize();
            int deltaHeight = (int)eventPoint.getY();
            int deltaWidth = (int)eventPoint.getX();
            int newHeight = rect.height;
            int newWidth = rect.width;
            int orientation = this.getOrientation();
            if ((orientation & 1) == 1) {
                newHeight -= deltaHeight;
                deltaHeight = rect.height - newHeight;
                rect.height = newHeight;
                point.y += deltaHeight;
            }
            if ((orientation & 4) == 4) {
                newWidth -= deltaWidth;
                deltaWidth = rect.width - newWidth;
                rect.width = newWidth;
                point.x += deltaWidth;
            }
            if ((orientation & 8) == 8) {
                rect.width = newWidth += (deltaWidth -= rect.width);
            }
            if ((orientation & 2) == 2) {
                rect.height = newHeight += (deltaHeight -= rect.height);
            }
            if (orientation != -1 && orientation != 16) {
                comp.setLocation(point);
                rect.width = Math.max(rect.width, 10);
                rect.height = Math.max(rect.height, 10);
                comp.setSize(rect);
                comp.setPreferredSize(rect);
                this.refresh(comp);
                event.consume();
            }
        }
    }
}

