/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.tu_bs.coobra.ObjectChange;
import de.tu_bs.coobra.ObjectChangeCause;
import de.tu_bs.coobra.ObjectChangeStringCause;
import de.uni_paderborn.fujaba.fsa.FSABend;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.listener.ComponentMouseListener;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import de.uni_paderborn.fujaba.fsa.swing.LayerManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class DragMouseListener
extends ComponentMouseListener
implements AscendDescendMouseHandler.Descend {
    private static DragMouseListener singleton = null;
    private Point lastPoint = null;
    protected boolean dragging = false;

    protected DragMouseListener() {
    }

    public static DragMouseListener get() {
        if (singleton == null) {
            singleton = new DragMouseListener();
        }
        return singleton;
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() == 1) {
            this.lastPoint = event.getPoint();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.getClickCount() == 1) {
            JComponent comp = (JComponent)event.getSource();
            this.setOrientation(comp, event);
            this.lastComponent = comp;
            this.lastPoint = event.getPoint();
            event.consume();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mouseReleased(MouseEvent event) {
        JComponent comp = (JComponent)event.getSource();
        ObjectChangeStringCause saveLocationsCause = new ObjectChangeStringCause("drag");
        ObjectChange.pushCause((ObjectChangeCause)saveLocationsCause);
        try {
            Iterator iter = SelectionManager.get().iteratorOfSelection();
            while (iter.hasNext()) {
                FSAObject object = (FSAObject)iter.next();
                object.setTransientProperties(false);
                object.saveLocation();
                this.saveLocationInPolyLine(object);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ObjectChange.popCause((ObjectChangeCause)saveLocationsCause);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        ObjectChange.popCause((ObjectChangeCause)saveLocationsCause);
        if (this.dragging) {
            this.setDragging(false);
            Container parent = comp.getParent();
            if (parent != null && parent instanceof JLayeredPane) {
                JLayeredPane pane = (JLayeredPane)parent;
                pane.setPosition(comp, 0);
                pane.revalidate();
                pane.repaint();
            }
        }
        this.lastPoint = null;
        this.lastComponent = null;
        event.consume();
    }

    public void mouseDragged(MouseEvent event) {
        JComponent source = (JComponent)event.getSource();
        Point eventPoint = event.getPoint();
        if (this.getOrientation() == 16) {
            if (!this.dragging) {
                this.setDragging(true);
            }
            if (this.lastPoint == null) {
                this.lastPoint = eventPoint;
            }
            int deltaX = (int)(eventPoint.getX() - this.lastPoint.getX());
            int deltaY = (int)(eventPoint.getY() - this.lastPoint.getY());
            boolean sourceFound = false;
            Iterator selIter = SelectionManager.get().iteratorOfSelection();
            while (selIter.hasNext()) {
                FSAObject object = (FSAObject)selIter.next();
                FSAContainer parent = object.getParent();
                if (parent != null && parent.isSelected()) continue;
                JComponent jObject = object.getJComponent();
                this.dragByDelta(jObject, deltaX, deltaY);
                if (jObject != source) continue;
                sourceFound = true;
            }
            if (!sourceFound) {
                this.dragByDelta(source, deltaX, deltaY);
            }
            event.consume();
        }
    }

    protected void dragByDelta(FSAObject fsaObject, int deltaX, int deltaY) {
        if (fsaObject == null) {
            return;
        }
        Point currentLocation = fsaObject.getJComponent().getLocation();
        Point destinationPoint = new Point(currentLocation.x + deltaX, currentLocation.y + deltaY);
        if (destinationPoint.x < 0) {
            deltaX = currentLocation.x > 0 ? -currentLocation.x : 0;
        }
        if (destinationPoint.y < 0) {
            deltaY = currentLocation.y > 0 ? -currentLocation.y : 0;
        }
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        fsaObject.dragByDelta(deltaX, deltaY);
        JComponent parent = (JComponent)fsaObject.getJComponent().getParent();
        if (parent != null) {
            parent.revalidate();
        }
    }

    protected void dragByDelta(JComponent comp, int deltaX, int deltaY) {
        Point destinationPoint = comp.getLocation();
        destinationPoint.x += deltaX;
        destinationPoint.y += deltaY;
        if (destinationPoint.x < 0) {
            destinationPoint.x = 0;
        }
        if (destinationPoint.y < 0) {
            destinationPoint.y = 0;
        }
        comp.setLocation(destinationPoint);
        JComponent parent = (JComponent)comp.getParent();
        if (parent != null) {
            parent.revalidate();
        }
    }

    protected void setDragging(boolean drag) {
        if (this.dragging != drag) {
            Vector<JLayeredPane> panes = new Vector<JLayeredPane>();
            Iterator selIter = SelectionManager.get().iteratorOfSelection();
            while (selIter.hasNext()) {
                int layer;
                Container parent;
                FSAObject selected = (FSAObject)selIter.next();
                JComponent selectedComp = selected.getJComponent();
                if (selectedComp == null || (parent = selectedComp.getParent()) == null || !(parent instanceof JLayeredPane)) continue;
                JLayeredPane pane = (JLayeredPane)parent;
                if (drag) {
                    layer = LayerManager.get().getDragLayer(selectedComp);
                    pane.setLayer(selectedComp, layer);
                } else {
                    layer = LayerManager.get().getLayer(selectedComp);
                    pane.setLayer(selectedComp, layer);
                    pane.setPosition(selectedComp, 0);
                }
                panes.addElement(pane);
            }
            Iterator paneIter = panes.iterator();
            while (paneIter.hasNext()) {
                ((JLayeredPane)paneIter.next()).repaint();
            }
            this.dragging = drag;
        }
    }

    protected void setOrientation(Component comp, MouseEvent event) {
        super.setOrientation(comp, event);
        int orientation = this.getOrientation();
        if ((orientation & 0xC) != 0 && comp.getWidth() <= 8) {
            orientation &= 0xFFFFFFF3;
        }
        if ((orientation & 3) != 0 && comp.getHeight() <= 8) {
            orientation &= 0xFFFFFFFC;
        }
        if (orientation == 0) {
            orientation = 16;
        }
        this.setOrientation(orientation);
    }

    protected void saveLocationInPolyLine(FSAObject object) {
        if (!(object instanceof FSABend)) {
            return;
        }
        FSABend fsaBend = (FSABend)object;
        JBend jBend = (JBend)fsaBend.getJComponent();
        if (jBend == null) {
            return;
        }
        Iterator connectedLines = jBend.iteratorOfLines();
        while (connectedLines.hasNext()) {
            JPolyLine jPolyLine;
            JBendLine line = (JBendLine)connectedLines.next();
            if (!(line instanceof JPolyLine.LineSegment) || (jPolyLine = ((JPolyLine.LineSegment)line).getPolyLine()) == null) continue;
            FSAPolyLine polyLine = (FSAPolyLine)FSAObject.getFSAObjectFromJComponent(jPolyLine);
            polyLine.saveAdditionalBendLocation();
        }
    }
}

