/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.SelectionEvent;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListener;
import java.awt.Color;
import javax.swing.JComponent;

public class ForegroundHighlighter
implements SelectionListener {
    public static final String OLDCOLOR_CLIENTPROPERTY;
    private static ForegroundHighlighter singleton;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OLDCOLOR_CLIENTPROPERTY = String.valueOf(clazz.getName()) + "::oldColor";
        singleton = null;
    }

    public static ForegroundHighlighter get() {
        if (singleton == null) {
            singleton = new ForegroundHighlighter();
        }
        return singleton;
    }

    private ForegroundHighlighter() {
    }

    public void selectionChanged(SelectionEvent event) {
        JComponent source = (JComponent)event.getSource();
        if (event.isSelected()) {
            Color color = event.isFocused() ? FSAObject.COLOR_FOCUSED : FSAObject.COLOR_SELECTED;
            this.setOldColor(source, source.getForeground());
            source.setForeground(color);
        } else {
            Color color = this.getOldColor(source);
            if (color != null) {
                this.setOldColor(source, null);
                source.setForeground(color);
            }
        }
        source.repaint();
    }

    private boolean setOldColor(JComponent comp, Color c) {
        Object o = comp.getClientProperty(OLDCOLOR_CLIENTPROPERTY);
        if (o == null || c == null) {
            comp.putClientProperty(OLDCOLOR_CLIENTPROPERTY, c);
            return true;
        }
        if (!(o instanceof Color)) {
            throw new RuntimeException("Conflicting Property with name " + OLDCOLOR_CLIENTPROPERTY + " found in " + comp);
        }
        return false;
    }

    private Color getOldColor(JComponent comp) {
        Object o = comp.getClientProperty(OLDCOLOR_CLIENTPROPERTY);
        if (o == null || o instanceof Color) {
            return (Color)o;
        }
        throw new RuntimeException("Conflicting Property with name " + OLDCOLOR_CLIENTPROPERTY + " found in " + comp);
    }
}

