/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.listener;

import de.uni_paderborn.fujaba.fsa.listener.SelectionEvent;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListener;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;

public class SelectionPropagationListener
implements SelectionListener {
    private static SelectionPropagationListener parentSingleton = null;
    private static SelectionPropagationListener childrenSingleton = null;
    private static SelectionPropagationListener siblingsSingleton = null;
    public static final transient int PARENT = 1;
    public static final transient int CHILDREN = 2;
    public static final transient int SIBLINGS = 3;
    private int type;
    private boolean inPropagation = false;

    public static SelectionPropagationListener get() {
        return SelectionPropagationListener.get(2);
    }

    public static SelectionPropagationListener get(int type) {
        SelectionPropagationListener result = null;
        switch (type) {
            case 1: {
                if (parentSingleton == null) {
                    parentSingleton = new SelectionPropagationListener(1);
                }
                result = parentSingleton;
                break;
            }
            case 2: {
                if (childrenSingleton == null) {
                    childrenSingleton = new SelectionPropagationListener(2);
                }
                result = childrenSingleton;
                break;
            }
            case 3: {
                if (siblingsSingleton == null) {
                    siblingsSingleton = new SelectionPropagationListener(3);
                }
                result = siblingsSingleton;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
        return result;
    }

    private SelectionPropagationListener(int type) {
        this.type = type;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void selectionChanged(SelectionEvent event) {
        if (this.inPropagation) return;
        this.inPropagation = true;
        try {
            JComponent source = (JComponent)event.getSource();
            Component[] targets = this.getTargets(source);
            int i = 0;
            while (i < targets.length) {
                if (targets[i] instanceof JComponent) {
                    JComponent tmpComp = (JComponent)targets[i];
                    SelectionListenerHelper.setSelection(tmpComp, event.getSelection());
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.inPropagation = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.inPropagation = false;
            return;
        }
    }

    private Component[] getTargets(JComponent source) {
        switch (this.type) {
            case 1: {
                return new Component[]{source.getParent()};
            }
            case 2: {
                return source.getComponents();
            }
            case 3: {
                Container parent = source.getParent();
                if (parent == null) {
                    return new Component[0];
                }
                Component[] siblingsAndSource = parent.getComponents();
                Component[] siblings = new Component[siblingsAndSource.length - 1];
                int sibPos = 0;
                int i = 0;
                while (i < siblingsAndSource.length) {
                    if (siblingsAndSource[i] != source) {
                        siblings[sibPos] = siblingsAndSource[i];
                        ++sibPos;
                    }
                    ++i;
                }
                return siblings;
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }
}

