/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabUI;
import de.uni_paderborn.fujaba.fsa.swing.JArrowHead;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.uni_paderborn.fujaba.fsa.swing.JSimpleArrowHead;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class ArrowGrabUI
extends GrabUI {
    private static final String ARROW = "de.uni_paderborn.fujaba.fsa.swing.ArrowGrabUI:Arrow";
    JBend bend;
    JArrowHead arrow;
    private PropertyChangeListener propertyChangeListener = null;

    public JBend getBend() {
        return this.bend;
    }

    public boolean setBend(JBend bend) {
        if (bend != this.bend) {
            if (this.bend != null) {
                this.bend.setUI(null);
            }
            this.bend = bend;
            if (bend != null && bend.getUI() != this) {
                bend.setUI(this);
            }
            return true;
        }
        return false;
    }

    public JArrowHead getArrow() {
        return this.arrow;
    }

    public boolean setArrow(JArrowHead arrow) {
        if (arrow != this.arrow) {
            if (this.arrow != null) {
                this.uninstallComponents();
            }
            this.arrow = arrow;
            if (arrow != null) {
                this.configureArrow();
            }
            if (this.bend != null) {
                this.bend.putClientProperty(ARROW, arrow);
                if (arrow != null) {
                    this.installComponents();
                }
                this.bend.revalidate();
                this.bend.repaint();
            }
            return true;
        }
        return false;
    }

    public static ComponentUI createUI(JComponent c) {
        return new ArrowGrabUI();
    }

    public void installUI(JComponent c) {
        this.setBend((JBend)c);
        this.bend.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.bend.setRequestFocusEnabled(true);
    }

    public void uninstallUI(JComponent c) {
        this.bend.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.propertyChangeListener = null;
        this.bend = null;
    }

    protected void installDefaults() {
        this.bend.setOpaque(true);
        this.bend.setForeground(FSAObject.COLOR_FOREGROUND);
        this.bend.setBackground(FSAObject.COLOR_BACKGROUND);
        this.bend.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (this.arrow == null) {
            this.setArrow(this.createArrow(new JSimpleArrowHead()));
            this.arrow.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.bend.putClientProperty(ARROW, this.arrow);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.bend.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallDefaults() {
        this.bend.putClientProperty(ARROW, null);
        this.setArrow(null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.bend.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new BendLayoutManager();
    }

    protected JArrowHead createArrow(JArrowHead arrowHead) {
        if (this.bend.getClientProperty(ARROW) != null && this.bend.getClientProperty(ARROW) instanceof JArrowHead) {
            return (JArrowHead)this.bend.getClientProperty(ARROW);
        }
        return (JArrowHead)arrowHead.clone();
    }

    void updateToolTipTextForChildren() {
        Component[] children = this.bend.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof JComponent) {
                ((JComponent)children[i]).setToolTipText(this.bend.getToolTipText());
            }
            ++i;
        }
    }

    protected void installComponents() {
        this.configureArrow();
        this.bend.add(this.arrow);
    }

    protected void uninstallComponents() {
        this.bend.removeAll();
    }

    protected void configureArrow() {
        this.arrow.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (this.bend != null) {
            this.arrow.setOpaque(this.bend.isOpaque());
            this.arrow.setForeground(this.bend.getForeground());
            this.arrow.setBackground(this.bend.getBackground());
            if (this.bend instanceof JGrab) {
                Direction orientation = ((JGrab)this.bend).getOrientation().reverse();
                this.arrow.setDirection(orientation);
            }
        }
    }

    public boolean isFocusTraversable(JBend c) {
        return false;
    }

    protected Point calculatePoint(JComponent c) {
        if (c != this.bend || this.arrow == null || !this.bend.isVisible()) {
            return super.calculatePoint(c);
        }
        Point result = this.bend.getLocation();
        Point arrowPoint = this.arrow.getBasePoint();
        result.x += arrowPoint.x;
        result.y += arrowPoint.y;
        return result;
    }

    public void paint(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            Color t = g.getColor();
            g.setColor(c.getBackground());
            Dimension size = c.getSize();
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(t);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Insets insets = this.getInsets();
        Dimension size = this.arrow.getPreferredSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension getMinimumSize(JComponent c) {
        Insets insets = this.getInsets();
        Dimension size = this.arrow.getMinimumSize();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension size = this.getPreferredSize(c);
        size.width = Short.MAX_VALUE;
        return size;
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.bend.getWidth();
        int height = this.bend.getHeight();
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
    }

    protected Insets getInsets() {
        return this.bend.getInsets();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("foreground")) {
                if (ArrowGrabUI.this.arrow != null) {
                    ArrowGrabUI.this.arrow.setForeground(ArrowGrabUI.this.bend.getForeground());
                }
                ArrowGrabUI.this.bend.repaint();
            } else if (propertyName.equals("background")) {
                if (ArrowGrabUI.this.arrow != null) {
                    ArrowGrabUI.this.arrow.setBackground(ArrowGrabUI.this.bend.getBackground());
                }
                ArrowGrabUI.this.bend.repaint();
            } else if (propertyName.equals("opaque")) {
                if (ArrowGrabUI.this.arrow != null) {
                    ArrowGrabUI.this.arrow.setOpaque(ArrowGrabUI.this.bend.isOpaque());
                }
                ArrowGrabUI.this.bend.repaint();
            } else if (propertyName.equals("ToolTipText")) {
                ArrowGrabUI.this.updateToolTipTextForChildren();
            } else if (propertyName.equals("orientation")) {
                if (ArrowGrabUI.this.arrow != null) {
                    Direction orientation = ((JGrab)ArrowGrabUI.this.bend).getOrientation().reverse();
                    ArrowGrabUI.this.arrow.setDirection(orientation);
                    ArrowGrabUI.this.bend.resetPoint();
                }
                ArrowGrabUI.this.bend.repaint();
            }
        }
    }

    public class BendLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            if (ArrowGrabUI.this.arrow != null) {
                Rectangle cvb = ArrowGrabUI.this.rectangleForCurrentValue();
                ArrowGrabUI.this.arrow.setBounds(cvb);
            }
        }
    }
}

