/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabLayouter;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JCircle;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class CircleGrabLayouter
extends GrabLayouter {
    private static CircleGrabLayouter layouter = null;

    private CircleGrabLayouter() {
    }

    public static GrabLayouter get() {
        if (layouter == null) {
            layouter = new CircleGrabLayouter();
        }
        return layouter;
    }

    public void layout(GrabManager manager) {
        if (!(manager.getTarget() instanceof JCircle)) {
            throw new IllegalArgumentException("A CircleGrabLayouter can only layout grabs with a JCircle as target");
        }
        Iterator grabIter = manager.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            this.layoutGrab(manager, grab);
        }
    }

    protected void layoutGrab(GrabManager manager, JGrab grab) {
        Rectangle bounds = manager.getTarget().getBounds();
        double[] info = this.getPreferredLayoutInformation(grab);
        Direction orientation = Direction.fromInt((int)info[0]);
        double align = info[1];
        align = (1.0 - 2.0 * align) * Math.PI / 4.0;
        int rad = ((JCircle)manager.getTarget()).getRadius();
        int centerX = bounds.x + rad - 1;
        int centerY = bounds.y + rad - 1;
        Point grabPoint = new Point();
        Rectangle grabBounds = grab.getBounds();
        if (orientation == Direction.TOP) {
            grabPoint.x = (int)((double)centerX - Math.sin(align) * (double)rad - (double)grabBounds.width / 2.0);
            grabPoint.y = (int)((double)centerY - Math.cos(align) * (double)rad) - grabBounds.height + 1;
        } else if (orientation == Direction.BOTTOM) {
            grabPoint.x = (int)((double)centerX - Math.sin(align) * (double)rad - (double)grabBounds.width / 2.0);
            grabPoint.y = (int)((double)centerY + Math.cos(align) * (double)rad);
        } else if (orientation == Direction.LEFT) {
            grabPoint.x = (int)((double)centerX - Math.cos(align) * (double)rad) - grabBounds.width + 1;
            grabPoint.y = (int)((double)centerY - Math.sin(align) * (double)rad - (double)grabBounds.height / 2.0);
        } else {
            grabPoint.x = (int)((double)centerX + Math.cos(align) * (double)rad);
            grabPoint.y = (int)((double)centerY - Math.sin(align) * (double)rad - (double)grabBounds.height / 2.0);
        }
        Container targetParent = manager.getTarget().getParent();
        Container grabParent = grab.getParent();
        if (targetParent != null && grabParent != null) {
            grabPoint = SwingUtilities.convertPoint(targetParent, grabPoint, grabParent);
        }
        grab.setLocation(grabPoint);
    }

    protected double[] getPreferredLayoutInformation(JGrab grab) {
        Direction orientation = grab.getOrientation();
        double align = grab.getAlignment();
        JCircle target = (JCircle)grab.getTarget();
        if (grab.sizeOfLines() == 0 || target == null) {
            if (grab.isAutoOrientation()) {
                orientation = Direction.LEFT;
                grab.setLayoutOrientation(orientation);
            }
            if (grab.isAutoAlignment()) {
                align = 0.5;
                grab.setLayoutAlignment(align);
            }
            return new double[]{orientation.asInt(), align};
        }
        Point mid = target.getLocation();
        mid.x += target.getRadius() - 1;
        mid.y += target.getRadius() - 1;
        Iterator lineIter = grab.iteratorOfLines();
        JBendLine line = (JBendLine)lineIter.next();
        JBend bend = line.getStartBend();
        if (bend == grab) {
            bend = line.getEndBend();
        }
        Point p = bend.getPoint();
        if (bend.getParent() != null && target.getParent() != null) {
            p = SwingUtilities.convertPoint(bend.getParent(), p, target.getParent());
        }
        Direction tmpOrient = Direction.LEFT;
        double tmpAlign = 0.5;
        if (!p.equals(mid)) {
            int angle = (int)(Math.acos((double)(p.x - mid.x) / Math.sqrt((p.x - mid.x) * (p.x - mid.x) + (p.y - mid.y) * (p.y - mid.y))) * 180.0 / Math.PI);
            if (p.y > mid.y) {
                angle = 360 - angle;
            }
            if (angle <= 45) {
                tmpOrient = Direction.RIGHT;
                tmpAlign = 1.0 - ((double)angle + 45.0) / 90.0;
            } else if (angle > 315) {
                tmpOrient = Direction.RIGHT;
                tmpAlign = 1.0 - (double)(angle - 360 + 45) / 90.0;
            } else if (45 < angle && angle <= 135) {
                tmpOrient = Direction.TOP;
                tmpAlign = 1.0 - (double)(angle - 45) / 90.0;
            } else if (135 < angle && angle <= 225) {
                tmpOrient = Direction.LEFT;
                tmpAlign = (double)(angle - 135) / 90.0;
            } else {
                tmpOrient = Direction.BOTTOM;
                tmpAlign = (double)(angle - 225) / 90.0;
            }
        }
        if (grab.isAutoOrientation()) {
            grab.setLayoutOrientation(tmpOrient);
            orientation = tmpOrient;
        }
        if (grab.isAutoAlignment()) {
            grab.setLayoutAlignment(tmpAlign);
            align = tmpAlign;
        }
        return new double[]{orientation.asInt(), align};
    }
}

