/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabLayouter;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import de.upb.tools.fca.FDuplicatedTreeMap;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DefaultGrabLayouter
extends GrabLayouter {
    private static final transient int MAX_PAD = 4;

    public void layout(GrabManager manager) {
        Iterator grabIter = manager.iteratorOfGrabs();
        FDuplicatedTreeMap topGrabs = new FDuplicatedTreeMap();
        int topAutoLayoutGrabs = 0;
        FDuplicatedTreeMap rightGrabs = new FDuplicatedTreeMap();
        int rightAutoLayoutGrabs = 0;
        FDuplicatedTreeMap bottomGrabs = new FDuplicatedTreeMap();
        int bottomAutoLayoutGrabs = 0;
        FDuplicatedTreeMap leftGrabs = new FDuplicatedTreeMap();
        int leftAutoLayoutGrabs = 0;
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            double[] info = this.getPreferredLayoutInformation(grab);
            Direction orientation = Direction.fromInt((int)info[0]);
            double align = info[1];
            EnumKey key = EnumKey.create(grab, orientation, align);
            if (orientation == Direction.TOP) {
                topGrabs.put(key, grab);
                if (!grab.isAutoAlignment()) continue;
                ++topAutoLayoutGrabs;
                continue;
            }
            if (orientation == Direction.RIGHT) {
                rightGrabs.put(key, grab);
                if (!grab.isAutoAlignment()) continue;
                ++rightAutoLayoutGrabs;
                continue;
            }
            if (orientation == Direction.BOTTOM) {
                bottomGrabs.put(key, grab);
                if (!grab.isAutoAlignment()) continue;
                ++bottomAutoLayoutGrabs;
                continue;
            }
            leftGrabs.put(key, grab);
            if (!grab.isAutoAlignment()) continue;
            ++leftAutoLayoutGrabs;
        }
        this.layoutAll(manager, topGrabs, topAutoLayoutGrabs, Direction.TOP);
        this.layoutAll(manager, rightGrabs, rightAutoLayoutGrabs, Direction.RIGHT);
        this.layoutAll(manager, bottomGrabs, bottomAutoLayoutGrabs, Direction.BOTTOM);
        this.layoutAll(manager, leftGrabs, leftAutoLayoutGrabs, Direction.LEFT);
    }

    private void layoutAll(GrabManager manager, Map grabs, int size, Direction orientation) {
        double end;
        double start;
        JGrab grab;
        EnumKey key;
        Map.Entry entry;
        int dim;
        Iterator grabIter = grabs.entrySet().iterator();
        double space = size > 0 ? 1.0 / (double)size : 0.0;
        double pad = space * 0.125;
        double maxPadRel = orientation == Direction.TOP || orientation == Direction.BOTTOM ? ((dim = manager.getTarget().getBounds().width) > 0 ? 4.0 / (2.0 * (double)dim) : 1.0) : (orientation == Direction.LEFT || orientation == Direction.RIGHT ? ((dim = manager.getTarget().getBounds().height) > 0 ? 4.0 / (2.0 * (double)dim) : 1.0) : 1.0);
        pad = Math.min(pad, maxPadRel);
        double layoutSpace = space - 2.0 * pad;
        double offset = 0.0;
        double[] used = new double[2];
        int count = 0;
        Map.Entry[] reverse = new Map.Entry[size];
        while (grabIter.hasNext()) {
            entry = grabIter.next();
            key = (EnumKey)entry.getKey();
            grab = (JGrab)entry.getValue();
            if (grab.isAutoAlignment()) {
                ++count;
                start = offset + pad;
                end = start + layoutSpace;
                this.layoutGrab(manager, grab, Direction.fromInt(key.orientation), key.alignment, start, end, used);
                offset = used[1];
                key.start = used[0];
                key.end = used[1];
                layoutSpace += (end - offset) / (double)(size - count);
                offset += pad;
                reverse[count - 1] = entry;
                continue;
            }
            this.layoutGrab(manager, grab, Direction.fromInt(key.orientation), key.alignment, 0.0, 1.0, used);
        }
        Map.Entry prevEntry = null;
        EnumKey prevKey = null;
        end = 1.0;
        int i = size - 1;
        while (i >= 0) {
            entry = reverse[i];
            key = (EnumKey)entry.getKey();
            grab = (JGrab)entry.getValue();
            double align = grab.getAlignment();
            if (i < size - 1 && align < key.alignment && align <= end) {
                if (i > 0 && i < size - 1) {
                    prevEntry = reverse[i - 1];
                    prevKey = (EnumKey)prevEntry.getKey();
                    start = prevKey.end + 2.0 * pad;
                } else {
                    start = key.start;
                }
                this.layoutGrab(manager, grab, Direction.fromInt(key.orientation), key.alignment, start, end, used);
                end = used[0] - 2.0 * pad;
            } else {
                end = key.start - 2.0 * pad;
            }
            --i;
        }
    }

    protected void layoutGrab(GrabManager manager, JGrab grab, Direction orientation, double align, double start, double end, double[] used) {
        Rectangle bounds = manager.getTarget().getBounds();
        Point grabPoint = new Point();
        Rectangle grabBounds = grab.getBounds();
        int grabStart = grab.getTouchOffset();
        int grabEnd = grabStart + grab.getTouchLength();
        int grabAlign = grab.getAlignmentOffset();
        int grabPad = grab.getPadOffset();
        if (start > align) {
            align = start;
        } else if (end < align) {
            align = end;
        }
        if (orientation == Direction.TOP) {
            grabPoint.x = bounds.x + (int)((double)bounds.width * align - (double)grabAlign);
            grabPoint.y = bounds.y - grabBounds.height + 1 - grabPad;
            int leftBorder = bounds.x + (int)((double)bounds.width * start);
            int rightBorder = bounds.x + (int)((double)bounds.width * end);
            int divStart = grabPoint.x + grabStart - leftBorder;
            int divEnd = rightBorder - (grabPoint.x + grabEnd);
            if (divEnd < 0 || divStart < 0) {
                if (divEnd < 0 && divStart < 0) {
                    divEnd -= divStart;
                    grabPoint.x += (divEnd /= 2);
                } else {
                    grabPoint.x = divStart < 0 ? ((divEnd += divStart) < 0 ? (grabPoint.x -= divEnd / 2) : (grabPoint.x -= divStart)) : ((divStart += divEnd) < 0 ? (grabPoint.x += divStart / 2) : (grabPoint.x += divEnd));
                }
            }
        } else if (orientation == Direction.BOTTOM) {
            grabPoint.x = bounds.x + (int)((double)bounds.width * align - (double)grabAlign);
            grabPoint.y = bounds.y + bounds.height - 1 + grabPad;
            int leftBorder = bounds.x + (int)((double)bounds.width * start);
            int rightBorder = bounds.x + (int)((double)bounds.width * end);
            int divStart = grabPoint.x + grabStart - leftBorder;
            int divEnd = rightBorder - (grabPoint.x + grabEnd);
            if (divEnd < 0 || divStart < 0) {
                if (divEnd < 0 && divStart < 0) {
                    divEnd -= divStart;
                    grabPoint.x += (divEnd /= 2);
                } else {
                    grabPoint.x = divStart < 0 ? ((divEnd += divStart) < 0 ? (grabPoint.x -= divEnd / 2) : (grabPoint.x -= divStart)) : ((divStart += divEnd) < 0 ? (grabPoint.x += divStart / 2) : (grabPoint.x += divEnd));
                }
            }
        } else if (orientation == Direction.LEFT) {
            grabPoint.x = bounds.x - grabBounds.width + 1 - grabPad;
            grabPoint.y = bounds.y + (int)((double)bounds.height * align - (double)grabAlign);
            int leftBorder = bounds.y + (int)((double)bounds.height * start);
            int rightBorder = bounds.y + (int)((double)bounds.height * end);
            int divStart = grabPoint.y + grabStart - leftBorder;
            int divEnd = rightBorder - (grabPoint.y + grabEnd);
            if (divEnd < 0 || divStart < 0) {
                if (divEnd < 0 && divStart < 0) {
                    divEnd -= divStart;
                    grabPoint.y += (divEnd /= 2);
                } else {
                    grabPoint.y = divStart < 0 ? ((divEnd += divStart) < 0 ? (grabPoint.y -= divEnd / 2) : (grabPoint.y -= divStart)) : ((divStart += divEnd) < 0 ? (grabPoint.y += divStart / 2) : (grabPoint.y += divEnd));
                }
            }
        } else {
            grabPoint.x = bounds.x + bounds.width - 1 + grabPad;
            grabPoint.y = bounds.y + (int)((double)bounds.height * align - (double)grabAlign);
            int leftBorder = bounds.y + (int)((double)bounds.height * start);
            int rightBorder = bounds.y + (int)((double)bounds.height * end);
            int divStart = grabPoint.y + grabStart - leftBorder;
            int divEnd = rightBorder - (grabPoint.y + grabEnd);
            if (divEnd < 0 || divStart < 0) {
                if (divEnd < 0 && divStart < 0) {
                    divEnd -= divStart;
                    grabPoint.y += (divEnd /= 2);
                } else {
                    grabPoint.y = divStart < 0 ? ((divEnd += divStart) < 0 ? (grabPoint.y -= divEnd / 2) : (grabPoint.y -= divStart)) : ((divStart += divEnd) < 0 ? (grabPoint.y += divStart / 2) : (grabPoint.y += divEnd));
                }
            }
        }
        Container targetParent = manager.getTarget().getParent();
        Container grabParent = grab.getParent();
        if (targetParent != null && grabParent != null) {
            grabPoint = SwingUtilities.convertPoint(targetParent, grabPoint, grabParent);
        }
        grab.setLocation(grabPoint);
        if (orientation == Direction.TOP || orientation == Direction.BOTTOM) {
            if (bounds.width != 0) {
                used[0] = Math.max(start, (double)Math.abs(grabPoint.x + grabStart - bounds.x) / (double)bounds.width);
                used[1] = Math.min(end, (double)Math.abs(grabPoint.x + grabEnd - bounds.x) / (double)bounds.width);
                grab.setLayoutAlignment((double)(grabPoint.x + grabAlign - bounds.x) / (double)bounds.width);
            } else {
                used[0] = used[1] = align * (start + end);
                grab.setLayoutAlignment(used[0]);
            }
        } else if (orientation == Direction.LEFT || orientation == Direction.RIGHT) {
            if (bounds.height != 0) {
                used[0] = Math.max(start, (double)Math.abs(grabPoint.y + grabStart - bounds.y) / (double)bounds.height);
                used[1] = Math.min(end, (double)Math.abs(grabPoint.y + grabEnd - bounds.y) / (double)bounds.height);
                grab.setLayoutAlignment((double)(grabPoint.y + grabAlign - bounds.y) / (double)bounds.height);
            } else {
                used[0] = used[1] = align * (start + end);
                grab.setLayoutAlignment(used[0]);
            }
        } else {
            used[0] = used[1] = align * (start + end);
            grab.setLayoutAlignment(used[0]);
        }
        grab.setLayoutOrientation(orientation);
    }

    private static final class EnumKey
    implements Comparable {
        public final transient double angle;
        public final transient int hashcode;
        public final transient int orientation;
        public final transient double alignment;
        public transient double start;
        public transient double end;

        EnumKey(int orientation, double alignment, double angle, int hashcode) {
            this.angle = angle;
            this.hashcode = hashcode;
            this.orientation = orientation;
            this.alignment = alignment;
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            if (o instanceof EnumKey) {
                EnumKey key = (EnumKey)o;
                if (this.orientation != key.orientation) {
                    return this.orientation < key.orientation ? -1 : 1;
                }
                if (this.alignment != key.alignment) {
                    return this.alignment < key.alignment ? -1 : 1;
                }
                if (this.angle != key.angle) {
                    return this.angle < key.angle ? -1 : 1;
                }
                if (this.hashcode != key.hashcode) {
                    return this.hashcode < key.hashcode ? -1 : 1;
                }
                return 0;
            }
            return -1;
        }

        public static EnumKey create(JGrab grab, Direction orientation, double align) {
            JBendLine line = grab.getFirstFromLines();
            double angle = 0.0;
            int hashcode = 0;
            if (line != null) {
                angle = EnumKey.getAngle(grab, line, orientation);
                hashcode = line.hashCode();
            }
            return new EnumKey(orientation.asInt(), align, angle, hashcode);
        }

        private static double getAngle(JGrab grab, JBendLine line, Direction orientation) {
            double angle = 0.0;
            JBend bend = line.getNextFromBends(grab);
            if (bend == null) {
                bend = line.getPrevFromBends(grab);
            }
            Point to = null;
            if (bend instanceof JGrab) {
                to = EnumKey.getGrabCoordinates((JGrab)bend);
            } else if (bend != null) {
                to = bend.getPoint();
            }
            if (to != null) {
                Point from = EnumKey.getGrabCoordinates(grab);
                int dx = to.x - from.x;
                int dy = to.y - from.y;
                angle = Math.atan2(dx, dy);
                if (orientation == Direction.TOP) {
                    angle = -angle;
                } else if (orientation == Direction.RIGHT) {
                    if (angle < Math.PI) {
                        angle += Math.PI * 2;
                    }
                    angle = -angle;
                }
            }
            return angle;
        }

        private static Point getGrabCoordinates(JGrab grab) {
            Point result = null;
            JComponent target = grab.getTarget();
            if (target != null) {
                Rectangle bounds = target.getBounds();
                result = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
            } else {
                result = grab.getPoint();
            }
            return result;
        }
    }
}

