/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JLine;
import de.uni_paderborn.fujaba.fsa.swing.LineUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class DefaultLineUI
extends LineUI {
    private static DefaultLineUI ui = null;

    public static ComponentUI createUI(JComponent c) {
        if (ui == null) {
            ui = new DefaultLineUI();
        }
        return ui;
    }

    protected DefaultLineUI() {
    }

    public Rectangle getPreferredLineBounds(JLine line) {
        Point startPoint = line.getStartPoint();
        Point endPoint = line.getEndPoint();
        double delta = line.getDelta();
        if (startPoint == null) {
            startPoint = line.getLocation();
        }
        if (endPoint == null) {
            endPoint = line.getLocation();
        }
        return new Rectangle((int)Math.min((double)startPoint.x - delta, (double)endPoint.x - delta), (int)Math.min((double)startPoint.y - delta, (double)endPoint.y - delta), (int)((double)Math.abs(startPoint.x - endPoint.x) + 2.0 * delta), (int)((double)Math.abs(startPoint.y - endPoint.y) + 2.0 * delta));
    }

    public void paintLine(Graphics g, JLine line) {
        Color oldColor = g.getColor();
        Point start = line.getStartPoint();
        Point end = line.getEndPoint();
        Point loc = line.getLocation();
        g.setColor(line.getForeground());
        g.drawLine(start.x - loc.x, start.y - loc.y, end.x - loc.x, end.y - loc.y);
        g.setColor(oldColor);
    }
}

