/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.DefaultLineUI;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class DoubleLineUI
extends DefaultLineUI {
    private static DoubleLineUI ui = null;
    private static final double DISTANCE = 2.6;

    public static ComponentUI createUI(JComponent c) {
        if (ui == null) {
            ui = new DoubleLineUI();
        }
        return ui;
    }

    protected DoubleLineUI() {
    }

    public boolean contains(JComponent c, int x, int y) {
        JLine line = (JLine)c;
        return line.getDistance(x + line.getX(), y + line.getY()) < line.getDelta() + 1.3 + 0.5;
    }

    public void paintLine(Graphics g, JLine line) {
        Color oldColor = g.getColor();
        Point start = line.getStartPoint();
        Point end = line.getEndPoint();
        Point loc = line.getLocation();
        Point2D normal = line.getNormal();
        Point2D.Double distance = new Point2D.Double(normal.getX() * 2.6 / 2.0, normal.getY() * 2.6 / 2.0);
        g.setColor(line.getForeground());
        g.drawLine((int)((double)(start.x - loc.x) + distance.x + 0.5), (int)((double)(start.y - loc.y) + distance.y + 0.5), (int)((double)(end.x - loc.x) + distance.x + 0.5), (int)((double)(end.y - loc.y) + distance.y + 0.5));
        g.drawLine((int)((double)(start.x - loc.x) - distance.x + 0.5), (int)((double)(start.y - loc.y) - distance.y + 0.5), (int)((double)(end.x - loc.x) - distance.x + 0.5), (int)((double)(end.y - loc.y) - distance.y + 0.5));
        g.setColor(oldColor);
    }

    public Rectangle getPreferredLineBounds(JLine line) {
        Point start = line.getStartPoint();
        Point end = line.getEndPoint();
        Point2D normal = line.getNormal();
        Point2D.Double distance = new Point2D.Double(normal.getX() * 2.6 / 2.0, normal.getY() * 2.6 / 2.0);
        double delta = line.getDelta();
        return new Rectangle((int)((double)Math.min(start.x, end.x) + distance.x + 0.5 - delta), (int)((double)Math.min(start.y, end.y) + distance.y + 0.5 - delta), (int)((double)Math.abs(end.x - start.x) + 2.0 * distance.x + 1.0 + 2.0 * delta), (int)((double)Math.abs(end.y - start.y) + 2.0 * distance.y + 1.0 + 2.0 * delta));
    }
}

