/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.listener.EditableComponentListener;
import de.uni_paderborn.fujaba.fsa.swing.EditorManager;
import de.uni_paderborn.fujaba.fsa.swing.OneElementLayouter;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class EditableComponent
extends JPanel {
    private JComponent component = null;
    private boolean editing;
    private static EditableComponent lastEditedInstance = null;
    private Object value;

    public EditableComponent() {
        this.setLayout(OneElementLayouter.get());
        this.setBorder(BorderFactory.createEmptyBorder());
        AscendDescendMouseHandler.addMouseListener(this, EditableComponentListener.get());
    }

    protected JComponent getComponent() {
        return this.component;
    }

    protected void setComponent(JComponent component) {
        if (this.component != component) {
            this.component = component;
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        if (this.editing != editing) {
            this.editing = editing;
        }
    }

    public static EditableComponent getLastEditedInstance() {
        return lastEditedInstance;
    }

    public static void setLastEditedInstance(EditableComponent lastEdited) {
        if (lastEditedInstance != lastEdited) {
            lastEditedInstance = lastEdited;
        }
    }

    public void setEditMode() {
        if (!this.isEditing()) {
            if (EditableComponent.getLastEditedInstance() != null) {
                EditableComponent.getLastEditedInstance().setDisplayMode();
            }
            JComponent component = EditorManager.get().getEditor(this.getClass().getName(), this.getEditorClassName());
            this.enableEditor(component);
            this.setEditing(true);
            EditableComponent.setLastEditedInstance(this);
            this.revalidate();
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        Dimension textDim = this.getComponent().getPreferredSize();
        if (this.isEditing()) {
            JComponent component = EditorManager.get().getEditor(this.getClass().getName(), this.getEditorClassName());
            Dimension dim = component.getPreferredSize();
            dim.height = textDim.height;
            return dim;
        }
        return textDim;
    }

    public void setDisplayMode() {
        if (this.isEditing()) {
            JComponent component = EditorManager.get().getEditor(this.getClass().getName(), this.getEditorClassName());
            this.disableEditor(component);
            this.setEditing(false);
            this.revalidate();
            this.repaint();
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String getText() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }

    public void setValue(Object value) {
        if (this.value == null && value != null || this.value != null && !this.value.equals(value)) {
            Object oldValue = this.value;
            this.value = value;
            this.updateJLabel();
            if (this == EditableComponent.getLastEditedInstance()) {
                JComponent component = EditorManager.get().getEditor(this.getClass().getName(), this.getEditorClassName());
                this.updateEditor(component);
            }
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    protected void enableEditor(JComponent component) {
        this.remove(this.getComponent());
        this.add(component);
    }

    protected void disableEditor(JComponent component) {
        this.remove(component);
        this.add(this.getComponent());
    }

    protected abstract void updateEditor(JComponent var1);

    protected abstract String getEditorClassName();

    protected abstract void updateJLabel();
}

