/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.swing.LayerManager;
import de.upb.tools.fca.FTreeMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class EditorManager {
    private static final int LAYER = JLayeredPane.DRAG_LAYER + 1000;
    private static final String LAYER_NAME = "EditorComponentLayer";
    private static EditorManager manager;
    private FTreeMap editors = null;

    static {
        LayerManager.get().addToLayerPositions(LAYER_NAME, new Integer(LAYER));
        manager = null;
    }

    private EditorManager() {
    }

    public static EditorManager get() {
        if (manager == null) {
            manager = new EditorManager();
        }
        return manager;
    }

    public JComponent getEditor(String key, String className) {
        JComponent object = null;
        if (this.editors == null) {
            this.editors = new FTreeMap();
        }
        if (key != null && !this.editors.containsKey(key)) {
            try {
                object = (JComponent)Class.forName(className).newInstance();
                this.editors.put(key, object);
                AscendDescendMouseHandler.registerADMouseInputHandler(object);
                AscendDescendMouseHandler.addMouseInputListener(object, AscendDescendMouseHandler.getDescendConsumer());
                LayerManager.setLayerType(object, LAYER_NAME);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to load Editor class " + className + ", " + e.getClass().getName() + ": \"" + e.getMessage() + "\"");
            }
        } else {
            object = (JComponent)this.editors.get(key);
        }
        return object;
    }
}

