/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.DecoratorLayout;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class GrabConstraints
implements DecoratorLayout.Constraints {
    private Component target = null;

    public GrabConstraints(JGrab target) {
        this.setTarget(target);
    }

    public Component getTarget() {
        return this.target;
    }

    public Component setTarget(Component target) {
        if (this.target != target) {
            if (!(target instanceof JGrab)) {
                throw new IllegalArgumentException("Target must be a JGrab");
            }
            this.target = target;
        }
        return this.target;
    }

    public Point getLocation(Component comp) {
        JGrab grab = (JGrab)this.getTarget();
        if (grab == null) {
            return comp.getLocation();
        }
        Point pos = grab.getLocation();
        pos = SwingUtilities.convertPoint(grab.getParent(), pos, comp.getParent());
        Dimension grabDim = grab.getSize();
        Dimension compDim = comp.getPreferredSize();
        if (grab.getOrientation() == Direction.TOP || grab.getOrientation() == Direction.BOTTOM) {
            pos.y = pos.y + (grab.getOrientation() == Direction.TOP ? 1 : -1) * (grabDim.height - compDim.height);
            pos.x += (grabDim.width - compDim.width) / 2;
        } else {
            pos.x = pos.x + (grab.getOrientation() == Direction.LEFT ? 1 : -1) * (grabDim.width - compDim.width);
            pos.y += (grabDim.height - compDim.height) / 2;
        }
        return pos;
    }

    public void removeYou() {
        this.setTarget(null);
    }
}

