/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class GrabLayouter {
    public static final String TARGET_PROPERTY = "GrabLayouter";
    private static Class defaultLayouterClass;
    private static GrabLayouter layouter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.DefaultGrabLayouter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        defaultLayouterClass = clazz;
        layouter = null;
    }

    public static GrabLayouter getDefaultLayouter() {
        if (layouter == null && defaultLayouterClass != null) {
            try {
                layouter = (GrabLayouter)defaultLayouterClass.newInstance();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
                throw new RuntimeException("Exception in instantiation: " + iae.getMessage());
            }
            catch (InstantiationException iex) {
                iex.printStackTrace();
                throw new RuntimeException("Exception in instantiation: " + iex.getMessage());
            }
            catch (ExceptionInInitializerError ei) {
                ei.printStackTrace();
                Throwable ex = ei.getException();
                ex.printStackTrace();
                throw new RuntimeException("Exception in instantiation: " + ex.getMessage());
            }
        }
        return layouter;
    }

    public static void setDefaultLayouterClass(Class layouterClass) {
        if (defaultLayouterClass != layouterClass) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.GrabLayouter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(layouterClass)) {
                defaultLayouterClass = layouterClass;
                layouter = null;
            } else {
                StringBuffer stringBuffer = new StringBuffer().append(layouterClass).append(" is not a subclass of ");
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.GrabLayouter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new IllegalArgumentException(stringBuffer.append(clazz2).toString());
            }
        }
    }

    public static Class getDefaultLayouterClass() {
        return defaultLayouterClass;
    }

    public static GrabLayouter getLayouter(JComponent comp) {
        if (comp == null) {
            return null;
        }
        GrabLayouter result = (GrabLayouter)comp.getClientProperty(TARGET_PROPERTY);
        if (result == null) {
            result = GrabLayouter.getDefaultLayouter();
        }
        return result;
    }

    public void registerLayouterWithJComponent(JComponent comp) {
        if (comp == null) {
            return;
        }
        comp.putClientProperty(TARGET_PROPERTY, this);
    }

    public static void unregisterLayouterFromJComponent(JComponent comp) {
        if (comp == null) {
            return;
        }
        comp.putClientProperty(TARGET_PROPERTY, null);
    }

    public abstract void layout(GrabManager var1);

    protected double[] getPreferredLayoutInformation(JGrab grab) {
        Direction orientation = grab.getOrientation();
        double align = grab.getAlignment();
        JComponent target = grab.getTarget();
        if (grab.sizeOfLines() == 0 || target == null) {
            if (grab.isAutoOrientation()) {
                orientation = Direction.LEFT;
                grab.setLayoutOrientation(orientation);
            }
            if (grab.isAutoAlignment()) {
                align = 0.5;
                grab.setLayoutAlignment(align);
            }
            return new double[]{orientation.asInt(), align};
        }
        Rectangle bounds = target.getBounds();
        Iterator lineIter = grab.iteratorOfLines();
        JBendLine line = (JBendLine)lineIter.next();
        JBend bend = line.getNextFromBends(grab);
        if (bend == null) {
            bend = line.getPrevFromBends(grab);
        }
        if (bend != null) {
            Point p = bend.getPoint();
            Container targetParent = target.getParent();
            if (targetParent != null && bend.getParent() != null) {
                p = SwingUtilities.convertPoint(bend.getParent(), p, targetParent);
            }
            Direction tmpOrient = Direction.LEFT;
            double tmpAlign = 0.5;
            if (bounds.contains(p)) {
                int dist = p.x - bounds.x;
                tmpOrient = Direction.LEFT;
                if (bounds.x + bounds.width - p.x - 1 < dist) {
                    dist = bounds.x + bounds.width - p.x - 1;
                    tmpOrient = Direction.RIGHT;
                }
                if (p.y - bounds.y < dist) {
                    dist = p.y - bounds.y;
                    tmpOrient = Direction.TOP;
                }
                if (bounds.y + bounds.height - p.y - 1 < dist) {
                    tmpOrient = Direction.BOTTOM;
                }
                tmpAlign = tmpOrient == Direction.TOP || tmpOrient == Direction.BOTTOM ? (double)(p.x - bounds.x) / (double)bounds.width : (double)(p.y - bounds.y) / (double)bounds.height;
            } else if (p.x <= bounds.x) {
                if (p.y < bounds.y) {
                    tmpAlign = 0.0;
                    tmpOrient = bounds.x - p.x < bounds.y - p.y ? Direction.TOP : Direction.LEFT;
                } else if (p.y >= bounds.y + bounds.height) {
                    if (bounds.x - p.x < p.y - bounds.y - bounds.height) {
                        tmpOrient = Direction.BOTTOM;
                        tmpAlign = 0.0;
                    } else {
                        tmpOrient = Direction.LEFT;
                        tmpAlign = 1.0;
                    }
                } else {
                    tmpOrient = Direction.LEFT;
                    tmpAlign = (double)(p.y - bounds.y) / (double)bounds.height;
                }
            } else if (p.x >= bounds.x + bounds.width) {
                if (p.y < bounds.y) {
                    if (p.x - bounds.x - bounds.width < bounds.y - p.y) {
                        tmpOrient = Direction.TOP;
                        tmpAlign = 1.0;
                    } else {
                        tmpOrient = Direction.RIGHT;
                        tmpAlign = 0.0;
                    }
                } else if (p.y >= bounds.y + bounds.height) {
                    tmpAlign = 1.0;
                    tmpOrient = p.x - bounds.x - bounds.width < p.y - bounds.y - bounds.height ? Direction.BOTTOM : Direction.RIGHT;
                } else {
                    tmpOrient = Direction.RIGHT;
                    tmpAlign = (double)(p.y - bounds.y) / (double)bounds.height;
                }
            } else {
                tmpAlign = (double)(p.x - bounds.x) / (double)bounds.width;
                tmpOrient = p.y <= bounds.y ? Direction.TOP : Direction.BOTTOM;
            }
            if (grab.isAutoOrientation()) {
                orientation = tmpOrient;
                grab.setLayoutOrientation(orientation);
            }
            if (grab.isAutoAlignment()) {
                align = tmpAlign;
                grab.setLayoutAlignment(align);
            }
        }
        return new double[]{orientation.asInt(), align};
    }
}

