/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;

public class JArrowedBendLine
extends JBendLine {
    public static final int NONE = 0;
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    public static final int FILLED = 3;
    private double endArrowLength = 14.0;
    private double endArrowWidth = 5.0;
    private Point endArrowLeftPoint;
    private Point endArrowRightPoint;
    private int endArrowStyle = 1;

    public JArrowedBendLine() {
        super(new Point(0, 0), new Point(0, 0));
    }

    public JArrowedBendLine(Point start, Point end) {
        super(new JBend(start), new JBend(end));
    }

    public JArrowedBendLine(JBend start, JBend end) {
        super(start, end);
    }

    public void setEndArrowLength(int length) {
        this.endArrowLength = length;
    }

    public void setEndArrowWidth(int width) {
        this.endArrowWidth = width;
    }

    public void setEndArrowStyle(int style) {
        this.endArrowStyle = style;
    }

    public Rectangle getPreferredBounds() {
        Rectangle lineBounds = super.getPreferredBounds();
        this.computeArrows();
        int leftmostX = Math.min(Math.min(Math.min(lineBounds.x, lineBounds.x + lineBounds.width), this.endArrowLeftPoint.x), this.endArrowRightPoint.x);
        int rightmostX = Math.max(Math.max(Math.max(lineBounds.x, lineBounds.x + lineBounds.width), this.endArrowLeftPoint.x), this.endArrowRightPoint.x);
        int topmostY = Math.min(Math.min(Math.min(lineBounds.y, lineBounds.y + lineBounds.height), this.endArrowLeftPoint.y), this.endArrowRightPoint.y);
        int bottommostY = Math.max(Math.max(Math.max(lineBounds.y, lineBounds.y + lineBounds.height), this.endArrowLeftPoint.y), this.endArrowRightPoint.y);
        return new Rectangle(leftmostX, topmostY, rightmostX - leftmostX + 1, bottommostY - topmostY + 1);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.computeArrows();
        Point end = this.getEndPoint();
        Point loc = this.getLocation();
        int xl = (int)((double)this.endArrowLeftPoint.x - loc.getX());
        int yl = (int)((double)this.endArrowLeftPoint.y - loc.getY());
        int xr = (int)((double)this.endArrowRightPoint.x - loc.getX());
        int yr = (int)((double)this.endArrowRightPoint.y - loc.getY());
        int xe = (int)(end.getX() - loc.getX());
        int ye = (int)(end.getY() - loc.getY());
        int[] xs = new int[]{xl, xe, xr};
        int[] ys = new int[]{yl, ye, yr};
        GeneralPath head = new GeneralPath(0);
        head.moveTo(xl, yl);
        head.lineTo(xe, ye);
        head.lineTo(xr, yr);
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        switch (this.endArrowStyle) {
            case 0: {
                break;
            }
            case 1: {
                g.drawPolyline(xs, ys, 3);
                break;
            }
            case 2: {
                Color saveArrowColor = g.getColor();
                g.setColor(this.getBackground());
                g.fillPolygon(xs, ys, 3);
                g.setColor(saveArrowColor);
                g.drawPolygon(xs, ys, 3);
                break;
            }
            case 3: {
                g.fillPolygon(xs, ys, 3);
                break;
            }
        }
        g.setColor(oldColor);
    }

    private void computeArrows() {
        Point start = this.getStartPoint();
        Point end = this.getEndPoint();
        double slope = (start.getY() - end.getY()) / (end.getX() - start.getX());
        double alpha = Math.atan(slope);
        double beta = 1.5707963267948966 - alpha;
        double gamma = Math.atan(this.endArrowWidth / this.endArrowLength);
        double delta = beta - gamma;
        double deltaRight = beta + gamma;
        double arrowSideLength = Math.sqrt(this.endArrowWidth * this.endArrowWidth + this.endArrowLength * this.endArrowLength);
        double slopeCorrect = 1.0;
        if (end.getX() - start.getX() < 0.0) {
            slopeCorrect = -1.0;
        }
        this.endArrowLeftPoint = new Point((int)(end.getX() - slopeCorrect * Math.sin(delta) * arrowSideLength), (int)(end.getY() + slopeCorrect * Math.cos(delta) * arrowSideLength));
        this.endArrowRightPoint = new Point((int)(end.getX() - slopeCorrect * Math.sin(deltaRight) * arrowSideLength), (int)(end.getY() + slopeCorrect * Math.cos(deltaRight) * arrowSideLength));
    }
}

