/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.BendUI;
import de.uni_paderborn.fujaba.fsa.swing.DefaultBendUI;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.plaf.PanelUI;

public class JBend
extends JPanel {
    private Set outgoingLines;
    private Set incomingLines;
    private Point point = null;

    public JBend() {
        this(new Point(0, 0));
    }

    public JBend(Point pos) {
        this(pos, null, null);
    }

    public JBend(Point pos, JBendLine incoming, JBendLine outgoing) {
        BendUI theUI = (BendUI)DefaultBendUI.createUI(this);
        this.setUI(theUI);
        this.setSize(this.getPreferredSize());
        this.setPoint(pos);
        this.addToIncomingLines(incoming);
        this.addToOutgoingLines(outgoing);
    }

    public boolean addToOutgoingLines(JBendLine value) {
        boolean changed = false;
        if (value != null) {
            if (this.outgoingLines == null) {
                this.outgoingLines = new FHashSet();
            }
            if (changed = this.outgoingLines.add(value)) {
                value.setStartBend(this);
            }
        }
        return changed;
    }

    public boolean hasInOutgoingLines(JLine value) {
        return this.outgoingLines != null && value != null && this.outgoingLines.contains(value);
    }

    public Iterator iteratorOfOutgoingLines() {
        return this.outgoingLines == null ? FEmptyIterator.get() : this.outgoingLines.iterator();
    }

    public int sizeOfOutgoingLines() {
        return this.outgoingLines == null ? 0 : this.outgoingLines.size();
    }

    public boolean removeFromOutgoingLines(JBendLine value) {
        boolean changed = false;
        if (this.outgoingLines != null && value != null && (changed = this.outgoingLines.remove(value))) {
            value.setStartBend(null);
        }
        return changed;
    }

    public void removeAllFromOutgoingLines() {
        Iterator iter = this.iteratorOfOutgoingLines();
        while (iter.hasNext()) {
            JBendLine tmpValue = (JBendLine)iter.next();
            this.removeFromOutgoingLines(tmpValue);
        }
    }

    public boolean addToIncomingLines(JBendLine value) {
        boolean changed = false;
        if (value != null) {
            if (this.incomingLines == null) {
                this.incomingLines = new FHashSet();
            }
            if (changed = this.incomingLines.add(value)) {
                value.setEndBend(this);
            }
        }
        return changed;
    }

    public boolean hasInIncomingLines(JLine value) {
        return this.incomingLines != null && value != null && this.incomingLines.contains(value);
    }

    public Iterator iteratorOfIncomingLines() {
        return this.incomingLines == null ? FEmptyIterator.get() : this.incomingLines.iterator();
    }

    public int sizeOfIncomingLines() {
        return this.incomingLines == null ? 0 : this.incomingLines.size();
    }

    public boolean removeFromIncomingLines(JBendLine value) {
        boolean changed = false;
        if (this.incomingLines != null && value != null && (changed = this.incomingLines.remove(value))) {
            value.setEndBend(null);
        }
        return changed;
    }

    public void removeAllFromIncomingLines() {
        Iterator iter = this.iteratorOfIncomingLines();
        while (iter.hasNext()) {
            JBendLine tmpValue = (JBendLine)iter.next();
            this.removeFromIncomingLines(tmpValue);
        }
    }

    public boolean hasInLines(JLine value) {
        return this.hasInIncomingLines(value) || this.hasInOutgoingLines(value);
    }

    public JBendLine getFirstFromLines() {
        Iterator iter = this.iteratorOfLines();
        if (iter.hasNext()) {
            return (JBendLine)iter.next();
        }
        return null;
    }

    public Iterator iteratorOfLines() {
        return new Iterator(){
            private Iterator iter;
            private boolean outgoing;
            {
                this.iter = JBend.this.iteratorOfIncomingLines();
                this.outgoing = false;
            }

            public boolean hasNext() {
                if (!this.iter.hasNext() && !this.outgoing) {
                    this.outgoing = true;
                    this.iter = JBend.this.iteratorOfOutgoingLines();
                }
                return this.iter.hasNext();
            }

            public Object next() throws NoSuchElementException {
                if (this.hasNext()) {
                    return this.iter.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                this.iter.remove();
            }
        };
    }

    public int sizeOfLines() {
        return this.sizeOfIncomingLines() + this.sizeOfOutgoingLines();
    }

    public boolean removeFromLines(JBendLine value) {
        return this.removeFromIncomingLines(value) | this.removeFromOutgoingLines(value);
    }

    public void removeAllFromLines() {
        this.removeAllFromIncomingLines();
        this.removeAllFromOutgoingLines();
    }

    public Point getPoint(Point p) {
        if (this.point == null) {
            this.resetPoint();
        }
        if (p == null) {
            return new Point(this.point);
        }
        p.x = this.point.x;
        p.y = this.point.y;
        return p;
    }

    public final Point getPoint() {
        return this.getPoint(null);
    }

    public final void setPoint(Point p) {
        this.setPoint(p.x, p.y);
    }

    public void setPoint(int x, int y) {
        Point oldPoint = this.getPoint();
        int dx = x - oldPoint.x;
        int dy = y - oldPoint.y;
        if (dx != 0 || dy != 0) {
            this.setLocation(oldPoint.x + dx, oldPoint.y + dy);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.resetPoint();
    }

    protected void resetPoint() {
        Point oldPoint;
        Point newPoint = this.calculatePoint();
        if (!newPoint.equals(oldPoint = this.point)) {
            this.point = newPoint;
            this.firePropertyChange("point", oldPoint, newPoint);
        }
    }

    protected Point calculatePoint() {
        if (this.ui != null && this.ui instanceof BendUI) {
            return ((BendUI)this.ui).calculatePoint(this);
        }
        Rectangle bounds = this.getBounds();
        return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
    }

    public void setUI(BendUI ui) {
        Point oldPoint = this.getPoint();
        super.setUI(ui);
        if (ui != null) {
            Point newPoint = this.calculatePoint();
            if (newPoint.x != oldPoint.x || newPoint.y != oldPoint.y) {
                Point pos = this.getLocation();
                pos.x += newPoint.x - oldPoint.x;
                pos.y += newPoint.y - oldPoint.y;
                this.setLocation(pos);
            }
        }
    }

    public PanelUI getUI() {
        return (PanelUI)this.ui;
    }

    public Dimension getMaximumSize() {
        Dimension size = null;
        if (this.ui != null) {
            size = this.ui.getMaximumSize(this);
        }
        return size != null ? size : super.getMaximumSize();
    }

    public Dimension getMinimumSize() {
        Dimension size = null;
        if (this.ui != null) {
            size = this.ui.getMinimumSize(this);
        }
        return size != null ? size : super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        Dimension size = null;
        if (this.ui != null) {
            size = this.ui.getPreferredSize(this);
        }
        return size != null ? size : super.getPreferredSize();
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        super.firePropertyChange(name, oldValue, newValue);
    }
}

