/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabLayouter;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JBendLine;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Container;
import java.awt.Point;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class JBendLineGrabLayouter
extends GrabLayouter {
    private static JBendLineGrabLayouter layouter = null;

    private JBendLineGrabLayouter() {
    }

    public static GrabLayouter get() {
        if (layouter == null) {
            layouter = new JBendLineGrabLayouter();
        }
        return layouter;
    }

    public void layout(GrabManager manager) {
        if (!(manager.getTarget() instanceof JBendLine)) {
            throw new IllegalArgumentException("A JBendLineMidGrabLayouter can only layout grabs with a JBendLine as target");
        }
        Iterator grabIter = manager.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            this.layoutGrab(manager, grab);
        }
    }

    protected void layoutGrab(GrabManager manager, JGrab grab) {
        Point grabPoint;
        if (manager.getTarget() instanceof JBendLine) {
            JBendLine bendLine = (JBendLine)manager.getTarget();
            double[] info = this.getPreferredLayoutInformation(grab);
            Direction orientation = Direction.fromInt((int)info[0]);
            grabPoint = new Point();
            if (orientation != Direction.UNDEFINED) {
                grabPoint.x = (int)bendLine.getPointAt(0.75).getX();
                grabPoint.y = (int)bendLine.getPointAt(0.75).getY();
            }
            Container targetParent = manager.getTarget().getParent();
            Container grabParent = grab.getParent();
            if (targetParent != null && grabParent != null) {
                grabPoint = SwingUtilities.convertPoint(targetParent, grabPoint, grabParent);
            }
        } else {
            throw new IllegalArgumentException("A JBendLineMidGrabLayouter can only layout grabs with a JBendLine as target");
        }
        grab.setLocation(grabPoint);
    }
}

