/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JCircle
extends JComponent {
    private int radius = 0;
    private int radiusInset = 0;
    private boolean filled = false;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadiusInset() {
        return this.radiusInset;
    }

    public void setRadiusInset(int value) {
        if (this.radiusInset != value) {
            this.radiusInset = value;
        }
    }

    public void setFilled(boolean filled) {
        if (this.filled != filled) {
            boolean oldfilled = this.filled;
            this.filled = filled;
            this.firePropertyChange("filled", oldfilled, filled);
        }
    }

    public boolean getFilled() {
        return this.filled;
    }

    public JCircle() {
        this.setOpaque(false);
    }

    public JCircle(int radius) {
        this.radius = radius;
    }

    public Dimension getPreferredSize() {
        return new Dimension((this.radius + this.radiusInset) * 2 + 1, (this.radius + this.radiusInset) * 2 + 1);
    }

    protected void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        if (this.radiusInset > 0) {
            g.drawOval(0, 0, (this.radius + this.radiusInset) * 2, (this.radius + this.radiusInset) * 2);
        }
        if (this.filled) {
            g.fillOval(this.radiusInset, this.radiusInset, this.radius * 2, this.radius * 2);
        } else {
            g.drawOval(this.radiusInset, this.radiusInset, this.radius * 2, this.radius * 2);
        }
        g.setColor(oldColor);
    }

    public void reshape(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (x != bounds.x || y != bounds.y || width != bounds.width || height != bounds.height) {
            super.reshape(x, y, width, height);
            if (x != bounds.x || y != bounds.y) {
                this.firePropertyChange("location", bounds.getLocation(), new Point(x, y));
            }
            if (width != bounds.width || height != bounds.height) {
                this.firePropertyChange("size", bounds.getSize(), new Dimension(width, height));
            }
            this.firePropertyChange("bounds", bounds, new Rectangle(x, y, width, height));
        }
    }
}

