/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class JDiagramRootPane
extends JComponent {
    JComponent contentPane;
    JComponent glassPane;

    public JDiagramRootPane() {
        JComponent gp = this.createGlassPane();
        this.setGlassPane(gp);
        this.setContentPane(this.createContentPane());
        this.setLayout(this.createLayout());
        this.setDoubleBuffered(true);
    }

    protected JComponent createContentPane() {
        JLayeredPane p = new JLayeredPane();
        p.setName(String.valueOf(this.getName()) + ".contentPane");
        return p;
    }

    protected JComponent createGlassPane() {
        JComponent c = new JComponent(){

            public void paintComponent(Graphics g) {
            }
        };
        c.setName(String.valueOf(this.getName()) + ".glassPane");
        c.setVisible(false);
        c.setOpaque(false);
        return c;
    }

    protected LayoutManager createLayout() {
        return new DefaultLayout();
    }

    public void setContentPane(JComponent layered) {
        if (layered == null) {
            throw new IllegalComponentStateException("contentPane cannot be set to null.");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this) {
            this.remove(this.contentPane);
        }
        this.contentPane = layered;
        this.add((Component)this.contentPane, -1);
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public void setGlassPane(JComponent glass) {
        if (glass == null) {
            throw new IllegalComponentStateException("glassPane cannot be set to null.");
        }
        boolean visible = false;
        if (this.glassPane != null && this.glassPane.getParent() == this) {
            this.remove(this.glassPane);
            visible = this.glassPane.isVisible();
        }
        this.glassPane = glass;
        this.add((Component)this.glassPane, 0);
        if (visible || glass.isVisible()) {
            this.repaint();
        }
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public boolean isOptimizedDrawingEnabled() {
        return !this.glassPane.isVisible();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this.glassPane != null && this.glassPane.getParent() == this && this.getComponent(0) != this.glassPane) {
            this.add((Component)this.glassPane, 0);
        }
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    protected class DefaultLayout
    implements LayoutManager2 {
        protected DefaultLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = JDiagramRootPane.this.getInsets();
            Dimension rd = parent.getSize();
            if (JDiagramRootPane.this.contentPane != null) {
                Dimension tmpDim = null;
                try {
                    tmpDim = JDiagramRootPane.this.contentPane.getPreferredSize();
                }
                catch (Exception e) {
                    tmpDim = new Dimension(200, 400);
                }
                tmpDim.width += insets.left + insets.right;
                tmpDim.height += insets.top + insets.bottom;
                rd.width = Math.max(rd.width, tmpDim.width);
                rd.height = Math.max(rd.height, tmpDim.height);
            }
            return rd;
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = JDiagramRootPane.this.getInsets();
            Dimension rd = parent.getSize();
            if (JDiagramRootPane.this.contentPane != null) {
                Dimension tmpDim = JDiagramRootPane.this.contentPane.getMinimumSize();
                tmpDim.width += insets.left + insets.right;
                tmpDim.height += insets.top + insets.bottom;
                rd.width = Math.max(rd.width, tmpDim.width);
                rd.height = Math.max(rd.height, tmpDim.height);
            }
            return rd;
        }

        public Dimension maximumLayoutSize(Container parent) {
            Dimension rd;
            Insets insets = JDiagramRootPane.this.getInsets();
            if (JDiagramRootPane.this.contentPane != null) {
                rd = JDiagramRootPane.this.contentPane.getMaximumSize();
                if (rd.width <= Integer.MAX_VALUE - (insets.left + insets.right)) {
                    rd.width += insets.left + insets.right;
                }
                if (rd.height <= Integer.MAX_VALUE - (insets.top + insets.bottom)) {
                    rd.height += insets.top + insets.bottom;
                }
            } else {
                rd = parent.getSize();
            }
            return rd;
        }

        public void layoutContainer(Container parent) {
            Rectangle b = parent.getBounds();
            Insets i = JDiagramRootPane.this.getInsets();
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (JDiagramRootPane.this.contentPane != null) {
                JDiagramRootPane.this.contentPane.setBounds(i.left, i.top, w, h);
            }
            if (JDiagramRootPane.this.glassPane != null) {
                JDiagramRootPane.this.glassPane.setBounds(i.left, i.top, w, h);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

