/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JArrowHead;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Iterator;

public class JDiamondHead
extends JArrowHead {
    private static final int DEFAULT_WIDTH = 11;
    private static final int DEFAULT_HEIGHT = 17;

    public JDiamondHead() {
        this(17);
    }

    public JDiamondHead(boolean filled) {
        this(17, filled);
    }

    public JDiamondHead(int size) {
        this(size * 11 / 17, size, false);
    }

    public JDiamondHead(int size, boolean filled) {
        this(size * 11 / 17, size, filled);
    }

    public JDiamondHead(int width, int height, boolean filled) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(height, height));
        this.setFilled(filled);
        int[] nArray = new int[4];
        nArray[0] = (height - 1) / 2;
        nArray[2] = (height - 1) / 2;
        nArray[3] = height - 1;
        this.getShapeList().add(new Polygon(new int[]{(height - width) / 2, (height - 1) / 2, (height + width - 2) / 2, (height - 1) / 2}, nArray, 4));
    }

    public void paintArrow(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        Iterator iter = this.getShapeList().iterator();
        while (iter.hasNext()) {
            Polygon shape = (Polygon)iter.next();
            Graphics2D g2d = (Graphics2D)g;
            if (this.getFilled()) {
                g2d.fill(this.at.createTransformedShape(shape));
                continue;
            }
            g.setColor(this.getBackground());
            g2d.fill(this.at.createTransformedShape(shape));
            g.setColor(this.getForeground());
            g2d.draw(this.at.createTransformedShape(shape));
        }
        g.setColor(oldColor);
    }

    public Object clone() {
        return new JDiamondHead(this.getWidth(), this.getHeight(), this.getFilled());
    }
}

