/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.BendUI;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.GrabUI;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JGrab
extends JBend {
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    private Direction orientation = Direction.LEFT;
    private boolean autoOrientation = true;
    private double alignment = 0.5;
    private boolean autoAlignment = true;
    private GrabManager manager = null;

    public JGrab() {
    }

    public JGrab(GrabManager manager) {
        this();
        this.setManager(manager);
    }

    public JGrab(JComponent target) {
        this();
        this.setTarget(target);
    }

    public void setOrientation(Direction orientation) {
        GrabManager manager;
        boolean changed = false;
        if (this.isAutoOrientation()) {
            this.autoOrientation = false;
            changed = true;
        }
        if (orientation != this.orientation) {
            this.setLayoutOrientation(orientation);
            changed = true;
        }
        if (changed && (manager = this.getManager()) != null) {
            manager.revalidate();
        }
    }

    public Direction getOrientation() {
        return this.orientation;
    }

    public void setLayoutOrientation(Direction orientation) {
        if (this.orientation != orientation) {
            Direction old = this.orientation;
            this.orientation = orientation;
            this.revalidate();
            this.resetPoint();
            this.firePropertyChange("orientation", old, orientation);
        }
    }

    public void setAutoOrientation(boolean auto) {
        if (auto != this.autoOrientation) {
            this.autoOrientation = auto;
            if (auto && this.manager != null) {
                this.manager.revalidate();
            }
        }
    }

    public boolean isAutoOrientation() {
        return this.autoOrientation;
    }

    public void setAlignment(double align) {
        GrabManager manager;
        if (align > 1.0) {
            align = 1.0;
        }
        if (align < 0.0) {
            align = 0.0;
        }
        boolean changed = false;
        if (this.isAutoAlignment()) {
            this.autoAlignment = false;
            changed = true;
        }
        if (this.alignment != align) {
            this.setLayoutAlignment(align);
            changed = true;
        }
        if (changed && (manager = this.getManager()) != null) {
            manager.revalidate();
        }
    }

    public void setLayoutAlignment(double align) {
        if (this.alignment != align) {
            double old = this.alignment;
            this.alignment = align;
            this.firePropertyChange("alignment", old, align);
        }
    }

    public double getAlignment() {
        return this.alignment;
    }

    public void setAutoAlignment(boolean auto) {
        if (auto != this.autoAlignment) {
            this.autoAlignment = auto;
            if (auto && this.manager != null) {
                this.manager.revalidate();
            }
        }
    }

    public boolean isAutoAlignment() {
        return this.autoAlignment;
    }

    public int getTouchOffset() {
        if (this.ui != null && this.ui instanceof GrabUI) {
            return ((GrabUI)this.ui).getTouchOffset(this);
        }
        return 0;
    }

    public int getTouchLength() {
        if (this.ui != null && this.ui instanceof GrabUI) {
            return ((GrabUI)this.ui).getTouchLength(this);
        }
        if (this.getOrientation() == Direction.LEFT || this.getOrientation() == Direction.RIGHT) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    public int getAlignmentOffset() {
        if (this.ui != null && this.ui instanceof GrabUI) {
            return ((GrabUI)this.ui).getAlignmentOffset(this);
        }
        return this.getTouchOffset() + this.getTouchLength() / 2;
    }

    public int getPadOffset() {
        int offset = 0;
        if (this.ui != null && this.ui instanceof GrabUI) {
            offset = ((GrabUI)this.ui).getPadOffset(this);
        }
        return offset;
    }

    public void setPoint(int x, int y) {
    }

    protected Point calculatePoint() {
        if (this.ui != null && this.ui instanceof BendUI) {
            return ((BendUI)this.ui).calculatePoint(this);
        }
        Rectangle bounds = this.getBounds();
        Point point = new Point();
        if (this.getOrientation() == Direction.LEFT) {
            point.x = bounds.x;
            point.y = bounds.y + bounds.height / 2;
        } else if (this.getOrientation() == Direction.RIGHT) {
            point.x = bounds.x + bounds.width - 1;
            point.y = bounds.y + bounds.height / 2;
        } else if (this.getOrientation() == Direction.BOTTOM) {
            point.x = bounds.x + bounds.width / 2;
            point.y = bounds.y + bounds.height - 1;
        } else {
            point.x = bounds.x + bounds.width / 2;
            point.y = bounds.y;
        }
        return point;
    }

    public void setBounds(int x, int y, int width, int height) {
        GrabManager manager;
        Rectangle bounds = this.getBounds();
        super.setBounds(x, y, width, height);
        if ((width != bounds.width || height != bounds.height) && (manager = this.getManager()) != null) {
            manager.revalidate();
        }
    }

    public boolean setManager(GrabManager value) {
        boolean changed = false;
        if (this.manager != value) {
            GrabManager oldValue = this.manager;
            if (this.manager != null) {
                this.manager = null;
                oldValue.removeFromGrabs(this);
            }
            this.manager = value;
            if (value != null) {
                value.addToGrabs(this);
            }
            this.firePropertyChange("manager", oldValue, value);
            changed = true;
        }
        return changed;
    }

    public GrabManager getManager() {
        return this.manager;
    }

    public void setTarget(JComponent target) {
        GrabManager manager = this.getManager();
        if (manager != null && manager.getTarget() == target) {
            return;
        }
        if (target == null) {
            this.setManager(null);
        } else {
            manager = (GrabManager)target.getClientProperty("GrabManager");
            if (manager == null) {
                manager = new GrabManager(target);
            }
            this.setManager(manager);
        }
    }

    public JComponent getTarget() {
        GrabManager manager = this.getManager();
        return manager == null ? null : manager.getTarget();
    }
}

