/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JLifeLineSegment
extends JComponent {
    public static final int CHANGE_NONE = 0;
    public static final int CHANGE_ABOVE = 1;
    public static final int CHANGE_BELOW = 2;
    public static final int CHANGE_BOTH = 3;
    private int change;
    private int changeBelowLevel = 1;
    private int[] barcode;
    public static int columnWidth = 16;

    public JLifeLineSegment() {
        this.setOpaque(false);
        this.barcode = new int[0];
        this.change = 0;
    }

    public JLifeLineSegment(int[] barcode, int change) {
        this.setOpaque(false);
        this.barcode = barcode;
        this.change = change;
    }

    public JLifeLineSegment(int[] barcode, int change, int changeBelowLevel) {
        this.setOpaque(false);
        this.barcode = barcode;
        this.change = change;
        this.changeBelowLevel = changeBelowLevel;
    }

    public void setbarcode(int[] barcode) {
        this.barcode = barcode;
    }

    public int[] getBarcode() {
        return this.barcode;
    }

    public void setChange(int change) {
        this.change = change;
    }

    public int getChange() {
        return this.change;
    }

    public Dimension getPreferredSize() {
        return new Dimension(columnWidth + 6 * this.barcode.length, columnWidth * 2);
    }

    public void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        Rectangle bounds = this.getBounds();
        int hWidth = columnWidth / 2;
        int center = bounds.width / 2;
        g.setColor(this.getForeground());
        if (this.barcode.length == 0) {
            g.drawLine(center, 0, center, bounds.height);
        } else {
            int i = 0;
            while (i < this.barcode.length) {
                if (this.barcode[i] == 2) {
                    g.setColor(Color.black);
                } else if (this.barcode[i] == 1) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.getBackground());
                }
                g.fillRect(center - hWidth + i * 6, 0, center + hWidth + i * 6, bounds.height);
                g.setColor(this.getForeground());
                g.drawLine(center - hWidth + i * 6, 0, center - hWidth + i * 6, bounds.height);
                g.drawLine(center + hWidth + i * 6, 0, center + hWidth + i * 6, bounds.height);
                if ((this.change == 2 || this.change == 3) && this.barcode.length - i <= this.changeBelowLevel) {
                    g.drawLine(center - hWidth + i * 6, bounds.height - 1, center + hWidth + i * 6, bounds.height - 1);
                }
                ++i;
            }
            if (this.change == 1 || this.change == 3) {
                g.drawLine(center - hWidth + (this.barcode.length - 1) * 6, 0, center + hWidth + (this.barcode.length - 1) * 6, 0);
            }
        }
        g.setColor(oldColor);
    }
}

