/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JStickMan
extends JComponent {
    public void setHeight(int height) {
        this.setSize(this.width(height), height);
    }

    public JStickMan() {
        this.setHeight(50);
    }

    public JStickMan(int height) {
        this.setHeight(50);
    }

    private int width(int height) {
        return 2 * height / 3;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width(this.getHeight()), this.getHeight());
    }

    protected void paintComponent(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        int height = this.getHeight();
        int width = this.width(height);
        int head_diameter = height / 3;
        int legs_height = 3 * height / 10;
        int legs_width = 2 * width / 5;
        int arms_height = height / 6;
        int arms_width = width / 2;
        int body_height = height - head_diameter - legs_height;
        int x_middle = this.getWidth() / 2;
        int head_x = x_middle - head_diameter / 2;
        int head_y = 0;
        int body_x = x_middle;
        int body_y1 = head_y + head_diameter;
        int body_y2 = body_y1 + body_height;
        int lleg_x1 = body_x;
        int lleg_y1 = body_y2;
        int lleg_x2 = body_x - legs_width;
        int lleg_y2 = lleg_y1 + legs_height;
        int rleg_x1 = body_x;
        int rleg_y1 = body_y2;
        int rleg_x2 = body_x + legs_width;
        int rleg_y2 = rleg_y1 + legs_height;
        int larm_x1 = body_x;
        int larm_y1 = body_y1 + body_height / 3;
        int larm_x2 = larm_x1 - arms_width;
        int larm_y2 = larm_y1 - arms_height;
        int rarm_x1 = body_x;
        int rarm_y1 = body_y1 + body_height / 3;
        int rarm_x2 = rarm_x1 + arms_width;
        int rarm_y2 = rarm_y1 - arms_height;
        g.drawOval(head_x, head_y, head_diameter, head_diameter);
        g.drawLine(body_x, body_y1, body_x, body_y2);
        g.drawLine(lleg_x1, lleg_y1, lleg_x2, lleg_y2);
        g.drawLine(rleg_x1, rleg_y1, rleg_x2, rleg_y2);
        g.drawLine(larm_x1, larm_y1, larm_x2, larm_y2);
        g.drawLine(rarm_x1, rarm_y1, rarm_x2, rarm_y2);
        g.setColor(oldColor);
    }

    public void reshape(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (x != bounds.x || y != bounds.y || width != bounds.width || height != bounds.height) {
            super.reshape(x, y, width, height);
            if (x != bounds.x || y != bounds.y) {
                this.firePropertyChange("location", bounds.getLocation(), new Point(x, y));
            }
            if (width != bounds.width || height != bounds.height) {
                this.firePropertyChange("size", bounds.getSize(), new Dimension(width, height));
            }
            this.firePropertyChange("bounds", bounds, new Rectangle(x, y, width, height));
        }
    }
}

