/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.EditableTextComponent;
import de.uni_paderborn.fujaba.fsa.swing.EditorManager;
import de.uni_paderborn.fujaba.fsa.swing.IntegerVerifier;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class JTextFieldLabel
extends EditableTextComponent
implements ActionListener,
FocusListener {
    private boolean numbersOnly;
    static /* synthetic */ Class class$0;

    public JTextFieldLabel() {
    }

    public JTextFieldLabel(boolean numbersOnly) {
        this.numbersOnly = numbersOnly;
    }

    protected void updateEditor(JComponent component) {
        if (component instanceof JTextField) {
            JTextField textField = (JTextField)component;
            textField.setText(this.getText());
        }
    }

    protected void enableEditor(JComponent component) {
        if (component instanceof JTextField) {
            super.enableEditor(component);
            JTextField textField = (JTextField)component;
            textField.setText(this.getText());
            textField.setFont(this.getFont());
            textField.setHorizontalAlignment(this.getHorizontalAlignment());
            textField.addFocusListener(this);
            textField.addActionListener(this);
            if (this.numbersOnly) {
                textField.setInputVerifier(IntegerVerifier.get());
            } else {
                textField.setInputVerifier(null);
            }
            if (this.hasFocus() || this.getLabel().hasFocus()) {
                textField.requestFocus();
            }
        }
    }

    protected void disableEditor(JComponent component) {
        if (component instanceof JTextField) {
            super.disableEditor(component);
            JTextField textField = (JTextField)component;
            textField.removeActionListener(this);
            textField.removeFocusListener(this);
            this.setText(textField.getText());
            if (textField.hasFocus()) {
                this.getLabel().requestFocus();
            }
        }
    }

    protected String getEditorClassName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.JTextField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    protected void updateJLabel() {
        this.getLabel().setText(this.getText());
    }

    public int getNumber() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setNumber(int number) {
        int oldNumber = this.getNumber();
        this.setText(Integer.toString(number));
        this.firePropertyChange("number", new Integer(oldNumber), new Integer(number));
    }

    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this.getLabel().setVisible(vis);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEditing()) {
            JTextField textField = (JTextField)EditorManager.get().getEditor(this.getClass().getName(), this.getEditorClassName());
            if (this.numbersOnly) {
                int number = 0;
                try {
                    number = Integer.parseInt(textField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.setNumber(number);
            } else {
                this.setText(textField.getText());
            }
            this.setDisplayMode();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.isEditing()) {
            this.setDisplayMode();
        }
    }
}

