/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.DecoratorLayout;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import de.uni_paderborn.fujaba.fsa.swing.JPolyLine;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;

public abstract class LineUI
extends ComponentUI {
    private static final transient Logger log;
    public static final Stroke PLAIN_STROKE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.LineUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        PLAIN_STROKE = new BasicStroke();
    }

    public boolean contains(JComponent c, int x, int y) {
        JLine line = (JLine)c;
        return line.getDistance(x + line.getX(), y + line.getY()) < line.getDelta();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredBounds(c).getSize();
    }

    public Rectangle getPreferredBounds(JComponent c) {
        boolean debug = c instanceof JPolyLine.LineSegment;
        debug = false;
        if (debug && log.isInfoEnabled()) {
            log.info((Object)"getPreferredBounds():");
        }
        JLine line = (JLine)c;
        Rectangle lineBounds = this.getPreferredLineBounds(line);
        if (debug && log.isInfoEnabled()) {
            log.info((Object)("\tline: " + lineBounds));
        }
        if (c.getComponentCount() > 0) {
            Rectangle layoutBounds;
            LayoutManager layout = c.getLayout();
            Rectangle rectangle = layoutBounds = layout != null && layout instanceof DecoratorLayout ? ((DecoratorLayout)layout).preferredLayoutBounds(c) : new Rectangle(layout.preferredLayoutSize(c));
            if (debug && log.isInfoEnabled()) {
                log.info((Object)("\tlayout: " + layoutBounds));
            }
            Point oldLoc = line.getLocation();
            layoutBounds.translate(oldLoc.x, oldLoc.y);
            if (debug && log.isInfoEnabled()) {
                log.info((Object)("\tlayout: " + layoutBounds));
            }
            lineBounds.add(layoutBounds);
        }
        if (debug && log.isInfoEnabled()) {
            log.info((Object)("total: " + lineBounds));
        }
        return lineBounds;
    }

    public abstract Rectangle getPreferredLineBounds(JLine var1);

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        JLine jLine = (JLine)c;
        Stroke stroke = jLine.getStroke();
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            oldStroke = g2d.getStroke();
            if (stroke == null) {
                stroke = PLAIN_STROKE;
            }
            g2d.setStroke(stroke);
            this.paintLine(g, jLine);
            g2d.setStroke(oldStroke);
        } else {
            this.paintLine(g, jLine);
        }
    }

    public abstract void paintLine(Graphics var1, JLine var2);
}

